/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.UnionRoleImpl;
import mondrian.olap.Util;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleImpl
implements Role {
    private boolean mutable = true;
    private final Map<Schema, Access> schemaGrants = new HashMap<Schema, Access>();
    private final Map<Cube, Access> cubeGrants = new HashMap<Cube, Access>();
    private final Map<Dimension, Access> dimensionGrants = new HashMap<Dimension, Access>();
    private final Map<Hierarchy, HierarchyAccessImpl> hierarchyGrants = new HashMap<Hierarchy, HierarchyAccessImpl>();

    protected RoleImpl clone() {
        RoleImpl role = new RoleImpl();
        role.mutable = this.mutable;
        role.schemaGrants.putAll(this.schemaGrants);
        role.cubeGrants.putAll(this.cubeGrants);
        role.dimensionGrants.putAll(this.dimensionGrants);
        for (Map.Entry<Hierarchy, HierarchyAccessImpl> entry : this.hierarchyGrants.entrySet()) {
            role.hierarchyGrants.put(entry.getKey(), (HierarchyAccessImpl)entry.getValue().clone());
        }
        return role;
    }

    public RoleImpl makeMutableClone() {
        RoleImpl role = this.clone();
        role.mutable = true;
        return role;
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void grant(Schema schema, Access access) {
        assert (schema != null);
        assert (access == Access.ALL || access == Access.NONE || access == Access.ALL_DIMENSIONS);
        assert (this.isMutable());
        this.schemaGrants.put(schema, access);
    }

    @Override
    public Access getAccess(Schema schema) {
        assert (schema != null);
        return RoleImpl.toAccess(this.schemaGrants.get(schema));
    }

    private static Access toAccess(Access access) {
        return access == null ? Access.NONE : access;
    }

    public void grant(Cube cube, Access access) {
        Util.assertPrecondition(cube != null, "cube != null");
        assert (access == Access.ALL || access == Access.NONE);
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.cubeGrants.put(cube, access);
    }

    @Override
    public Access getAccess(Cube cube) {
        assert (cube != null);
        Access access = this.cubeGrants.get(cube);
        if (access == null) {
            access = this.schemaGrants.get(cube.getSchema());
        }
        return RoleImpl.toAccess(access);
    }

    public void removeTopLevels() {
        for (Map.Entry<Hierarchy, HierarchyAccessImpl> entry : this.hierarchyGrants.entrySet()) {
            HierarchyAccessImpl hierarchyAccess = entry.getValue();
            if (hierarchyAccess.topLevel == null) continue;
            HierarchyAccessImpl hierarchyAccessClone = new HierarchyAccessImpl(hierarchyAccess.hierarchy, hierarchyAccess.access, null, hierarchyAccess.bottomLevel, hierarchyAccess.rollupPolicy);
            hierarchyAccessClone.memberGrants.putAll(hierarchyAccess.memberGrants);
            entry.setValue(hierarchyAccessClone);
        }
    }

    public void grant(Dimension dimension, Access access) {
        assert (dimension != null);
        assert (access == Access.ALL || access == Access.NONE);
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.dimensionGrants.put(dimension, access);
    }

    @Override
    public Access getAccess(Dimension dimension) {
        assert (dimension != null);
        Access access = this.dimensionGrants.get(dimension);
        if (access != null) {
            return RoleImpl.toAccess(access);
        }
        for (Map.Entry<Cube, Access> cubeGrant : this.cubeGrants.entrySet()) {
            Dimension[] dimensions;
            access = RoleImpl.toAccess(cubeGrant.getValue());
            if (access == Access.NONE) continue;
            for (Dimension dimension1 : dimensions = cubeGrant.getKey().getDimensions()) {
                if (dimension == dimension1) {
                    return access;
                }
                if (dimension instanceof RolapCubeDimension && dimension.equals(dimension1) && !((RolapCubeDimension)dimension1).getCube().equals(cubeGrant.getKey()) || !(cubeGrant.getKey() instanceof RolapCube) || !((RolapCube)cubeGrant.getKey()).isVirtual() || !dimension.equals(dimension1)) continue;
                return access;
            }
        }
        switch (this.getAccess(dimension.getSchema())) {
            case ALL: 
            case ALL_DIMENSIONS: {
                return Access.ALL;
            }
        }
        return Access.NONE;
    }

    public void grant(Hierarchy hierarchy, Access access, Level topLevel, Level bottomLevel, Role.RollupPolicy rollupPolicy) {
        assert (hierarchy != null);
        assert (access != null);
        assert (access == Access.CUSTOM || topLevel == null && bottomLevel == null);
        assert (topLevel == null || topLevel.getHierarchy() == hierarchy);
        assert (bottomLevel == null || bottomLevel.getHierarchy() == hierarchy);
        assert (this.isMutable());
        assert (rollupPolicy != null);
        this.hierarchyGrants.put(hierarchy, new HierarchyAccessImpl(hierarchy, access, topLevel, bottomLevel, rollupPolicy));
    }

    @Override
    public Access getAccess(Hierarchy hierarchy) {
        assert (hierarchy != null);
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(hierarchy);
        if (hierarchyAccess != null) {
            return hierarchyAccess.access;
        }
        return this.getAccess(hierarchy.getDimension());
    }

    @Override
    public Role.HierarchyAccess getAccessDetails(Hierarchy hierarchy) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        return this.hierarchyGrants.get(hierarchy);
    }

    @Override
    public Access getAccess(Level level) {
        assert (level != null);
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(level.getHierarchy());
        if (hierarchyAccess != null) {
            if (hierarchyAccess.topLevel != null && level.getDepth() < hierarchyAccess.topLevel.getDepth()) {
                return Access.NONE;
            }
            if (hierarchyAccess.bottomLevel != null && level.getDepth() > hierarchyAccess.bottomLevel.getDepth()) {
                return Access.NONE;
            }
            return hierarchyAccess.access;
        }
        return this.getAccess(level.getDimension());
    }

    public void grant(Member member, Access access) {
        Util.assertPrecondition(member != null, "member != null");
        assert (this.isMutable());
        assert (this.getAccess(member.getHierarchy()) == Access.CUSTOM);
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(member.getHierarchy());
        assert (hierarchyAccess != null);
        assert (hierarchyAccess.access == Access.CUSTOM);
        hierarchyAccess.grant(member, access);
    }

    @Override
    public Access getAccess(Member member) {
        assert (member != null);
        if (member.isCalculatedInQuery()) {
            return Access.ALL;
        }
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(member.getHierarchy());
        if (hierarchyAccess != null) {
            return hierarchyAccess.getAccess(member);
        }
        return this.getAccess(member.getDimension());
    }

    @Override
    public Access getAccess(NamedSet set) {
        Util.assertPrecondition(set != null, "set != null");
        return Access.ALL;
    }

    @Override
    public boolean canAccess(OlapElement olapElement) {
        Util.assertPrecondition(olapElement != null, "olapElement != null");
        if (olapElement instanceof Member) {
            return this.getAccess((Member)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Level) {
            return this.getAccess((Level)olapElement) != Access.NONE;
        }
        if (olapElement instanceof NamedSet) {
            return this.getAccess((NamedSet)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Hierarchy) {
            return this.getAccess((Hierarchy)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Cube) {
            return this.getAccess((Cube)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Dimension) {
            return this.getAccess((Dimension)olapElement) != Access.NONE;
        }
        return false;
    }

    public static Role.HierarchyAccess createAllAccess(Hierarchy hierarchy) {
        Level[] levels = hierarchy.getLevels();
        return new HierarchyAccessImpl(hierarchy, Access.ALL, levels[0], levels[levels.length - 1], Role.RollupPolicy.FULL);
    }

    public static Role union(List<Role> roleList) {
        assert (roleList.size() > 0);
        return new UnionRoleImpl(roleList);
    }

    static class CachingHierarchyAccess
    extends DelegatingHierarchyAccess {
        private final Map<Member, Access> memberAccessMap = new WeakHashMap<Member, Access>();
        private Role.RollupPolicy rollupPolicy;
        private Map<Member, Boolean> inaccessibleDescendantsMap = new WeakHashMap<Member, Boolean>();
        private Integer topLevelDepth;
        private Integer bottomLevelDepth;

        public CachingHierarchyAccess(Role.HierarchyAccess hierarchyAccess) {
            super(hierarchyAccess);
        }

        public Access getAccess(Member member) {
            Access access = this.memberAccessMap.get(member);
            if (access != null) {
                return access;
            }
            access = this.hierarchyAccess.getAccess(member);
            this.memberAccessMap.put(member, access);
            return access;
        }

        public int getTopLevelDepth() {
            if (this.topLevelDepth == null) {
                this.topLevelDepth = this.hierarchyAccess.getTopLevelDepth();
            }
            return this.topLevelDepth;
        }

        public int getBottomLevelDepth() {
            if (this.bottomLevelDepth == null) {
                this.bottomLevelDepth = this.hierarchyAccess.getBottomLevelDepth();
            }
            return this.bottomLevelDepth;
        }

        public Role.RollupPolicy getRollupPolicy() {
            if (this.rollupPolicy == null) {
                this.rollupPolicy = this.hierarchyAccess.getRollupPolicy();
            }
            return this.rollupPolicy;
        }

        public boolean hasInaccessibleDescendants(Member member) {
            Boolean b = this.inaccessibleDescendantsMap.get(member);
            if (b == null) {
                b = this.hierarchyAccess.hasInaccessibleDescendants(member);
                this.inaccessibleDescendantsMap.put(member, b);
            }
            return b;
        }
    }

    public static abstract class DelegatingHierarchyAccess
    implements Role.HierarchyAccess {
        protected final Role.HierarchyAccess hierarchyAccess;

        public DelegatingHierarchyAccess(Role.HierarchyAccess hierarchyAccess) {
            assert (hierarchyAccess != null);
            this.hierarchyAccess = hierarchyAccess;
        }

        public Access getAccess(Member member) {
            return this.hierarchyAccess.getAccess(member);
        }

        public int getTopLevelDepth() {
            return this.hierarchyAccess.getTopLevelDepth();
        }

        public int getBottomLevelDepth() {
            return this.hierarchyAccess.getBottomLevelDepth();
        }

        public Role.RollupPolicy getRollupPolicy() {
            return this.hierarchyAccess.getRollupPolicy();
        }

        public boolean hasInaccessibleDescendants(Member member) {
            return this.hierarchyAccess.hasInaccessibleDescendants(member);
        }
    }

    private static class HierarchyAccessImpl
    implements Role.HierarchyAccess {
        private final Hierarchy hierarchy;
        private final Level topLevel;
        private final Access access;
        private final Level bottomLevel;
        private final Map<Member, Access> memberGrants = new HashMap<Member, Access>();
        private final Role.RollupPolicy rollupPolicy;

        HierarchyAccessImpl(Hierarchy hierarchy, Access access, Level topLevel, Level bottomLevel, Role.RollupPolicy rollupPolicy) {
            assert (access != null);
            this.hierarchy = hierarchy;
            this.access = access;
            Level[] levels = hierarchy.getLevels();
            this.topLevel = topLevel == null ? levels[0] : topLevel;
            Level level = this.bottomLevel = bottomLevel == null ? levels[levels.length - 1] : bottomLevel;
            assert (rollupPolicy != null);
            this.rollupPolicy = rollupPolicy;
        }

        public Role.HierarchyAccess clone() {
            HierarchyAccessImpl hierarchyAccess = new HierarchyAccessImpl(this.hierarchy, this.access, this.topLevel, this.bottomLevel, this.rollupPolicy);
            hierarchyAccess.memberGrants.putAll(this.memberGrants);
            return hierarchyAccess;
        }

        void grant(Member member, Access access) {
            Member m;
            Util.assertTrue(member.getHierarchy() == this.hierarchy);
            Iterator<Member> memberIter = this.memberGrants.keySet().iterator();
            while (memberIter.hasNext()) {
                Member m2 = memberIter.next();
                if (!m2.isChildOrEqualTo(member)) continue;
                memberIter.remove();
            }
            this.memberGrants.put(member, access);
            if (access == Access.NONE) {
                for (m = member.getParentMember(); m != null; m = m.getParentMember()) {
                    Access memberAccess = this.memberGrants.get(m);
                    if (memberAccess == null) {
                        if (this.childGrantsExist(m)) {
                            this.memberGrants.put(m, Access.CUSTOM);
                            continue;
                        }
                    } else if (memberAccess == Access.CUSTOM) {
                        if (this.childGrantsExist(m)) {
                            this.memberGrants.put(m, Access.CUSTOM);
                            continue;
                        }
                    } else if (memberAccess != Access.NONE && memberAccess != Access.ALL) {
                        continue;
                    }
                    break;
                }
            } else {
                block5: for (m = member.getParentMember(); m != null; m = m.getParentMember()) {
                    switch (RoleImpl.toAccess(this.memberGrants.get(m))) {
                        case NONE: {
                            this.memberGrants.put(m, Access.CUSTOM);
                            continue block5;
                        }
                    }
                }
            }
        }

        private boolean childGrantsExist(Member parent) {
            for (Map.Entry<Member, Access> entry : this.memberGrants.entrySet()) {
                Access access;
                Member member = entry.getKey();
                if (member.getParentMember() != parent || (access = RoleImpl.toAccess(entry.getValue())) == Access.NONE) continue;
                return true;
            }
            return false;
        }

        public Access getAccess(Member member) {
            if (this.access != Access.CUSTOM) {
                return this.access;
            }
            if (member.getLevel().getDepth() < this.getTopLevelDepth()) {
                return Access.NONE;
            }
            if (member.getLevel().getDepth() > this.getBottomLevelDepth()) {
                return Access.NONE;
            }
            for (Member m = member; m != null; m = m.getParentMember()) {
                Access memberAccess = this.memberGrants.get(m);
                if (memberAccess == null) continue;
                if (memberAccess == Access.CUSTOM && m != member) {
                    return Access.NONE;
                }
                return memberAccess;
            }
            block4: for (Map.Entry<Member, Access> entry : this.memberGrants.entrySet()) {
                Member grantedMember = entry.getKey();
                switch (entry.getValue()) {
                    case NONE: {
                        continue block4;
                    }
                }
                for (Member m = grantedMember; m != null; m = m.getParentMember()) {
                    if (m == member) {
                        return Access.CUSTOM;
                    }
                    if (m != grantedMember && this.memberGrants.get(m) != null) continue block4;
                }
            }
            return Access.NONE;
        }

        public final int getTopLevelDepth() {
            return this.topLevel.getDepth();
        }

        public final int getBottomLevelDepth() {
            return this.bottomLevel.getDepth();
        }

        public Role.RollupPolicy getRollupPolicy() {
            return this.rollupPolicy;
        }

        public boolean hasInaccessibleDescendants(Member member) {
            for (Map.Entry<Member, Access> entry : this.memberGrants.entrySet()) {
                switch (entry.getValue()) {
                    case NONE: {
                        Member grantedMember;
                        for (Member m = grantedMember = entry.getKey(); m != null; m = m.getParentMember()) {
                            if (!m.equals(member)) continue;
                            return true;
                        }
                        break;
                    }
                }
            }
            return false;
        }
    }
}

