/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.tags;

import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.tags.MondrianModelFactory;
import com.tonbeller.jpivot.tags.OlapModelTag;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.RequestContext;
import java.io.IOException;
import java.net.URL;
import javax.servlet.jsp.JspException;
import org.xml.sax.SAXException;

public class MondrianOlapModelTag
extends OlapModelTag {
    String dataSource;
    String jdbcDriver;
    String jdbcUser;
    String jdbcPassword;
    String jdbcUrl;
    String catalogUri;
    String config;
    String role;
    String dynResolver;
    String dynLocale;
    String connectionPooling;
    String dataSourceChangeListener;
    Resources res = Resources.instance();

    protected OlapModel getOlapModel(RequestContext context) throws JspException, OlapException, SAXException, IOException {
        MondrianModelFactory.Config cfg = new MondrianModelFactory.Config();
        String schemaUrl = this.catalogUri.startsWith("/") ? this.pageContext.getServletContext().getResource(this.catalogUri).toExternalForm() : this.catalogUri;
        cfg.setMdxQuery(this.getBodyContent().getString());
        cfg.setSchemaUrl("\"" + schemaUrl + "\"");
        cfg.setJdbcUrl(this.jdbcUrl);
        cfg.setJdbcDriver(this.jdbcDriver);
        cfg.setJdbcUser(this.jdbcUser);
        cfg.setJdbcPassword(this.jdbcPassword);
        cfg.setDataSource(this.dataSource);
        cfg.setRole(this.role);
        cfg.setDynResolver(this.dynResolver);
        cfg.setDynLocale(this.dynLocale);
        cfg.setConnectionPooling(this.connectionPooling);
        cfg.setDataSourceChangeListener(this.dataSourceChangeListener);
        this.allowOverride(context, cfg);
        URL url = this.config == null ? this.getDefaultConfig() : this.pageContext.getServletContext().getResource(this.config);
        MondrianModel mm = MondrianModelFactory.instance(url, cfg);
        OlapModel om = (OlapModel)mm.getTopDecorator();
        om.setLocale(context.getLocale());
        om.setServletContext(context.getSession().getServletContext());
        return om;
    }

    protected void allowOverride(RequestContext context, MondrianModelFactory.Config cfg) {
        cfg.allowOverride(context);
    }

    protected URL getDefaultConfig() {
        return MondrianOlapModelTag.class.getResource("/com/tonbeller/jpivot/mondrian/config.xml");
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setCatalogUri(String catalogUri) {
        this.catalogUri = catalogUri;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getDynResolver() {
        return this.dynResolver;
    }

    public void setDynResolver(String dynResolver) {
        this.dynResolver = dynResolver;
    }

    public void setConnectionPooling(String connectionPooling) {
        this.connectionPooling = connectionPooling;
    }

    public String getConnectionPooling() {
        return this.connectionPooling;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getRole() {
        return this.role;
    }

    public String getDynLocale() {
        return this.dynLocale;
    }

    public void setDynLocale(String dynLocale) {
        this.dynLocale = dynLocale;
    }

    public String getDataSourceChangeListener() {
        return this.dataSourceChangeListener;
    }

    public void setDataSourceChangeListener(String dataSourceChangeListener) {
        this.dataSourceChangeListener = dataSourceChangeListener;
    }
}

