/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.model;

import com.tonbeller.jpivot.olap.model.BooleanExpr;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.DoubleExpr;
import com.tonbeller.jpivot.olap.model.Expression;
import com.tonbeller.jpivot.olap.model.FunCallExpr;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.IntegerExpr;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.ParameterExpr;
import com.tonbeller.jpivot.olap.model.PropertyExpr;
import com.tonbeller.jpivot.olap.model.StringExpr;
import com.tonbeller.jpivot.olap.model.Visitable;
import com.tonbeller.jpivot.olap.model.VisitorSupportStrict;
import java.util.HashSet;
import java.util.Set;

public class ExpressionPrinter
extends VisitorSupportStrict {
    StringBuffer sb = new StringBuffer();
    static final Set infix = new HashSet();
    static final Set prefix = new HashSet();

    public String print(Visitable e) {
        if (e == null) {
            return "(null)";
        }
        this.sb = new StringBuffer();
        e.accept(this);
        return this.sb.toString();
    }

    public String toString() {
        return this.sb.toString();
    }

    void append(String s) {
        this.sb.append(s);
    }

    public void visitBooleanExpr(BooleanExpr v) {
        this.sb.append(v.getValue());
    }

    public void visitDimension(Dimension v) {
        this.sb.append("[" + v.getLabel() + "]");
    }

    public void visitDoubleExpr(DoubleExpr v) {
        this.sb.append(v.getValue());
    }

    public void visitFunCallExpr(FunCallExpr v) {
        int i;
        ExpressionPrinter ep = new ExpressionPrinter();
        Expression[] args = v.getArgs();
        String name = v.getName();
        if (infix.contains(name) && args.length == 2) {
            String left = ep.print(args[0]);
            String right = ep.print(args[1]);
            this.sb.append(left).append(name).append(right);
            return;
        }
        for (i = 0; i < args.length; ++i) {
            if (i > 0) {
                ep.append(", ");
            }
            args[i].accept(ep);
        }
        if ("()".equals(name)) {
            this.sb.append("(").append(ep).append(")");
        } else if ("{}".equals(name)) {
            this.sb.append("{").append(ep).append("}");
        } else if (prefix.contains(name)) {
            this.sb.append(name).append(ep);
        } else if (name.startsWith(".")) {
            if (args.length > 1) {
                ep = new ExpressionPrinter();
                args[0].accept(ep);
                this.sb.append(ep).append(name).append("(");
                ep = new ExpressionPrinter();
                for (i = 1; i < args.length; ++i) {
                    if (i > 1) {
                        ep.append(", ");
                    }
                    args[i].accept(ep);
                }
                this.sb.append(ep).append(")");
            } else {
                this.sb.append(ep).append(name);
            }
        } else {
            this.sb.append(name).append("(").append(ep).append(")");
        }
    }

    public void visitHierarchy(Hierarchy v) {
        this.sb.append("[" + v.getLabel() + "]");
    }

    public void visitIntegerExpr(IntegerExpr v) {
        this.sb.append(v.getValue());
    }

    public void visitLevel(Level v) {
        this.sb.append("[" + v.getLabel() + "]");
    }

    public void visitMember(Member v) {
        this.sb.append("[" + v.getLabel() + "]");
    }

    public void visitParameterExpr(ParameterExpr v) {
        this.sb.append("Parameter(\"RandomID\"");
        switch (v.getType()) {
            case 2: {
                this.sb.append(", MEMBER");
                break;
            }
            case 1: {
                this.sb.append(", NUMBER");
                break;
            }
            case 0: {
                this.sb.append(", STRING");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.sb.append(", \"").append(v.getLabel()).append("\"");
        this.sb.append(", ");
        v.getValue().accept(this);
        this.sb.append(")");
    }

    public void visitStringExpr(StringExpr v) {
        this.sb.append("\"" + v.getValue() + "\"");
    }

    public void visitPropertyExpr(PropertyExpr v) {
        this.sb.append(v.getName()).append("=");
        v.getValueExpr().accept(this);
        this.sb.append(";");
    }

    static {
        String[] s = new String[]{"*", "/", "+", "-", "%", "<", ">", "<=", ">=", "<>", "=", "and", "or", "xor"};
        for (int i = 0; i < s.length; ++i) {
            infix.add(s[i]);
        }
        prefix.add("not");
        prefix.add("-");
    }
}

