/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRSwapFile;

public class JRConcurrentSwapFile
extends JRSwapFile {
    private final FileChannel fileChannel;

    public JRConcurrentSwapFile(String directory, int blockSize, int minGrowCount) {
        super(directory, blockSize, minGrowCount);
        this.fileChannel = this.file.getChannel();
    }

    protected void write(byte[] data, int dataSize, int dataOffset, long fileOffset) throws IOException {
        this.fileChannel.write(ByteBuffer.wrap(data, dataOffset, dataSize), fileOffset);
    }

    protected void read(byte[] data, int dataOffset, int dataLength, long fileOffset) throws IOException {
        int read;
        ByteBuffer buffer = ByteBuffer.wrap(data, dataOffset, dataLength);
        int totalRead = 0;
        do {
            if ((read = this.fileChannel.read(buffer, fileOffset + (long)totalRead)) >= 0) continue;
            throw new JRRuntimeException("Unable to read sufficient data from the swap file");
        } while ((totalRead += read) < dataLength);
    }
}

