/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.EvaluationType;
import net.sf.jasperreports.engine.fill.DatasetFillContext;

public class CompositeDatasetFilter
implements DatasetFilter {
    private List<DatasetFilter> filters;

    public static DatasetFilter combine(DatasetFilter filter, DatasetFilter other) {
        DatasetFilter combined = filter == null ? other : (other == null ? filter : new CompositeDatasetFilter(filter, other));
        return combined;
    }

    public CompositeDatasetFilter(DatasetFilter ... filters) {
        this.filters = Arrays.asList(filters);
    }

    public void init(DatasetFillContext context) {
        for (DatasetFilter filter : this.filters) {
            filter.init(context);
        }
    }

    public boolean matches(EvaluationType evaluation) {
        boolean matches = true;
        for (DatasetFilter filter : this.filters) {
            if (filter.matches(evaluation)) continue;
            matches = false;
            break;
        }
        return matches;
    }
}

