/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.style;

import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.dnd.JListTransfertHandler;
import it.businesslogic.ireport.gui.docking.GenericDragTargetListener;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.gui.event.StyleChangedEvent;
import it.businesslogic.ireport.gui.event.StyleChangedListener;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.gui.style.JBGList;
import it.businesslogic.ireport.gui.style.StyleDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StylesView
extends JPanel
implements LanguageChangedListener,
ReportFrameActivatedListener,
StyleChangedListener {
    private JReportFrame activeReportFrame = null;
    private DefaultListModel listModel = null;
    private JButton jButtonAddStyle;
    private JButton jButtonDeleteStyle;
    private JButton jButtonEditStyle;
    private JComboBox jComboBoxStyleType;
    private JBGList jListStyles;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;

    public StylesView() {
        this.initComponents();
        this.applyI18n();
        this.listModel = new DefaultListModel();
        this.jListStyles.setModel(this.listModel);
        this.jListStyles.setDropTarget(new DropTarget(this, 2, new GenericDragTargetListener(), true));
        this.jComboBoxStyleType.addItem(new Tag("reportStyles", I18n.getString("stylesView.reportStyles", "Report styles")));
        this.jComboBoxStyleType.addItem(new Tag("libraryStyles", I18n.getString("stylesView.stylesLibrary", "Styles library")));
        this.jListStyles.setTransferHandler(new JListTransfertHandler());
        this.languageChanged(null);
        MainFrame.getMainInstance().addReportFrameActivatedListener(this);
        this.updateStyles();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListStyles = new JBGList();
        this.jPanel1 = new JPanel();
        this.jComboBoxStyleType = new JComboBox();
        this.jToolBar1 = new JToolBar();
        this.jButtonAddStyle = new JButton();
        this.jButtonEditStyle = new JButton();
        this.jButtonDeleteStyle = new JButton();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jListStyles.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListStyles.setDragEnabled(true);
        this.jListStyles.setOpaque(false);
        this.jListStyles.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                StylesView.this.jListStylesValueChanged(evt);
            }
        });
        this.jListStyles.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StylesView.this.jListStylesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListStyles);
        this.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jComboBoxStyleType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jComboBoxStyleTypeActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 4);
        this.jPanel1.add((Component)this.jComboBoxStyleType, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jButtonAddStyle.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/styles/style_add.png")));
        this.jButtonAddStyle.setToolTipText("Style add");
        this.jButtonAddStyle.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonAddStyle.setFocusPainted(false);
        this.jButtonAddStyle.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonAddStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jButtonAddStyleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonAddStyle);
        this.jButtonEditStyle.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/styles/style_edit.png")));
        this.jButtonEditStyle.setToolTipText("Style add");
        this.jButtonEditStyle.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonEditStyle.setFocusPainted(false);
        this.jButtonEditStyle.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonEditStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jButtonEditStyleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonEditStyle);
        this.jButtonDeleteStyle.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/styles/style_delete.png")));
        this.jButtonDeleteStyle.setToolTipText("Style add");
        this.jButtonDeleteStyle.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonDeleteStyle.setFocusPainted(false);
        this.jButtonDeleteStyle.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonDeleteStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jButtonDeleteStyleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDeleteStyle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jToolBar1, gridBagConstraints);
        this.add((Component)this.jPanel1, "North");
    }

    private void jComboBoxStyleTypeActionPerformed(ActionEvent evt) {
        this.updateStyles();
    }

    private void jListStylesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonEditStyleActionPerformed(null);
            }
        }
    }

    private void jListStylesValueChanged(ListSelectionEvent evt) {
        if (this.jListStyles.getSelectedIndex() >= 0) {
            this.jButtonEditStyle.setEnabled(true);
            this.jButtonDeleteStyle.setEnabled(true);
        } else {
            this.jButtonEditStyle.setEnabled(false);
            this.jButtonDeleteStyle.setEnabled(false);
        }
    }

    private void jButtonDeleteStyleActionPerformed(ActionEvent evt) {
        if (this.jListStyles.getSelectedIndex() >= 0) {
            Style irc = null;
            try {
                irc = (Style)this.jListStyles.getSelectedValue();
            }
            catch (Exception ex) {
                return;
            }
            if (JOptionPane.showConfirmDialog(this, I18n.getString("messages.stylesDialog.removingStyle", "Do you want really remove this style?"), "", 1, 3) == 0) {
                if (!this.isListingReportStyles()) {
                    MainFrame.getMainInstance().getStyleLibrarySet().remove(irc);
                    MainFrame.getMainInstance().saveStyleLibrary();
                    this.getListModel().removeElement(irc);
                } else {
                    Report report = MainFrame.getMainInstance().getActiveReportFrame().getReport();
                    report.removeStyle(irc);
                }
            }
        }
    }

    private void jButtonEditStyleActionPerformed(ActionEvent evt) {
        StyleDialog cd = new StyleDialog((Frame)MainFrame.getMainInstance(), true);
        if (this.jListStyles.getSelectedValue() == null) {
            return;
        }
        int index = this.jListStyles.getSelectedIndex();
        Style irc = (Style)this.jListStyles.getSelectedValue();
        if (irc == null) {
            return;
        }
        cd.setStyle(irc);
        if (!this.isListingReportStyles()) {
            cd.setLibraryStyle(true);
        }
        cd.setVisible(true);
        if (cd.getDialogResult() == 0) {
            Style sub = cd.getStyle();
            try {
                this.getListModel().setElementAt(sub, index);
            }
            catch (Exception ex) {
                return;
            }
            if (!this.isListingReportStyles()) {
                MainFrame.getMainInstance().saveStyleLibrary();
            }
        }
    }

    private void jButtonAddStyleActionPerformed(ActionEvent evt) {
        StyleDialog cd = new StyleDialog((Frame)MainFrame.getMainInstance(), true);
        if (!this.isListingReportStyles()) {
            cd.setLibraryStyle(true);
        }
        cd.setVisible(true);
        if (cd.getDialogResult() == 0 && cd.isLibraryStyle()) {
            this.getListModel().addElement(cd.getStyle());
            MainFrame.getMainInstance().saveStyleLibrary();
        }
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.jButtonAddStyle.setToolTipText(I18n.getString("gui.style.newStyle", "New style"));
        this.jButtonEditStyle.setToolTipText(I18n.getString("gui.style.editStyle", "Edit style"));
        this.jButtonDeleteStyle.setToolTipText(I18n.getString("gui.style.deleteStyle", "Delete style"));
        for (int i = 0; i < this.jComboBoxStyleType.getItemCount(); ++i) {
            Tag t = (Tag)this.jComboBoxStyleType.getItemAt(i);
            if (t.getName().equals("reportStyles")) {
                t.setName(I18n.getString("gui.style.types.reportStyles", "Report styles"));
                continue;
            }
            if (!t.getName().equals("libraryStyles")) continue;
            t.setName(I18n.getString("gui.style.types.libraryStyles", "Styles Library"));
        }
    }

    public void reportFrameActivated(ReportFrameActivatedEvent evt) {
        this.setActiveReportFrame(evt.getReportFrame());
    }

    public JReportFrame getActiveReportFrame() {
        return this.activeReportFrame;
    }

    public void setActiveReportFrame(JReportFrame newActiveReportFrame) {
        if (newActiveReportFrame != this.activeReportFrame) {
            if (this.activeReportFrame != null) {
                this.activeReportFrame.getReport().removeStyleChangedListener(this);
            }
        } else {
            return;
        }
        this.activeReportFrame = newActiveReportFrame;
        if (this.activeReportFrame != null) {
            this.activeReportFrame.getReport().addStyleChangedListener(this);
        }
        this.updateStyles();
    }

    public void updateStyles() {
        block3: {
            block2: {
                this.getListModel().removeAllElements();
                this.jListStyles.setShowLibrary(!this.isListingReportStyles());
                if (!((Tag)this.jComboBoxStyleType.getSelectedItem()).getValue().equals("libraryStyles")) break block2;
                Vector v = MainFrame.getMainInstance().getStyleLibrarySet();
                for (int i = 0; i < v.size(); ++i) {
                    this.getListModel().addElement(v.elementAt(i));
                }
                break block3;
            }
            if (!((Tag)this.jComboBoxStyleType.getSelectedItem()).getValue().equals("reportStyles") || this.getActiveReportFrame() == null) break block3;
            Vector v = this.getActiveReportFrame().getReport().getStyles();
            for (int i = 0; i < v.size(); ++i) {
                this.getListModel().addElement(v.elementAt(i));
            }
        }
    }

    protected DefaultListModel getListModel() {
        return this.listModel;
    }

    protected void setListModel(DefaultListModel listModel) {
        this.listModel = listModel;
    }

    public void styleChanged(StyleChangedEvent evt) {
        if (evt.getSource() == this) {
            return;
        }
        this.updateStyles();
    }

    public boolean isListingReportStyles() {
        Tag t = (Tag)this.jComboBoxStyleType.getSelectedItem();
        return t != null && t.getValue().equals("reportStyles");
    }

    public void applyI18n() {
    }
}

