/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.JDragTable;
import it.businesslogic.ireport.gui.JRPropertyDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class DatasetPropertiesDialog
extends JDialog {
    private JButton jButtonClose;
    private JButton jButtonDeleteProperty;
    private JButton jButtonModifyProperty;
    private JButton jButtonNewProperty;
    private JPanel jPanel1;
    private JPanel jPanelButtons2;
    private JPanel jPanelFields;
    private JScrollPane jScrollPane3;
    private JDragTable jTableProperties;
    private SubDataset dataset;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public DatasetPropertiesDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public DatasetPropertiesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.setSize(420, 250);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableProperties.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DatasetPropertiesDialog.this.jTablePropertiesListSelectionValueChanged(e);
            }
        });
        this.applyI18n();
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DatasetPropertiesDialog.this.jButtonCloseActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    public void jTablePropertiesListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableProperties.getSelectedRowCount() > 0) {
            this.jButtonModifyProperty.setEnabled(true);
            this.jButtonDeleteProperty.setEnabled(true);
        } else {
            this.jButtonModifyProperty.setEnabled(false);
            this.jButtonDeleteProperty.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanelFields = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTableProperties = new JDragTable();
        this.jPanelButtons2 = new JPanel();
        this.jButtonNewProperty = new JButton();
        this.jButtonModifyProperty = new JButton();
        this.jButtonDeleteProperty = new JButton();
        this.jPanel1 = new JPanel();
        this.jButtonClose = new JButton();
        this.setTitle("Values");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DatasetPropertiesDialog.this.closeDialog(evt);
            }
        });
        this.jPanelFields.setLayout(new BorderLayout());
        this.jScrollPane3.setBackground(new Color(255, 255, 255));
        this.jScrollPane3.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jScrollPane3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DatasetPropertiesDialog.this.jScrollPane3MouseClicked(evt);
            }
        });
        this.jTableProperties.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = DatasetPropertiesDialog.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$String == null ? (class$java$lang$String = DatasetPropertiesDialog.class$("java.lang.String")) : class$java$lang$String};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableProperties.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DatasetPropertiesDialog.this.jTablePropertiesMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTableProperties);
        this.jPanelFields.add((Component)this.jScrollPane3, "Center");
        this.jPanelButtons2.setLayout(new GridBagLayout());
        this.jPanelButtons2.setPreferredSize(new Dimension(100, 100));
        this.jPanelButtons2.setMinimumSize(new Dimension(100, 10));
        this.jButtonNewProperty.setText("New");
        this.jButtonNewProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetPropertiesDialog.this.jButtonNewPropertyActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 4, 0, 4);
        this.jPanelButtons2.add((Component)this.jButtonNewProperty, gridBagConstraints);
        this.jButtonModifyProperty.setText("Modify");
        this.jButtonModifyProperty.setEnabled(false);
        this.jButtonModifyProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetPropertiesDialog.this.jButtonModifyPropertyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 4, 0, 4);
        this.jPanelButtons2.add((Component)this.jButtonModifyProperty, gridBagConstraints);
        this.jButtonDeleteProperty.setText("Delete");
        this.jButtonDeleteProperty.setEnabled(false);
        this.jButtonDeleteProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetPropertiesDialog.this.jButtonDeletePropertyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelButtons2.add((Component)this.jButtonDeleteProperty, gridBagConstraints);
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.jPanelButtons2.add((Component)this.jPanel1, gridBagConstraints);
        this.jButtonClose.setMnemonic('c');
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetPropertiesDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelButtons2.add((Component)this.jButtonClose, gridBagConstraints);
        this.jPanelFields.add((Component)this.jPanelButtons2, "East");
        this.getContentPane().add((Component)this.jPanelFields, "Center");
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jScrollPane3MouseClicked(MouseEvent evt) {
    }

    private void jTablePropertiesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1 && this.jTableProperties.getSelectedRow() >= 0) {
                this.jButtonModifyPropertyActionPerformed(new ActionEvent(this.jButtonModifyProperty, 0, ""));
            }
        }
    }

    private void jButtonNewPropertyActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        JRPropertyDialog jrpd = new JRPropertyDialog(parent, true);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            JRProperty property = jrpd.getProperty();
            this.getDataset().addJRProperty(property);
            this.updateProperties();
        }
    }

    private void jButtonModifyPropertyActionPerformed(ActionEvent evt) {
        JRProperty property = (JRProperty)this.jTableProperties.getValueAt(this.jTableProperties.getSelectedRow(), 0);
        Frame parent = Misc.frameFromComponent(this);
        JRPropertyDialog jrpd = new JRPropertyDialog(parent, true);
        jrpd.setProperty(property);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            property.setName(jrpd.getProperty().getName());
            property.setValue(jrpd.getProperty().getValue());
            this.updateProperties();
        }
    }

    private void jButtonDeletePropertyActionPerformed(ActionEvent evt) {
        this.jTableProperties.getSelectedRows();
        int[] rows = this.jTableProperties.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.getDataset().removeJRProperty((JRProperty)this.jTableProperties.getValueAt(rows[i], 0));
        }
        this.updateProperties();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public void setDataset(SubDataset dataset) {
        this.dataset = dataset;
        if (dataset == null) {
            this.setVisible(false);
            return;
        }
        if (this.isVisible()) {
            this.setTitle(dataset.getName() + " properties...");
            this.updateProperties();
        }
    }

    public void updateProperties() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        dtm.setRowCount(0);
        Enumeration e = this.getDataset().getJRproperties().elements();
        while (e.hasMoreElements()) {
            JRProperty property = (JRProperty)e.nextElement();
            Vector<Object> row = new Vector<Object>();
            row.addElement(property);
            row.addElement(property.getValue());
            dtm.addRow(row);
        }
    }

    public void applyI18n() {
        this.jButtonNewProperty.setText(I18n.getString("new", "New"));
        this.jButtonModifyProperty.setText(I18n.getString("modify", "Modify"));
        this.jButtonDeleteProperty.setText(I18n.getString("delete", "Delete"));
        this.jButtonClose.setText(I18n.getString("close", "Close"));
        this.jTableProperties.getColumnModel().getColumn(0).setHeaderValue(I18n.getString("propertiesDialog.tablecolumn.name", "Name"));
        this.jTableProperties.getColumnModel().getColumn(1).setHeaderValue(I18n.getString("propertiesDialog.tablecolumn.value", "Value"));
        this.setTitle(I18n.getString("propertiesDialog.title", "Properties"));
        this.jButtonClose.setMnemonic(I18n.getString("propertiesDialog.buttonCloseMnemonic", "c").charAt(0));
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        if (visible) {
            this.setDataset(this.dataset);
        }
    }

    public SubDataset getDataset() {
        return this.dataset;
    }
}

