/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.data;

import it.businesslogic.ireport.FieldsProvider;
import it.businesslogic.ireport.FieldsProviderEditor;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.connection.JRXMLADataSourceConnection;
import it.businesslogic.ireport.data.olap.CustomHTTPAuthenticator;
import it.businesslogic.ireport.data.olap.OlapBrowser;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ReportQueryDialog;
import it.businesslogic.ireport.util.I18n;
import java.net.Authenticator;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import rex.event.RexWizardEvent;
import rex.event.RexWizardListener;
import rex.graphics.mdxeditor.RexWizard;

public class MDXFieldsProvider
implements FieldsProvider,
RexWizardListener {
    private OlapBrowser olapBrowser = null;
    protected String getQueryFromRex = "";
    public static boolean useVisualDesigner = true;
    boolean gotMdxResult = false;

    public boolean supportsGetFieldsOperation() {
        return false;
    }

    public JRField[] getFields(IReportConnection con, JRDataset reportDataset, Map parameters) throws JRException, UnsupportedOperationException {
        return null;
    }

    public boolean supportsAutomaticQueryExecution() {
        return true;
    }

    public boolean hasQueryDesigner() {
        return useVisualDesigner;
    }

    public boolean hasEditorComponent() {
        return true;
    }

    public String designQuery(IReportConnection con, String query, ReportQueryDialog reportQueryDialog) throws JRException, UnsupportedOperationException {
        String newMDXQuery = query;
        if (query == null) {
            newMDXQuery = "";
        }
        if (con instanceof JRXMLADataSourceConnection) {
            String strURL = ((JRXMLADataSourceConnection)con).getUrl();
            String strDataSource = ((JRXMLADataSourceConnection)con).getDatasource();
            String strCatalog = ((JRXMLADataSourceConnection)con).getCatalog();
            String strCubeName = ((JRXMLADataSourceConnection)con).getCube();
            String username = ((JRXMLADataSourceConnection)con).getUsername();
            if (username != null && username.length() > 0) {
                Authenticator.setDefault(new CustomHTTPAuthenticator(username, ((JRXMLADataSourceConnection)con).getPassword()));
            }
            RexWizard mdxWizard = new RexWizard(strURL, strDataSource, strCatalog, strCubeName, newMDXQuery, I18n.getCurrentLocale());
            mdxWizard.addRexWizardListener((RexWizardListener)this);
            mdxWizard.showDialog();
            if (this.getQueryFromRex.length() > 0) {
                return this.getQueryFromRex;
            }
        } else {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("messages.reportQueryDialog.connectionNotSupported", "In order to use the MDX query designer, you need an XMLA datasource active."), "", 2);
            return null;
        }
        return query;
    }

    public void getMdx(RexWizardEvent evt) {
        this.getQueryFromRex = evt.getQuery();
        this.gotMdxResult = true;
    }

    public FieldsProviderEditor getEditorComponent(ReportQueryDialog reportQueryDialog) {
        if (this.olapBrowser == null) {
            this.olapBrowser = new OlapBrowser();
            this.olapBrowser.setReportQueryDialog(reportQueryDialog);
            if (reportQueryDialog != null) {
                this.olapBrowser.setJTableFields(reportQueryDialog.getFieldsTable());
            }
        }
        return this.olapBrowser;
    }

    static {
        Properties p = new Properties();
        try {
            p.load(MDXFieldsProvider.class.getClass().getResourceAsStream("/it/businesslogic/ireport/data/fieldsprovider.properties"));
            if (p.getProperty("mdx").equals("0")) {
                useVisualDesigner = false;
                System.out.println("ReX designer disabled");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

