/*
 * Decompiled with CFR 0.152.
 */
package ofc4j.model.elements;

import java.util.Arrays;
import java.util.List;
import ofc4j.model.elements.Element;
import ofc4j.model.metadata.Alias;
import ofc4j.model.metadata.Converter;
import ofc4j.util.DotConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineChart
extends Element {
    private static final transient Integer DEFAULT_FONTSIZE = 10;
    private Integer width;
    @Alias(value="dot-size")
    private Integer dotSize;
    @Alias(value="halo-size")
    private Integer haloSize;
    private String colour;

    public LineChart() {
        this(Style.NORMAL);
    }

    public LineChart(Style style) {
        this(style.getStyle());
    }

    protected LineChart(String type) {
        super(type);
        this.setFontSize(DEFAULT_FONTSIZE);
    }

    public Integer getWidth() {
        return this.width;
    }

    public LineChart setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getDotSize() {
        return this.dotSize;
    }

    public LineChart setDotSize(Integer dotSize) {
        this.dotSize = dotSize;
        return this;
    }

    public String getColour() {
        return this.colour;
    }

    public LineChart setColour(String colour) {
        this.colour = colour;
        return this;
    }

    public LineChart addValues(Number ... values) {
        return this.addValues(Arrays.asList(values));
    }

    public LineChart addValues(List<Number> values) {
        this.getValues().addAll(values);
        return this;
    }

    public LineChart addDots(Dot ... dots) {
        return this.addDots(Arrays.asList(dots));
    }

    public LineChart addDots(List<Dot> dots) {
        this.getValues().addAll(dots);
        return this;
    }

    public Integer getHaloSize() {
        return this.haloSize;
    }

    public LineChart setHaloSize(Integer haloSize) {
        this.haloSize = haloSize;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        NORMAL("line"),
        DOT("line_dot"),
        HOLLOW("line_hollow");

        private String style;

        private Style(String style) {
            this.style = style;
        }

        public String getStyle() {
            return this.style;
        }
    }

    @Converter(value=DotConverter.class)
    public static class Dot {
        @Alias(value="halo-size")
        private Integer haloSize;
        @Alias(value="dot-size")
        private Integer dotSize;
        private Number value;
        private String colour;

        public Dot(Number value) {
            this(value, null, null, null);
        }

        public Dot(Number value, String colour) {
            this(value, colour, null, null);
        }

        public Dot(Number value, String colour, Integer dotSize, Integer haloSize) {
            this.setValue(value);
            this.setColour(colour);
            this.setDotSize(dotSize);
            this.setHaloSize(haloSize);
        }

        public Integer getHaloSize() {
            return this.haloSize;
        }

        public Dot setHaloSize(Integer haloSize) {
            this.haloSize = haloSize;
            return this;
        }

        public Integer getDotSize() {
            return this.dotSize;
        }

        public Dot setDotSize(Integer dotSize) {
            this.dotSize = dotSize;
            return this;
        }

        public Number getValue() {
            return this.value;
        }

        public Dot setValue(Number value) {
            this.value = value;
            return this;
        }

        public String getColour() {
            return this.colour;
        }

        public Dot setColour(String colour) {
            this.colour = colour;
            return this;
        }
    }
}

