/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Result;
import mondrian.olap.SchemaReader;
import mondrian.test.FoodMartTestCase;

public class PropertiesTest
extends FoodMartTestCase {
    public PropertiesTest(String name) {
        super(name);
    }

    public void testMandatoryMemberProperties() {
        Cube salesCube = this.getConnection().getSchema().lookupCube("Sales", true);
        SchemaReader scr = salesCube.getSchemaReader(null);
        Member member = scr.getMemberByUniqueName(Id.Segment.toList("Customers", "All Customers", "USA", "CA"), true);
        boolean caseSensitive = MondrianProperties.instance().CaseSensitive.get();
        String stringPropValue = (String)member.getPropertyValue("SCHEMA_NAME");
        PropertiesTest.assertEquals((String)this.getConnection().getSchema().getName(), (String)stringPropValue);
        stringPropValue = (String)member.getPropertyValue("DIMENSION_UNIQUE_NAME");
        PropertiesTest.assertEquals((String)member.getDimension().getUniqueName(), (String)stringPropValue);
        stringPropValue = (String)member.getPropertyValue("dimension_unique_name", caseSensitive);
        if (caseSensitive) {
            PropertiesTest.assertNull((Object)stringPropValue);
        } else {
            PropertiesTest.assertEquals((String)member.getDimension().getUniqueName(), (String)stringPropValue);
        }
        stringPropValue = (String)member.getPropertyValue("DIMENSION_UNIQUE_NAME_XXXX");
        PropertiesTest.assertNull((Object)stringPropValue);
        stringPropValue = (String)member.getPropertyValue(" DIMENSION_UNIQUE_NAME");
        PropertiesTest.assertNull((Object)stringPropValue);
        stringPropValue = (String)member.getPropertyValue("DIMENSION_UNIQUE_NAME  ");
        PropertiesTest.assertNull((Object)stringPropValue);
        stringPropValue = (String)member.getPropertyValue("HIERARCHY_UNIQUE_NAME");
        PropertiesTest.assertEquals((String)member.getHierarchy().getUniqueName(), (String)stringPropValue);
        stringPropValue = (String)member.getPropertyValue("LEVEL_UNIQUE_NAME");
        PropertiesTest.assertEquals((String)member.getLevel().getUniqueName(), (String)stringPropValue);
        Integer intPropValue = (Integer)member.getPropertyValue("LEVEL_NUMBER");
        PropertiesTest.assertEquals((Object)member.getLevel().getDepth(), (Object)intPropValue);
        stringPropValue = (String)member.getPropertyValue("MEMBER_UNIQUE_NAME");
        PropertiesTest.assertEquals((String)member.getUniqueName(), (String)stringPropValue);
        stringPropValue = (String)member.getPropertyValue("MEMBER_NAME");
        PropertiesTest.assertEquals((String)member.getName(), (String)stringPropValue);
        intPropValue = (Integer)member.getPropertyValue("MEMBER_TYPE");
        PropertiesTest.assertEquals((Object)member.getMemberType().ordinal(), (Object)intPropValue);
        stringPropValue = (String)member.getPropertyValue("MEMBER_GUID");
        PropertiesTest.assertNull((Object)stringPropValue);
        stringPropValue = (String)member.getPropertyValue("MEMBER_CAPTION");
        PropertiesTest.assertEquals((String)member.getCaption(), (String)stringPropValue);
        stringPropValue = (String)member.getPropertyValue("CAPTION");
        PropertiesTest.assertEquals((String)member.getCaption(), (String)stringPropValue);
        stringPropValue = (String)member.getPropertyValue("caption", caseSensitive);
        if (caseSensitive) {
            PropertiesTest.assertNull((Object)stringPropValue);
        } else {
            PropertiesTest.assertEquals((String)member.getCaption(), (String)stringPropValue);
        }
        intPropValue = (Integer)member.getPropertyValue("MEMBER_ORDINAL");
        PropertiesTest.assertEquals((Object)member.getOrdinal(), (Object)intPropValue);
        intPropValue = (Integer)member.getPropertyValue("PARENT_LEVEL");
        PropertiesTest.assertEquals((Object)member.getParentMember().getLevel().getDepth(), (Object)intPropValue);
        stringPropValue = (String)member.getPropertyValue("PARENT_UNIQUE_NAME");
        PropertiesTest.assertEquals((String)member.getParentUniqueName(), (String)stringPropValue);
        intPropValue = (Integer)member.getPropertyValue("PARENT_COUNT");
        PropertiesTest.assertEquals((Object)1, (Object)intPropValue);
        stringPropValue = (String)member.getPropertyValue("DESCRIPTION");
        PropertiesTest.assertEquals((String)member.getDescription(), (String)stringPropValue);
        stringPropValue = (String)member.getPropertyValue("desCription", caseSensitive);
        if (caseSensitive) {
            PropertiesTest.assertNull((Object)stringPropValue);
        } else {
            PropertiesTest.assertEquals((String)member.getDescription(), (String)stringPropValue);
        }
    }

    public void testGetChildCardinalityPropertyValue() {
        Cube salesCube = this.getConnection().getSchema().lookupCube("Sales", true);
        SchemaReader scr = salesCube.getSchemaReader(null);
        Member memberForCardinalityTest = scr.getMemberByUniqueName(Id.Segment.toList("Marital Status", "All Marital Status"), true);
        Integer intPropValue = (Integer)memberForCardinalityTest.getPropertyValue("CHILDREN_CARDINALITY");
        PropertiesTest.assertEquals((Object)111, (Object)intPropValue);
    }

    public void testPropertiesMDX() {
        Result result = this.executeQuery("SELECT {[Customers].[All Customers].[USA].[CA]} DIMENSION PROPERTIES \n CATALOG_NAME, SCHEMA_NAME, CUBE_NAME, DIMENSION_UNIQUE_NAME, \n HIERARCHY_UNIQUE_NAME, LEVEL_UNIQUE_NAME, LEVEL_NUMBER, MEMBER_UNIQUE_NAME, \n MEMBER_NAME, MEMBER_TYPE, MEMBER_GUID, MEMBER_CAPTION, MEMBER_ORDINAL, CHILDREN_CARDINALITY,\n PARENT_LEVEL, PARENT_UNIQUE_NAME, PARENT_COUNT, DESCRIPTION ON COLUMNS\nFROM [Sales]");
        QueryAxis[] axes = result.getQuery().getAxes();
        Id[] axesProperties = axes[0].getDimensionProperties();
        String[] props = new String[]{"CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "DIMENSION_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "LEVEL_UNIQUE_NAME", "LEVEL_NUMBER", "MEMBER_UNIQUE_NAME", "MEMBER_NAME", "MEMBER_TYPE", "MEMBER_GUID", "MEMBER_CAPTION", "MEMBER_ORDINAL", "CHILDREN_CARDINALITY", "PARENT_LEVEL", "PARENT_UNIQUE_NAME", "PARENT_COUNT", "DESCRIPTION"};
        PropertiesTest.assertEquals((int)axesProperties.length, (int)props.length);
        int i = 0;
        for (String prop : props) {
            PropertiesTest.assertEquals((String)("[" + prop + "]"), (String)axesProperties[i++].toString());
        }
    }

    public void testMandatoryCellProperties() {
        Connection connection = this.getConnection();
        Query salesCube = connection.parseQuery("select \n {[Measures].[Store Sales], [Measures].[Unit Sales]} on columns, \n {[Gender].members} on rows \nfrom [Sales]");
        Result result = connection.execute(salesCube);
        int x = 1;
        int y = 2;
        Cell cell = result.getCell(new int[]{x, y});
        PropertiesTest.assertNull((Object)cell.getPropertyValue("BACK_COLOR"));
        PropertiesTest.assertNull((Object)cell.getPropertyValue("CELL_EVALUATION_LIST"));
        PropertiesTest.assertEquals((Object)(y * 2 + x), (Object)cell.getPropertyValue("CELL_ORDINAL"));
        PropertiesTest.assertNull((Object)cell.getPropertyValue("FORE_COLOR"));
        PropertiesTest.assertNull((Object)cell.getPropertyValue("FONT_NAME"));
        PropertiesTest.assertNull((Object)cell.getPropertyValue("FONT_SIZE"));
        PropertiesTest.assertEquals((Object)0, (Object)cell.getPropertyValue("FONT_FLAGS"));
        PropertiesTest.assertEquals((Object)"Standard", (Object)cell.getPropertyValue("FORMAT_STRING"));
        PropertiesTest.assertEquals((Object)"Standard", (Object)cell.getPropertyValue("FORMAT"));
        PropertiesTest.assertEquals((Object)"135,215", (Object)cell.getPropertyValue("FORMATTED_VALUE"));
        PropertiesTest.assertNull((Object)cell.getPropertyValue("NON_EMPTY_BEHAVIOR"));
        PropertiesTest.assertEquals((Object)0, (Object)cell.getPropertyValue("SOLVE_ORDER"));
        PropertiesTest.assertEquals((double)135215.0, (double)((Number)cell.getPropertyValue("VALUE")).doubleValue(), (double)0.1);
        if (MondrianProperties.instance().CaseSensitive.get()) {
            PropertiesTest.assertNull((Object)cell.getPropertyValue("cell_ordinal"));
            PropertiesTest.assertNull((Object)cell.getPropertyValue("font_flags"));
            PropertiesTest.assertNull((Object)cell.getPropertyValue("format_string"));
            PropertiesTest.assertNull((Object)cell.getPropertyValue("format"));
            PropertiesTest.assertNull((Object)cell.getPropertyValue("formatted_value"));
            PropertiesTest.assertNull((Object)cell.getPropertyValue("solve_order"));
            PropertiesTest.assertNull((Object)cell.getPropertyValue("value"));
        } else {
            PropertiesTest.assertEquals((Object)(y * 2 + x), (Object)cell.getPropertyValue("cell_ordinal"));
            PropertiesTest.assertEquals((Object)0, (Object)cell.getPropertyValue("font_flags"));
            PropertiesTest.assertEquals((Object)"Standard", (Object)cell.getPropertyValue("format_string"));
            PropertiesTest.assertEquals((Object)"Standard", (Object)cell.getPropertyValue("format"));
            PropertiesTest.assertEquals((Object)"135,215", (Object)cell.getPropertyValue("formatted_value"));
            PropertiesTest.assertEquals((Object)0, (Object)cell.getPropertyValue("solve_order"));
            PropertiesTest.assertEquals((double)135215.0, (double)((Number)cell.getPropertyValue("value")).doubleValue(), (double)0.1);
        }
    }
}

