/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.core.NestedRuntimeException;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;

public class DispatchMethodInvoker {
    private Object target = this;
    private Class[] parameterTypes = new Class[0];
    private Class returnType;
    private String typeCaption = "dispatcher";
    private Map methodCache = new CachingMapDecorator(){

        public Object create(Object key) {
            String methodName = (String)key;
            try {
                return DispatchMethodInvoker.this.getTarget().getClass().getMethod(methodName, DispatchMethodInvoker.this.parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new MethodLookupException("Unable to resolve " + DispatchMethodInvoker.this.getTypeCaption() + " method with name '" + methodName + "' and signature '" + DispatchMethodInvoker.this.getSignature(methodName) + "'; make sure the method name is correct " + "and such a public method is defined on targetClass " + DispatchMethodInvoker.this.getTarget().getClass().getName(), e);
            }
        }
    };

    public DispatchMethodInvoker() {
    }

    public DispatchMethodInvoker(Class[] parameterTypes, Class returnType, String typeCaption) {
        this.setParameterTypes(parameterTypes);
        this.setReturnType(returnType);
        this.setTypeCaption(typeCaption);
    }

    public DispatchMethodInvoker(Object target, Class[] parameterTypes, Class returnType, String typeCaption) {
        this.setTarget(target);
        this.setParameterTypes(parameterTypes);
        this.setReturnType(returnType);
        this.setTypeCaption(typeCaption);
    }

    public void setTarget(Object target) {
        Assert.notNull((Object)target, (String)"The target object is required");
        this.target = target;
        this.methodCache.clear();
    }

    public void setParameterTypes(Class[] parameterTypes) {
        this.parameterTypes = parameterTypes;
        this.methodCache.clear();
    }

    public void setReturnType(Class returnType) {
        this.returnType = returnType;
    }

    public void setTypeCaption(String typeCaption) {
        this.typeCaption = typeCaption;
    }

    public Object getTarget() {
        return this.target;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    protected String getParameterTypesString() {
        StringBuffer parameterTypesString = new StringBuffer();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            parameterTypesString.append(this.parameterTypes[i]);
            if (i >= this.parameterTypes.length - 1) continue;
            parameterTypesString.append(',');
        }
        return parameterTypesString.toString();
    }

    public Class getReturnType() {
        return this.returnType;
    }

    protected String getReturnTypeString() {
        return this.returnType != null ? this.returnType.getName() : "void";
    }

    public String getTypeCaption() {
        return this.typeCaption;
    }

    protected String getSignature(String methodName) {
        return "public " + this.getReturnTypeString() + " " + methodName + "(" + this.getParameterTypesString() + ");";
    }

    public Method getDispatchMethod(String methodName) throws MethodLookupException {
        return (Method)this.methodCache.get(methodName);
    }

    public Object invoke(String methodName, Object[] arguments) throws MethodLookupException, Exception {
        try {
            Method dispatchMethod = this.getDispatchMethod(methodName);
            Object result = dispatchMethod.invoke(this.getTarget(), arguments);
            if (result != null && this.returnType != null) {
                Assert.isInstanceOf((Class)this.returnType, (Object)result, (String)("Dispatched " + this.getTypeCaption() + " methods must return result objects of type '" + this.getReturnType() + "' or null; " + "however, this method '" + dispatchMethod.getName() + "' returned an object of type " + result.getClass()));
            }
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw (Error)e.getTargetException();
        }
    }

    public static class MethodLookupException
    extends NestedRuntimeException {
        public MethodLookupException(String msg, Throwable ex) {
            super(msg, ex);
        }
    }
}

