/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import java.util.Collection;
import java.util.Map;
import junit.framework.TestCase;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowArtifactException;
import org.springframework.webflow.FlowExecutionContext;
import org.springframework.webflow.ParameterMap;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.impl.FlowExecutionImpl;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.ConversationRedirect;
import org.springframework.webflow.support.ExternalRedirect;
import org.springframework.webflow.support.FlowRedirect;
import org.springframework.webflow.test.MockExternalContext;

public abstract class AbstractFlowExecutionTests
extends TestCase {
    private FlowExecution flowExecution;
    static /* synthetic */ Class class$org$springframework$webflow$support$ApplicationView;
    static /* synthetic */ Class class$org$springframework$webflow$support$ConversationRedirect;
    static /* synthetic */ Class class$org$springframework$webflow$support$FlowRedirect;
    static /* synthetic */ Class class$org$springframework$webflow$support$ExternalRedirect;

    protected ViewSelection startFlow() {
        return this.startFlow(new MockExternalContext(), null);
    }

    protected ViewSelection startFlow(ParameterMap requestParameters) {
        return this.startFlow(new MockExternalContext(requestParameters), null);
    }

    protected ViewSelection startFlow(FlowExecutionListener listener) {
        return this.startFlow(new MockExternalContext(), new FlowExecutionListener[]{listener});
    }

    protected ViewSelection startFlow(ParameterMap requestParameters, FlowExecutionListener listener) {
        return this.startFlow(new MockExternalContext(requestParameters), new FlowExecutionListener[]{listener});
    }

    protected ViewSelection startFlow(ExternalContext context, FlowExecutionListener[] listeners) {
        this.flowExecution = this.createFlowExecution(listeners);
        return this.flowExecution.start(context);
    }

    protected FlowExecution createFlowExecution(FlowExecutionListener[] listeners) {
        return new FlowExecutionImpl(this.getFlow(), listeners);
    }

    protected abstract Flow getFlow() throws FlowArtifactException;

    protected ViewSelection signalEvent(String eventId) {
        return this.flowExecution.signalEvent(eventId, new MockExternalContext());
    }

    protected ViewSelection signalEvent(String eventId, ParameterMap requestParameters) {
        return this.flowExecution.signalEvent(eventId, new MockExternalContext(requestParameters));
    }

    protected ViewSelection signalEvent(String eventId, ExternalContext context) {
        return this.flowExecution.signalEvent(eventId, context);
    }

    protected FlowExecutionContext getFlowExecutionContext() throws IllegalStateException {
        if (this.flowExecution == null) {
            throw new IllegalStateException("The flow execution has not been started; call startFlow first");
        }
        return this.flowExecution;
    }

    protected Object getConversationAttribute(String attributeName) {
        return this.getFlowExecutionContext().getScope().get(attributeName);
    }

    protected Object getRequiredConversationAttribute(String attributeName) throws IllegalStateException {
        return this.getFlowExecutionContext().getScope().getRequired(attributeName);
    }

    protected Object getRequiredConversationAttribute(String attributeName, Class requiredType) throws IllegalStateException {
        return this.getFlowExecutionContext().getScope().getRequired(attributeName, requiredType);
    }

    protected Object getFlowAttribute(String attributeName) {
        return this.getFlowExecutionContext().getActiveSession().getScope().get(attributeName);
    }

    protected Object getRequiredFlowAttribute(String attributeName) throws IllegalStateException {
        return this.getFlowExecutionContext().getActiveSession().getScope().getRequired(attributeName);
    }

    protected Object getRequiredFlowAttribute(String attributeName, Class requiredType) throws IllegalStateException {
        return this.getFlowExecutionContext().getActiveSession().getScope().getRequired(attributeName, requiredType);
    }

    protected void assertActiveFlowEquals(String expectedActiveFlowId) {
        AbstractFlowExecutionTests.assertEquals((String)("The active flow id '" + this.getFlowExecutionContext().getActiveSession().getFlow() + "' does not equal the expected active flow '" + expectedActiveFlowId + "'"), (String)expectedActiveFlowId, (String)this.getFlowExecutionContext().getActiveSession().getFlow().getId());
    }

    protected void assertFlowExecutionActive() {
        AbstractFlowExecutionTests.assertTrue((String)"The flow execution is not active but it should be", (boolean)this.flowExecution.isActive());
    }

    protected void assertFlowExecutionEnded() {
        AbstractFlowExecutionTests.assertTrue((String)"The flow execution is still active but it should have ended", (!this.flowExecution.isActive() ? 1 : 0) != 0);
    }

    protected void assertCurrentStateEquals(String expectedCurrentStateId) {
        AbstractFlowExecutionTests.assertEquals((String)("The current state '" + this.getFlowExecutionContext().getActiveSession().getState().getId() + "' does not equal the expected state '" + expectedCurrentStateId + "'"), (String)expectedCurrentStateId, (String)this.getFlowExecutionContext().getActiveSession().getState().getId());
    }

    protected ApplicationView applicationView(ViewSelection viewSelection) {
        Assert.isInstanceOf((Class)(class$org$springframework$webflow$support$ApplicationView == null ? (class$org$springframework$webflow$support$ApplicationView = AbstractFlowExecutionTests.class$("org.springframework.webflow.support.ApplicationView")) : class$org$springframework$webflow$support$ApplicationView), (Object)viewSelection, (String)"Unexpected class of view selection: ");
        return (ApplicationView)viewSelection;
    }

    protected ConversationRedirect conversationRedirect(ViewSelection viewSelection) {
        Assert.isInstanceOf((Class)(class$org$springframework$webflow$support$ConversationRedirect == null ? (class$org$springframework$webflow$support$ConversationRedirect = AbstractFlowExecutionTests.class$("org.springframework.webflow.support.ConversationRedirect")) : class$org$springframework$webflow$support$ConversationRedirect), (Object)viewSelection, (String)"Unexpected class of view selection: ");
        return (ConversationRedirect)viewSelection;
    }

    protected FlowRedirect flowRedirect(ViewSelection viewSelection) {
        Assert.isInstanceOf((Class)(class$org$springframework$webflow$support$FlowRedirect == null ? (class$org$springframework$webflow$support$FlowRedirect = AbstractFlowExecutionTests.class$("org.springframework.webflow.support.FlowRedirect")) : class$org$springframework$webflow$support$FlowRedirect), (Object)viewSelection, (String)"Unexpected class of view selection: ");
        return (FlowRedirect)viewSelection;
    }

    protected ExternalRedirect externalRedirect(ViewSelection viewSelection) {
        Assert.isInstanceOf((Class)(class$org$springframework$webflow$support$ExternalRedirect == null ? (class$org$springframework$webflow$support$ExternalRedirect = AbstractFlowExecutionTests.class$("org.springframework.webflow.support.ExternalRedirect")) : class$org$springframework$webflow$support$ExternalRedirect), (Object)viewSelection, (String)"Unexpected class of view selection: ");
        return (ExternalRedirect)viewSelection;
    }

    protected void assertNull(ViewSelection viewSelection) {
        AbstractFlowExecutionTests.assertEquals((String)"Not the null view selection:", (Object)viewSelection, (Object)ViewSelection.NULL_VIEW);
    }

    protected void assertViewNameEquals(String expectedViewName, ApplicationView viewSelection) {
        AbstractFlowExecutionTests.assertEquals((String)"The view name is wrong:", (String)expectedViewName, (String)viewSelection.getViewName());
    }

    protected void assertModelAttributeEquals(Object expectedValue, String attributeName, ApplicationView viewSelection) {
        AbstractFlowExecutionTests.assertEquals((String)("The model attribute '" + attributeName + "' value is wrong:"), (Object)expectedValue, (Object)this.evaluateModelAttributeExpression(attributeName, viewSelection.getModel()));
    }

    protected void assertModelAttributeCollectionSize(int expectedSize, String attributeName, ApplicationView viewSelection) {
        this.assertModelAttributeNotNull(attributeName, viewSelection);
        Collection c = (Collection)this.evaluateModelAttributeExpression(attributeName, viewSelection.getModel());
        AbstractFlowExecutionTests.assertEquals((String)("The model attribute '" + attributeName + "' collection size is wrong:"), (int)expectedSize, (int)c.size());
    }

    protected void assertModelAttributeNotNull(String attributeName, ApplicationView viewSelection) {
        AbstractFlowExecutionTests.assertNotNull((String)("The model attribute '" + attributeName + "' is null but should not be; model contents are " + StylerUtils.style((Object)viewSelection.getModel())), (Object)this.evaluateModelAttributeExpression(attributeName, viewSelection.getModel()));
    }

    protected void assertModelAttributeNull(String attributeName, ApplicationView viewSelection) {
        AbstractFlowExecutionTests.assertNull((String)("The model attribute '" + attributeName + "' is not null but should be; model contents are " + StylerUtils.style((Object)viewSelection.getModel())), (Object)this.evaluateModelAttributeExpression(attributeName, viewSelection.getModel()));
    }

    protected Object evaluateModelAttributeExpression(String attributeName, Map model) {
        return model.get(attributeName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

