/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.webflow.Flow;
import org.springframework.webflow.builder.FlowAssembler;
import org.springframework.webflow.builder.FlowBuilder;
import org.springframework.webflow.builder.ResourceHolder;
import org.springframework.webflow.registry.FlowHolder;

public class RefreshableFlowHolder
implements FlowHolder {
    private Flow flow;
    private FlowAssembler assembler;
    private long lastModified;
    private boolean assembling;

    public RefreshableFlowHolder(FlowAssembler assembler) {
        this.assembler = assembler;
    }

    public String getId() {
        return this.assembler.getFlowParameters().getId();
    }

    public Flow getFlow() {
        if (this.assembling) {
            return this.getFlowBuilder().getResult();
        }
        if (!this.isAssembled()) {
            this.lastModified = this.calculateLastModified();
            this.assembleFlow();
        } else {
            this.refreshIfChanged();
        }
        return this.flow;
    }

    public FlowBuilder getFlowBuilder() {
        return this.assembler.getFlowBuilder();
    }

    protected boolean isAssembled() {
        return this.flow != null;
    }

    protected boolean isAssembling() {
        return this.assembling;
    }

    protected long getLastModified() {
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assembleFlow() {
        try {
            this.assembling = true;
            this.assembler.assembleFlow();
            this.flow = this.getFlowBuilder().getResult();
        }
        finally {
            this.assembling = false;
        }
    }

    public void refresh() {
        this.assembleFlow();
    }

    protected void refreshIfChanged() {
        if (this.lastModified == -1L) {
            return;
        }
        if (this.lastModified < this.calculateLastModified()) {
            this.refresh();
        }
    }

    protected long calculateLastModified() {
        if (this.getFlowBuilder() instanceof ResourceHolder) {
            Resource resource = ((ResourceHolder)((Object)this.getFlowBuilder())).getResource();
            try {
                return resource.getFile().lastModified();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1L;
    }
}

