package com.jaspersoft.jasperserver.rest.test;

import java.io.File;
import java.io.FileInputStream;

import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PUTTest extends RESTTest {
	
	
	@Before
	public void setUp() {
    	super.setUp();
    	httpReq = new HttpPut();
     }
	
	/** PUT TESTS **/
    //successful creation of new folder
	@Test 
    public void Put200NewFolder() throws Exception 
    {
		String rdFileName = LOCAL_NEW_RDS+SAMPLE_FOLDER_RD ;
		
    	//building the body
		BasicHttpEntity reqEntity = new BasicHttpEntity();
		
		//appending the file descriptor from a file 
		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_FOLDER_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_FOLDER_SERVER_PATH);
    }
	
	  //creation of new file resource the RD is before the binaries
	@Test 
    public void Put200CreateNewFile_V1() throws Exception 
    {
		String fileRd = LOCAL_NEW_RDS+SAMPLE_IMAGE_FILE_RD;
		String fileBins = LOCAL_RESOURCES_LOCATION+SAMPLE_IMAGE_FILE_BIN;
		
    	
    	//building the body
		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
		
		//appending the file descriptor from a file 
		reqEntity.addPart(REQUEST_PARAMENTER_RD, new StringBody(RESTTestUtils.getResourceDescriptor(new File(fileRd))));
		
		//appending the binaries to the request body
		FileBody bin = new FileBody(new File(fileBins));
		reqEntity.addPart(REQUEST_SAMPLE_IMAGE_PATH, bin );
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_IMAGE_FILE_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_IMAGE_FILE_SERVER_PATH);
    }
    
    //creation of new file resource the binaries is before the RD
	@Test 
    public void Put200CreateNewFile_V2() throws Exception 
    {
		String fileRd = LOCAL_NEW_RDS+SAMPLE_IMAGE_FILE_RD;
		String fileBins = LOCAL_RESOURCES_LOCATION+SAMPLE_IMAGE_FILE_BIN;
    	
    	//building the body
		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
		
		//appending the binaries to the request body
		FileBody bin = new FileBody(new File(fileBins));
		reqEntity.addPart(REQUEST_SAMPLE_IMAGE_PATH, bin );
		
		//appending the file descriptor from a file 
		reqEntity.addPart(REQUEST_PARAMENTER_RD, new StringBody(RESTTestUtils.getResourceDescriptor((new File(fileRd)))));
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_IMAGE_FILE_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_IMAGE_FILE_SERVER_PATH);
    }
	
	@Test 
    public void Put200NewDataType() throws Exception 
    {
		String rdFileName = LOCAL_NEW_RDS+SAMPLE_DATA_TYPE_RD;
		
    	//building the body
		BasicHttpEntity reqEntity = new BasicHttpEntity();
		
		//appending the file descriptor from a file 
		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_DATA_TYPE_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_DATA_TYPE_SERVER_PATH);
    }

	
	@Test 
    public void Put200InputControl() throws Exception 
    {
		String rdFileName = LOCAL_NEW_RDS+SAMPLE_INPUT_CONTROL_RD;
		
    	//building the body
		BasicHttpEntity reqEntity = new BasicHttpEntity();
		
		//appending the file descriptor from a file 
		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_INPUT_CONTROL_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_INPUT_CONTROL_SERVER_PATH);
    }
	
	@Test 
    public void Put200InputControl_WithReferenceResource() throws Exception 
    {
		String rdFileName = LOCAL_NEW_RDS+SAMPLE_INPUT_CONTROL_WITH_REFERENCE_RD;
		
    	//building the body
		BasicHttpEntity reqEntity = new BasicHttpEntity();
		
		//appending the file descriptor from a file 
		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_INPUT_CONTROL_WITH_REFERENCES_ERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_INPUT_CONTROL_WITH_REFERENCES_ERVER_PATH);
    }
	
	@Test 
    public void Put200InputControl_WithLocalResource() throws Exception 
    {
		String rdFileName = LOCAL_NEW_RDS+SAMPLE_INPUT_CONTROL_WITH_LOCAL_RESOURCE_RD;
		
    	//building the body
		BasicHttpEntity reqEntity = new BasicHttpEntity();
		
		//appending the file descriptor from a file 
		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_INPUT_CONTROL_WITH_LOCAL_RESOURCE_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_INPUT_CONTROL_WITH_LOCAL_RESOURCE_SERVER_PATH);
    }
	
	@Test 
    public void Put200JDBC() throws Exception 
    {
		String rdFileName = LOCAL_NEW_RDS+SAMPLE_JDBC_FILE_RD;
		
    	//building the body
		BasicHttpEntity reqEntity = new BasicHttpEntity();
		
		//appending the file descriptor from a file 
		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_JDBC_FILE_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_JDBC_FILE_SERVER_PATH);
    }
	
	@Test 
    public void Put200ListOfValues() throws Exception 
    {
		String rdFileName = LOCAL_NEW_RDS+SAMPLE_LIST_OF_VALUES_RD;
		
    	//building the body
		BasicHttpEntity reqEntity = new BasicHttpEntity();
		
		//appending the file descriptor from a file 
		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_LIST_OF_VALUES_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_LIST_OF_VALUES_SERVER_PATH);
    }
	
	@Test 
    public void Put200NewOlapMondrianCon() throws Exception 
    {
		String rdFileName = LOCAL_NEW_RDS+SAMPLE_OLAP_MONDRIAN_CON_RD;
		
    	//building the body
		BasicHttpEntity reqEntity = new BasicHttpEntity();
		
		//appending the file descriptor from a file 
		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_OLAP_MONDRIAN_CON_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_OLAP_MONDRIAN_CON_SERVER_PATH);
    }
	
	@Test
	public void Put200NewReportUnit() throws Exception
	{
		//deleteResource(SAMPLE_COMPLEX_REPORT_SERVER_PATH);
		
		//inits
		String SalesByMonthReportURI="/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/1_SalesByMonthReport";
		String ScriptletURI="/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/1_Scriptlet";
		String LogoURI="/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/1_Logo";
		String SalesByMonthDetailURI="/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/1_SalesByMonthDetail";
		String sales_propertiesURI="/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/1_sales.properties";
		String sales_ro_propertiesURI="/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/1_sales_ro.properties";
		
		String SalesByMonthReportLocalPath = LOCAL_RESOURCES_LOCATION+"/SalesByMonthReport.jrxml";
		String ScriptletLocalPath = LOCAL_RESOURCES_LOCATION+"/scriptlet.jar";
		String LogoLocalPath = LOCAL_RESOURCES_LOCATION+SAMPLE_IMAGE_FILE_BIN;
		String SalesByMonthDetailLocalPath = LOCAL_RESOURCES_LOCATION+"/jasperReport_AllAccounts.jrxml";
		String sales_propertiesLocalPath = LOCAL_RESOURCES_LOCATION+"/sales.properties";
		String sales_ro_propertiesLocalPath = LOCAL_RESOURCES_LOCATION+"/sales_ro.properties"; 
		
		String fileRd = LOCAL_NEW_RDS+SAMPLE_COMPOLEX_REPORT_UNIT_RD;
		
		FileBody bin;
		
    	//building the body
		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
		
		//appending the file descriptor from a file 
		reqEntity.addPart(REQUEST_PARAMENTER_RD, new StringBody(RESTTestUtils.getResourceDescriptor(new File(fileRd))));
		
		//appending the binaries to the request body
		bin = new FileBody(new File(SalesByMonthReportLocalPath));
		reqEntity.addPart(SalesByMonthReportURI, bin );
		
		//appending the binaries to the request body
		bin = new FileBody(new File(ScriptletLocalPath));
		reqEntity.addPart(ScriptletURI, bin );
		
		//appending the binaries to the request body
		bin = new FileBody(new File(LogoLocalPath));
		reqEntity.addPart(LogoURI, bin );
		
		//appending the binaries to the request body
		bin = new FileBody(new File(SalesByMonthDetailLocalPath));
		reqEntity.addPart(SalesByMonthDetailURI, bin );
		
		//appending the binaries to the request body
		bin = new FileBody(new File(sales_propertiesLocalPath));
		reqEntity.addPart(sales_propertiesURI, bin );
		
		//appending the binaries to the request body
		bin = new FileBody(new File(sales_ro_propertiesLocalPath));
		reqEntity.addPart(sales_ro_propertiesURI, bin );
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_COMPLEX_REPORT_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_COMPLEX_REPORT_SERVER_PATH);
		
	}
	

//	//trying to override a folder
//	@Test 
//    public void Put403NewFolder() throws Exception 
//    {
//		String rdFileName = LOCAL_RESOURCES_LOCATION+"rdContentFilesFolder.xml";
//		
//    	
//    	//building the body
//		BasicHttpEntity reqEntity = new BasicHttpEntity();
//		
//		//appending the file descriptor from a file 
//		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
//		
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		
//		//executing the request
//		httpRes = executeCall(httpReq, "ContentFiles");
//		Assert.assertTrue("basic response check did not pass", isValidResposnse(403));
//    }
    
    //creating a new folder with a bad path <existing path>/<none existing path>/<none existing path>
//	@Test 
//    public void Put404NewFolder() throws Exception 
//    {
//		String rdFileName = LOCAL_RESOURCES_LOCATION+SAMPLE_FOLDER_RESOURCE_DESCRIPTOR;
//    	
//    	//building the body
//		BasicHttpEntity reqEntity = new BasicHttpEntity();
//		
//		//appending the file descriptor from a file 
//		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
//		
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		
//		//executing the request
//		httpRes = executeCall(httpReq, NEW_FOLDER_PATH+"/newFolder");
//		Assert.assertTrue("basic response check did not pass", isValidResposnse(404));
//    }
    

//    
//    //creation of new file on a new file resource
//	@Test 
//    public void Put200CreateNewFileOverwrite() throws Exception 
//    {
//		String rdFileName = "testCreatNewFileResourceDescriptor.xml";
//    	
//    	//building the body
//		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
//		
//		//appending the binaries to the request body
//		FileBody bin = new FileBody(new File("jasperSoftLogo.jpg"));
//		reqEntity.addPart("ResourceBinaries", bin );
//		
//		//appending the file descriptor from a file 
//		reqEntity.addPart("ResourceDescriptor", new StringBody(RESTTestUtils.getResourceDescriptor((new File(rdFileName)))));
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		//executing the request
//		httpRes = executeCall(httpReq, SAMPLE_FILE_PATH);
//		
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//    }
//    
//    //Error while creating a new file resource - no binaries were attached.
//	@Test 
//    public void Put400CreateNewFile_V1() throws Exception 
//    {
//		String rdFileName = "testCreatNewFileResourceDescriptor.xml";
//    	
//    	//building the body
//		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
//		
//		//appending the file descriptor from a file 
//		reqEntity.addPart("ResourceDescriptor", new StringBody(RESTTestUtils.getResourceDescriptor((new File(rdFileName)))));
//		
//		//appending the binaries to the request body
//		FileBody bin = new FileBody(new File("jasperSoftLogo.jpg"));
//		reqEntity.addPart("ResourceBinaries", bin );
//		
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		//executing the request
//		httpRes = executeCall(httpReq, SAMPLE_FILE_PATH);
//		
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//    }
//    
//    //Error while creating a new file resource - no resource descriptor attached.
//	@Test 
//    public void Put400CreateNewFile_V2() throws Exception
//    {
//		String rdFileName = "testCreatNewFileResourceDescriptor.xml";
//    	
//    	//building the body
//		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
//		
//		//appending the file descriptor from a file 
//		reqEntity.addPart("ResourceDescriptor", new StringBody(RESTTestUtils.getResourceDescriptor((new File(rdFileName)))));
//		
//		//appending the binaries to the request body
//		FileBody bin = new FileBody(new File("jasperSoftLogo.jpg"));
//		reqEntity.addPart("ResourceBinaries", bin );
//		
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		//executing the request
//		httpRes = executeCall(httpReq, SAMPLE_FILE_PATH);
//		
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//    }
//    
//    //Error overwriting a resource that is linked to another resource
//	@Test 
//    public void Put403CreateNewFile() throws Exception 
//    {
//		String rdFileName = "testCreatNewFileResourceDescriptor.xml";
//    	
//    	//building the body
//		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
//		
//		//appending the file descriptor from a file 
//		reqEntity.addPart("ResourceDescriptor", new StringBody(RESTTestUtils.getResourceDescriptor((new File(rdFileName)))));
//		
//		//appending the binaries to the request body
//		FileBody bin = new FileBody(new File("jasperSoftLogo.jpg"));
//		reqEntity.addPart("ResourceBinaries", bin );
//		
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		//executing the request
//		httpRes = executeCall(httpReq, SAMPLE_FILE_PATH);
//		
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//    }
//    
//    //Error creating a new resource in a none existent path.
//	@Test 
//    public void Put404CreateNewFile() throws Exception 
//    {
//		String rdFileName = "testCreatNewFileResourceDescriptor.xml";
//    	
//    	//building the body
//		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
//		
//		//appending the file descriptor from a file 
//		reqEntity.addPart("ResourceDescriptor", new StringBody(RESTTestUtils.getResourceDescriptor((new File(rdFileName)))));
//		
//		//appending the binaries to the request body
//		FileBody bin = new FileBody(new File("jasperSoftLogo.jpg"));
//		reqEntity.addPart("ResourceBinaries", bin );
//		
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		//executing the request
//		httpRes = executeCall(httpReq, SAMPLE_FILE_PATH);
//		
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//    }
    
//    public void OverwriteExistingResources() throws Exception 
//    {
//		//building the body
//		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
//		
//		//appending the file descriptor from a file 
//		reqEntity.addPart("ResourceDescriptor", new StringBody(getResourceDescriptor(new File("t.xml"))));
//		
//		//appending the binaries to the request body
//		FileBody bin = new FileBody(new File("jasperSoftLogo.jpg"));
//		reqEntity.addPart("ResourceBinaries", bin );
//		
//		httpPost.setEntity(reqEntity);
//		
//		
//		//executing the request
//		httpResponse = executeCall(httpPost, "/resource/ContentFiles/myImage");
//		
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//    }
}
