/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */


package com.jaspersoft.jasperserver.rest;

import com.jaspersoft.jasperserver.remote.ServiceException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 *
 * @author gtoffoli
 */
public abstract class RESTAbstractService implements RESTService {

    public static final String HTTP_GET = "get";
    public static final String HTTP_PUT = "put";
    public static final String HTTP_POST = "post";
    public static final String HTTP_DELETE = "delete";


    protected ApplicationContext context = null;

    /**
     * Invoked by the REST Servlet when the class is initialized.
     *
     * @param ac
     * @throws BeansException
     */
    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        this.context = ac;
    }

    
    /**
     * Check for the request method, and dispatch the code to the right class method
     * PUT and DELETE methods can be overridden by using the X-Method-Override header or
     * the special parameter X-Method-Override when using a POST.
     *
     * @param req
     * @param resp
     * @throws ServiceException
     */
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {

        String method = req.getMethod().toLowerCase();

        // Tunnels a PUT or DELETE request over the HTTP POST request.
        String methodOverride = req.getHeader("X-Method-Override");
        if (methodOverride == null)
        {
            methodOverride = req.getParameter("X-Method-Override");
        }
        if (methodOverride != null && HTTP_POST.equals(method))
        {
            methodOverride = methodOverride.toLowerCase();
            if (HTTP_DELETE.equals(methodOverride) || HTTP_PUT.equals(methodOverride))
            {
                method = methodOverride;
            }
        }

        if (HTTP_GET.equals(method))
        {
            doGet(req, resp);
        }
        else if (HTTP_POST.equals(method))
        {
            doPost(req, resp);
        }
        else if (HTTP_PUT.equals(method))
        {
            doPut(req, resp);
        }
        else if (HTTP_DELETE.equals(method))
        {
            doDelete(req, resp);
        }
        else
        {
            RESTUtils.setStatusAndBody(HttpServletResponse.SC_METHOD_NOT_ALLOWED, resp, "Method not supported for this object type");
        }
    }


    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException
    {
        RESTUtils.setStatusAndBody(HttpServletResponse.SC_METHOD_NOT_ALLOWED, resp, "Method not supported for this object type");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServiceException
    {
        RESTUtils.setStatusAndBody(HttpServletResponse.SC_METHOD_NOT_ALLOWED, resp, "Method not supported for this object type");
    }
    
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServiceException
    {
        RESTUtils.setStatusAndBody(HttpServletResponse.SC_METHOD_NOT_ALLOWED, resp, "Method not supported for this object type");
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServiceException
    {
        RESTUtils.setStatusAndBody(HttpServletResponse.SC_METHOD_NOT_ALLOWED, resp, "Method not supported for this object type");
    }
    
}
