package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.remote.AbstractService;
import org.springframework.context.ApplicationContext;

/**
 * Created by IntelliJ IDEA.
 * User: carbiv
 * Date: 7/27/11
 * Time: 12:35 PM
 * To change this template use File | Settings | File Templates.
 */
public class PostService extends AbstractService {


    public PostService(ApplicationContext ac) {
        super(ac);
    }


    public void copyResource(String sourceURI, String destinationURI) {
        Resource source = getManagementServices().locateResource(sourceURI);
        //Resource dest = getManagementServices().locateResource(destinationURI);
        if (source instanceof Folder ){
            getManagementServices().getRepository().copyFolder(null, sourceURI, destinationURI);
        }
        else {
            getManagementServices().getRepository().copyResource(null, sourceURI, destinationURI);

        }
    }

    public void moveResource(String sourceURI, String destinationURI) {
        Resource resource = getManagementServices().locateResource(sourceURI);

        if (resource instanceof Folder)
            getManagementServices().getRepository().moveFolder(null, sourceURI, destinationURI);
        else
            getManagementServices().getRepository().moveResource(null, sourceURI, destinationURI);
    }
}
