package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.ws.scheduling.Job;
import java.util.HashMap;
import org.apache.axis.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;


/**
 * Created by IntelliJ IDEA.
 * User: carbiv
 * Date: 6/14/11
 * Time: 2:31 PM
 * To change this template use File | Settings | File Templates.
 */
public class DeleteService extends AbstractService {
    private final static Log log = LogFactory.getLog(ListService.class);


    public DeleteService(ApplicationContext context)
    {
        super(context);
    }

    /**
     * Return a list of ResourceDescriptor(s)
     * @throws com.jaspersoft.jasperserver.api.JSException
     */
    public void deleteResource(String uri) throws ServiceException
    {
        //setting up audit for action
        long currentTime = System.currentTimeMillis();
        getManagementServices().getAuditHelper().createAuditEvent("deleteResource");

        // starting action execution
        OperationResult or;
        log.debug("list for uri: " + uri);


        // The resource to list based on the uri
        if (uri == null) {
            log.warn("Delete: null resourceDescriptor for " + uri);
            throw new ServiceException(ServiceException.RESOURCE_BAD_REQUEST, getMessage("remote.error.resourceNotFound"));
        }

        // 1. Check if the user has access to the resource....
        Resource resource = getManagementServices().locateResource(uri);
        if (resource == null)
        {
            log.warn("Delete: no access or not existing resource " + uri);
            throw new ServiceException(ServiceException.RESOURCE_NOT_FOUND, getMessage("remote.error.resourceNotFound"));
        }

        ResourceHandler rh = getManagementServices().getHandlerRegistry().getHandler(resource);
        if (rh == null)
        {
            log.warn("Delete: no resource handler found for resource " + uri);
            throw new ServiceException(ServiceException.RESOURCE_NOT_FOUND, "Unsupported resource type");
        }

        try {
            rh.delete(rh.get(resource, new HashMap()));
        } catch (ServiceException ex)
        {
            ex.setErrorCode(ServiceException.FORBIDDEN);
            throw ex;
        }
    }

    public void deleteJob(long jobId) {
        try {
            getManagementServices().getSchedulerService().deleteJob(jobId);
        } catch (AxisFault axisFault) {
            throw new ServiceException(ServiceException.INTERNAL_SERVER_ERROR, axisFault.getLocalizedMessage());
        }
    }
}
