/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.remote.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;


import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ResourceDataSource;
import com.jaspersoft.jasperserver.remote.ServiceException;


/**
 * @author gtoffoli
 * @version $Id: FileResourceHandler.java 19933 2010-12-11 15:27:37Z tmatyashovsky $
 */
public class FileResourceHandler extends RepositoryResourceHandler{

	private static final Log log = LogFactory.getLog(FileResourceHandler.class);
	
	public Class getResourceType() {
		return FileResource.class;
	}

        protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException
        {
		FileResource fileResource = (FileResource) resource;
		descriptor.setWsType(fileResource.getFileType());
		descriptor.setHasData(fileResource.hasData());
		descriptor.setIsReference(fileResource.isReference());
		if (descriptor.getIsReference()) {
			descriptor.setReferenceUri(fileResource.getReferenceURI());
		}

		String resourceType = fileResource.getFileType();

                String contentType = "application/octet-stream";

		if (descriptor.getIsReference()) {
			descriptor.setWsType(ResourceDescriptor.TYPE_REFERENCE);
		}
                else if (resourceType == null)
			descriptor.setWsType(ResourceDescriptor.TYPE_UNKNOW);
		else if (resourceType.equals(FileResource.TYPE_JRXML))
                {
                    descriptor.setWsType(ResourceDescriptor.TYPE_JRXML);
                    contentType = "text/xml";
                }
                else if (resourceType.equals(FileResource.TYPE_IMAGE))
                {
			        descriptor.setWsType(ResourceDescriptor.TYPE_IMAGE);
                }
                else if (resourceType.equals(FileResource.TYPE_FONT))
			            descriptor.setWsType(ResourceDescriptor.TYPE_FONT);
		            else if (resourceType.equals(FileResource.TYPE_JAR))
			                descriptor.setWsType(ResourceDescriptor.TYPE_CLASS_JAR);
		                 else if (resourceType.equals(FileResource.TYPE_RESOURCE_BUNDLE))
                                {
                                    descriptor.setWsType(ResourceDescriptor.TYPE_RESOURCE_BUNDLE);
                                    contentType = "text/plain";
                                }
                              else if (resourceType.equals(FileResource.TYPE_STYLE_TEMPLATE))
                                {
                                    descriptor.setWsType(ResourceDescriptor.TYPE_STYLE_TEMPLATE);
                                    contentType = "text/xml";
                                }
                                    else if (resourceType.equals(FileResource.TYPE_XML))
                                            {
                                                descriptor.setWsType(ResourceDescriptor.TYPE_XML_FILE);
                                                contentType = "text/xml";
                                            }

                descriptor.setHasData(false);
                if (options == null || !options.containsKey(Argument.NO_RESOURCE_DATA_ATTACHMENT))
                {
                    //Retrieve resource data...
                        descriptor.setHasData(true);
                        FileResourceData fileData = AbstractService.getContext().getManagementServices().getRepository().getResourceData(null, descriptor.getUriString());
                        ResourceDataSource attachmentSource = new ResourceDataSource(descriptor.getName(), fileData);
                        attachmentSource.setContentType(contentType);
                        AbstractService.getContext().getOutputAttachments().put("attachment", attachmentSource);
                        log.warn("Placed attachment for " + descriptor.getName() + " in the output attachments list" + " " + AbstractService.getContext());
                        descriptor.setResourceProperty("PROP_ATTACHMENT_ID", "attachment");
                }
                
	}

    protected Resource createResource(ResourceDescriptor descriptor) throws ServiceException
    {
        try{

            FileResource resource = (FileResource) super.createResource(descriptor);

            resource.setFileType(descriptor.getWsType());
            InputStream ds = AbstractService.getContext().getInputAttachments().get(descriptor.getUriString()).getInputStream();
            resource.setData(IOUtils.toByteArray(ds));

            updateResource(resource, descriptor, null);
            return resource;

        }
        catch (ClassCastException e){
            throw new ServiceException(ServiceException.INTERNAL_SERVER_ERROR, e.getLocalizedMessage());
        } catch (IOException e) {
            throw new ServiceException(ServiceException.INTERNAL_SERVER_ERROR, e.getLocalizedMessage());
        }
    }

    protected String getFileType(String wsType) {
            String type = null;
            if (wsType.equals(ResourceDescriptor.TYPE_IMAGE))
                    type = FileResource.TYPE_IMAGE;
            else if (wsType.equals(ResourceDescriptor.TYPE_FONT))
                    type = FileResource.TYPE_FONT;
            else if (wsType.equals(ResourceDescriptor.TYPE_CLASS_JAR))
                    type = FileResource.TYPE_JAR;
            else if (wsType.equals(ResourceDescriptor.TYPE_JRXML))
                    type = FileResource.TYPE_JRXML;
            else if (wsType.equals(ResourceDescriptor.TYPE_RESOURCE_BUNDLE))
                    type = FileResource.TYPE_RESOURCE_BUNDLE;
            else if (wsType.equals(ResourceDescriptor.TYPE_STYLE_TEMPLATE))
                    type = FileResource.TYPE_STYLE_TEMPLATE;
            else if (wsType.equals(ResourceDescriptor.TYPE_XML_FILE))
                    type = FileResource.TYPE_XML;
            return type;
    }

    
}
