/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;

import java.util.List;

/**
 * @author tkavanagh
 * @version $Id: ReportUnitBean.java 19925 2010-12-11 15:06:41Z tmatyashovsky $
 */

public class ReportUnitBean extends ResourceBean {

	/*
	 * The following come from the ReportUnit interface 
	 */
	private ResourceReferenceBean dataSource;
	private ResourceReferenceBean query;
	private ResourceReferenceBean[] inputControls;
	private ResourceReferenceBean mainReport;
	private ResourceReferenceBean[] resources;
	private String inputControlRenderingView;
	private String reportRenderingView;
    private boolean alwaysPromptControls;
    private byte controlsLayout = ReportUnit.LAYOUT_SEPARATE_PAGE;

	protected void additionalCopyFrom(Resource res, ResourceExportHandler exportHandler) {
		ReportUnit ru = (ReportUnit) res;
		setDataSource(exportHandler.handleReference(ru.getDataSource()));
		setQuery(exportHandler.handleReference(ru.getQuery()));
		setInputControls(handleReferences(ru.getInputControls(), exportHandler));
		setMainReport(exportHandler.handleReference(ru.getMainReport()));
		setResources(handleReferences(ru.getResources(), exportHandler));
		setInputControlRenderingView(ru.getInputControlRenderingView());
		setReportRenderingView(ru.getReportRenderingView());
		setAlwaysPromptControls(ru.isAlwaysPromptControls());
		setControlsLayout(ru.getControlsLayout());
	}

	protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
		ReportUnit ru = (ReportUnit) res;
		ru.setDataSource(importHandler.handleReference(getDataSource()));
		ru.setQuery(importHandler.handleReference(getQuery()));
		ru.setInputControls(handleReferences(getInputControls(), importHandler));
		ru.setMainReport(importHandler.handleReference(getMainReport()));
        List rs = handleReferences(getResources(), importHandler);
        if (ru.getResources() == null) {
            ru.setResources(rs);
        } else if (rs != null) {
            ru.getResources().addAll(rs);
        }
        ru.setInputControlRenderingView(getInputControlRenderingView());
		ru.setReportRenderingView(getReportRenderingView());
		ru.setAlwaysPromptControls(isAlwaysPromptControls());
		ru.setControlsLayout(getControlsLayout());
	}

	public ResourceReferenceBean getDataSource() {
		return dataSource;
	}

	public void setDataSource(ResourceReferenceBean dataSource) {
		this.dataSource = dataSource;
	}
	
	public ResourceReferenceBean getQuery() {
		return query;
	}

	public void setQuery(ResourceReferenceBean query) {
		this.query = query;
	}	
	
	public ResourceReferenceBean[] getInputControls() {
		return inputControls;
	}

	public void setInputControls(ResourceReferenceBean[] inputControls) {
		this.inputControls = inputControls;
	}

	public ResourceReferenceBean getMainReport() {
		return mainReport;
	}

	public void setMainReport(ResourceReferenceBean mainReport) {
		this.mainReport = mainReport;
	}

	public ResourceReferenceBean[] getResources() {
		return resources;
	}

	public void setResources(ResourceReferenceBean[] resources) {
		this.resources = resources;
	}

	public boolean isAlwaysPromptControls() {
		return alwaysPromptControls;
	}

	public void setAlwaysPromptControls(boolean alwaysPromptControls) {
		this.alwaysPromptControls = alwaysPromptControls;
	}

	public byte getControlsLayout() {
		return controlsLayout;
	}

	public void setControlsLayout(byte controlsLayout) {
		this.controlsLayout = controlsLayout;
	}

	public String getInputControlRenderingView() {
		return inputControlRenderingView;
	}

	public void setInputControlRenderingView(String inputControlRenderingView) {
		this.inputControlRenderingView = inputControlRenderingView;
	}

	public String getReportRenderingView() {
		return reportRenderingView;
	}

	public void setReportRenderingView(String reportRenderingView) {
		this.reportRenderingView = reportRenderingView;
	}
}
