/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.OlapDataSourceWrapper;
import com.jaspersoft.jasperserver.war.validation.ReportDataSourceValidator;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class OlapDataSourceValidator
extends ReportDataSourceValidator
implements Validator {
    private JasperServerConstImpl constants = new JasperServerConstImpl();

    public boolean supports(Class clazz) {
        return OlapDataSourceWrapper.class.isAssignableFrom(clazz);
    }

    public void validate(Object arg0, Errors arg1) {
    }

    public void chooseType(OlapDataSourceWrapper wrapper, Errors errors) {
        if (wrapper.getSource() == null) {
            errors.rejectValue("source", "OlapDataSourceValidator.error.not.empty");
        }
    }

    public void jndiPropsForm(OlapDataSourceWrapper wrapper, Errors errors) {
        JndiJdbcReportDataSource jndiSource = (JndiJdbcReportDataSource)wrapper.getOlapDataSource();
        if (jndiSource.getJndiName() == null || jndiSource.getJndiName().trim().length() == 0) {
            errors.rejectValue("olapDataSource.jndiName", "OlapDataSourceValidator.error.not.empty");
        } else if (!JasperServerUtil.regExValidateJndiServiceName(jndiSource.getJndiName())) {
            errors.rejectValue("olapDataSource.jndiName", "OlapDataSourceValidator.error.invalid.chars");
        }
        this.namingForm(wrapper, errors);
    }

    public void namingForm(OlapDataSourceWrapper wrapper, Errors errors) {
        ReportDataSource ds = wrapper.getOlapDataSource();
        if (ds.getName() == null || ds.getName().trim().length() == 0) {
            errors.rejectValue("olapDataSource.name", "OlapDataSourceValidator.error.not.empty");
        } else if (!JasperServerUtil.regExValidateName(ds.getName())) {
            errors.rejectValue("olapDataSource.name", "OlapDataSourceValidator.error.invalid.chars");
        }
        if (ds.getLabel() == null || ds.getLabel().trim().length() == 0) {
            errors.rejectValue("olapDataSource.label", "OlapDataSourceValidator.error.not.empty");
        } else if (!JasperServerUtil.regExValidateLabel(ds.getLabel())) {
            errors.rejectValue("olapDataSource.label", "OlapDataSourceValidator.error.invalid.chars");
        }
        if (ds.getDescription() == null || ds.getDescription().trim().length() > 300) {
            errors.rejectValue("olapDataSource.description", "OlapDataSourceValidator.error.too.long");
        }
    }

    public void jdbcPropsForm(OlapDataSourceWrapper wrapper, Errors errors) {
        JdbcReportDataSource ds = (JdbcReportDataSource)wrapper.getOlapDataSource();
        if (ds.getDriverClass() == null || ds.getDriverClass().trim().length() == 0) {
            errors.rejectValue("olapDataSource.driverClass", "OlapDataSourceValidator.error.not.empty");
        } else if (!JasperServerUtil.regExValidateDbDriver(ds.getDriverClass())) {
            errors.rejectValue("olapDataSource.driverClass", "OlapDataSourceValidator.error.invalid.chars");
        }
        if (ds.getConnectionUrl() == null || ds.getConnectionUrl().trim().length() == 0) {
            errors.rejectValue("olapDataSource.connectionUrl", "OlapDataSourceValidator.error.not.empty");
        } else if (!JasperServerUtil.regExValidateJdbcURL(ds.getConnectionUrl())) {
            errors.rejectValue("olapDataSource.connectionUrl", "OlapDataSourceValidator.error.invalid.chars");
        }
        if (ds.getUsername() == null || ds.getUsername().trim().length() == 0) {
            errors.rejectValue("olapDataSource.username", "OlapDataSourceValidator.error.not.empty");
        }
        if (ds.getPassword() == null || ds.getPassword().trim().length() == 0) {
            errors.rejectValue("olapDataSource.password", "OlapDataSourceValidator.error.not.empty");
        }
        this.namingForm(wrapper, errors);
    }

    public void validateSource(OlapDataSourceWrapper wrapper, Errors errors) {
        OlapDataSourceValidator olapDataSourceValidator = this;
        if (olapDataSourceValidator.constants.getFieldChoiceRepo().equals(wrapper.getSource()) && (wrapper.getSelectedUri() == null || wrapper.getSelectedUri().trim().length() == 0)) {
            errors.rejectValue("selectedUri", "OlapDataSourceValidator.error.not.empty");
        }
    }
}

