/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.util;

import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.springframework.context.i18n.LocaleContextHolder;

public class DefaultCalendarFormatProvider
implements CalendarFormatProvider {
    public String getCalendarDatePattern() {
        String pattern = this.getDateFormatPattern();
        pattern = pattern.replaceAll("(?i)m+", "%m");
        pattern = pattern.replaceAll("(?i)d+", "%d");
        pattern = pattern.replaceAll("(?i)y+", "%Y");
        return pattern;
    }

    public String getCalendarDatetimePattern() {
        String pattern = this.getDatetimeFormatPattern();
        pattern = pattern.replaceAll("d+", "%d");
        pattern = pattern.replaceAll("M+", "%m");
        pattern = pattern.replaceAll("y+", "%Y");
        pattern = pattern.replaceAll("H+", "%H");
        pattern = pattern.replaceAll("h+", "%I");
        pattern = pattern.replaceAll("a+", "%p");
        pattern = pattern.replaceAll("(?<=^|[^%])m+", "%M");
        return pattern;
    }

    public DateFormat getDateFormat() {
        String pattern = this.getDateFormatPattern();
        return new SimpleDateFormat(pattern);
    }

    public DateFormat getDatetimeFormat() {
        String pattern = this.getDatetimeFormatPattern();
        return new SimpleDateFormat(pattern);
    }

    protected String getDatetimeFormatPattern() {
        SimpleDateFormat defaultFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, LocaleContextHolder.getLocale());
        String pattern = defaultFormat.toPattern();
        pattern = pattern.replaceAll("d+", "dd");
        pattern = pattern.replaceAll("M+", "MM");
        pattern = pattern.replaceAll("y+", "yyyy");
        pattern = pattern.replaceAll("H+", "HH");
        pattern = pattern.replaceAll("h+", "hh");
        pattern = pattern.replaceAll("k+", "HH");
        pattern = pattern.replaceAll("K+", "hh");
        pattern = pattern.replaceAll("m+", "mm");
        return pattern;
    }

    protected String getDateFormatPattern() {
        SimpleDateFormat defaultFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, LocaleContextHolder.getLocale());
        String pattern = defaultFormat.toPattern();
        pattern = pattern.replaceAll("(?i)d+", "dd");
        pattern = pattern.replaceAll("(?i)m+", "MM");
        pattern = pattern.replaceAll("(?i)y+", "yyyy");
        return pattern;
    }
}

