/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.token;

import com.jaspersoft.jasperserver.api.engine.common.service.BuiltInParameterProvider;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.war.cascade.token.FilterResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterCore
implements FilterResolver {
    public static final String STANDARD_PARAMETER_START = "$P{";
    public static final String INCLUDE_PARAMETER_START = "$P!{";
    public static final String DYNAMIC_QUERY_PARAMETER_START = "$X{";
    public static final String PARAMETER_END = "}";
    private static final byte NOTHING = 0;
    private static final byte STANDARD = 1;
    private static final byte INCLUDE = 2;
    private static final byte DYNAMIC = 3;
    private static Logger log = Logger.getLogger(FilterCore.class);
    List builtInParameterProviders;

    public List getBuiltInParameterProviders() {
        return this.builtInParameterProviders;
    }

    public void setBuiltInParameterProviders(List builtInParameterProviders) {
        this.builtInParameterProviders = builtInParameterProviders;
    }

    @Override
    public boolean hasParameters(String queryString, Map parameters) {
        return this.hasParameters(queryString, 0);
    }

    public boolean hasParameters(String queryString, int start) {
        Parameter p = this.nextParameter(queryString, start);
        return p.type != 0;
    }

    private Parameter nextParameter(String queryString, int start) {
        int nextTest;
        Parameter p = new Parameter();
        if (start < 0 || start > queryString.length() - 1) {
            return p;
        }
        int nextPosition = queryString.indexOf(STANDARD_PARAMETER_START, start);
        if (nextPosition > -1) {
            p.type = 1;
            p.position = nextPosition;
            p.endPosition = queryString.indexOf(PARAMETER_END, p.position);
            if (p.endPosition > -1) {
                p.name = queryString.substring(nextPosition + STANDARD_PARAMETER_START.length(), p.endPosition).trim();
            }
        }
        if ((nextTest = queryString.indexOf(INCLUDE_PARAMETER_START, start)) > -1 && (nextPosition > -1 && nextTest < nextPosition || nextPosition == -1)) {
            nextPosition = nextTest;
            p.type = (byte)2;
            p.position = nextTest;
            p.endPosition = queryString.indexOf(PARAMETER_END, p.position);
            if (p.endPosition > -1) {
                p.name = queryString.substring(nextPosition + INCLUDE_PARAMETER_START.length(), p.endPosition).trim();
            }
        }
        if ((nextTest = queryString.indexOf(DYNAMIC_QUERY_PARAMETER_START, start)) > -1 && (nextPosition > -1 && nextTest < nextPosition || nextPosition == -1)) {
            nextPosition = nextTest;
            p.type = (byte)3;
            p.position = nextTest;
            p.endPosition = queryString.indexOf(PARAMETER_END, p.position);
            if (p.endPosition > -1) {
                String parameterContents = queryString.substring(nextPosition + DYNAMIC_QUERY_PARAMETER_START.length(), p.endPosition).trim();
                String[] parts = parameterContents.split(",");
                if (parts.length == 3 && (parts[0].trim().equalsIgnoreCase("IN") || parts[0].trim().equalsIgnoreCase("NOTIN") || parts[0].trim().equalsIgnoreCase("EQUAL") || parts[0].trim().equalsIgnoreCase("NOTEQUAL"))) {
                    p.name = parts[2].trim();
                } else {
                    throw new RuntimeException("Unknown $X parameter function in query: " + queryString);
                }
            }
        }
        return p;
    }

    public List<Parameter> getParameters(String queryString) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        int index = 0;
        while (index < queryString.length() && this.hasParameters(queryString, index)) {
            Parameter p = this.nextParameter(queryString, index);
            if (p.type == 0) break;
            index = p.endPosition;
            if (index > 0 && queryString.charAt(index - 1) == '$') {
                ++index;
                continue;
            }
            parameters.add(p);
            ++index;
        }
        return parameters;
    }

    @Override
    public Object getCacheKey(String queryString, Map providedParameters) {
        Map resolvedParameters = this.resolveParameters(queryString, providedParameters);
        if (resolvedParameters != null) {
            return queryString + resolvedParameters;
        }
        return null;
    }

    @Override
    public Map resolveParameters(String queryString, Map providedParameters) {
        List<Parameter> queryParameters = this.getParameters(queryString);
        HashSet<String> missingQueryParameterNames = new HashSet<String>(queryParameters.size());
        HashMap resolvedParams = new HashMap();
        for (Parameter p : queryParameters) {
            Object value = providedParameters.get(p.name);
            if (!providedParameters.containsKey(p.name)) {
                missingQueryParameterNames.add(p.name);
                continue;
            }
            resolvedParams.put(p.name, value);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("provided params: " + providedParameters));
            log.debug((Object)("resolved params: " + resolvedParams));
            log.debug((Object)("missing params: " + missingQueryParameterNames));
        }
        if (missingQueryParameterNames.size() > 0) {
            Map builtInParams = this.resolveBuiltInParameters(missingQueryParameterNames);
            if (log.isDebugEnabled()) {
                log.debug((Object)("built in params found: " + builtInParams));
            }
            if (builtInParams == null) {
                resolvedParams = null;
            } else {
                resolvedParams.putAll(builtInParams);
            }
        }
        if (log.isDebugEnabled() && missingQueryParameterNames.size() > 0) {
            log.debug((Object)("final resolved params: " + resolvedParams));
        }
        return resolvedParams;
    }

    protected Map resolveBuiltInParameters(Set<String> missingQueryParameterNames) {
        HashMap<String, Object> resolvedParams = new HashMap<String, Object>();
        if (missingQueryParameterNames.size() > 0) {
            missingQueryParameterNames = new HashSet<String>(missingQueryParameterNames);
            for (Object o : this.getBuiltInParameterProviders()) {
                BuiltInParameterProvider pProvider = (BuiltInParameterProvider)o;
                HashSet<String> currentMissingQueryParameterNames = new HashSet<String>(missingQueryParameterNames);
                for (String name : currentMissingQueryParameterNames) {
                    Object[] aResult = pProvider.getParameter(null, null, null, name);
                    if (aResult == null) continue;
                    resolvedParams.put(name, aResult[1]);
                    missingQueryParameterNames.remove(name);
                }
            }
        }
        return missingQueryParameterNames.size() > 0 ? null : resolvedParams;
    }

    @Override
    public boolean paramTestNeedsDataSourceInit(ReportDataSource dataSource) {
        return false;
    }

    class Parameter {
        byte type = 0;
        String name;
        int position;
        int endPosition;

        Parameter() {
        }
    }
}

