/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeMappingAction
extends MultiAction {
    private static Logger logger = Logger.getLogger(ResourceTypeMappingAction.class);
    private RepositoryService repositoryService;
    private Map<Class, Object> typeToActionBean;
    private String resourceUriAttributeName;
    private EngineService engineService;

    public Event doPreExecute(RequestContext context) {
        String resourceUri = context.getFlowScope().getRequiredString(this.resourceUriAttributeName);
        Resource resource = this.repositoryService.getResource(this.engineService.getRuntimeExecutionContext(), resourceUri);
        for (Class testResourceClass : this.typeToActionBean.keySet()) {
            if (!testResourceClass.isInstance(resource)) continue;
            this.setTarget(this.typeToActionBean.get(testResourceClass));
            return null;
        }
        throw new IllegalArgumentException("No matching action map for resource class " + resource.getName());
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setTypeToActionBean(Map<Class, Object> typeToActionBean) {
        this.typeToActionBean = typeToActionBean;
    }

    public Map<Class, Object> getTypeToActionBean() {
        return this.typeToActionBean;
    }

    public void setResourceUriAttributeName(String resourceUriAttributeName) {
        this.resourceUriAttributeName = resourceUriAttributeName;
    }

    public String getResourceUriAttributeName() {
        return this.resourceUriAttributeName;
    }

    public void setEngineService(EngineService engineService) {
        this.engineService = engineService;
    }
}

