/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.dto.RuntimeInputControlWrapper;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class ReportParametersUtils {
    public static final String staticDatePattern = "yyyyMMddHHmmss";

    public static void setInputControlParameterValue(RuntimeInputControlWrapper wrapper, Object paramValue, RepositoryService repository) {
        wrapper.setErrorMessage(null);
        Object inputValue = ReportParametersUtils.toInputControlValue(wrapper, paramValue, repository);
        wrapper.setValue(inputValue);
    }

    public static Object toInputControlValue(RuntimeInputControlWrapper wrapper, Object paramValue, RepositoryService repository) {
        Object value;
        if (paramValue == null) {
            return null;
        }
        if (wrapper.isMulti()) {
            Set values = ReportParametersUtils.toMultiInputControlValue(paramValue);
            value = values;
        } else {
            DataType datatype = ReportParametersUtils.getDatatype(wrapper.getInputControl(), repository);
            if (datatype != null) {
                switch (datatype.getType()) {
                    case 2: {
                        value = ReportParametersUtils.toInputControlNumber(paramValue);
                        break;
                    }
                    case 1: {
                        value = paramValue.toString();
                        break;
                    }
                    case 3: {
                        value = ReportParametersUtils.toInputControlDate(paramValue, wrapper, new SimpleDateFormat(staticDatePattern));
                        break;
                    }
                    case 4: {
                        value = ReportParametersUtils.toInputControlDate(paramValue, wrapper, new SimpleDateFormat(staticDatePattern));
                        break;
                    }
                    default: {
                        value = paramValue;
                        break;
                    }
                }
            } else {
                value = paramValue;
            }
        }
        return value;
    }

    public static Set toMultiInputControlValue(Object paramValue) {
        ListOrderedSet values = new ListOrderedSet();
        if (paramValue != null) {
            if (paramValue instanceof Collection) {
                values.addAll((Collection)paramValue);
            } else if (paramValue.getClass().isArray()) {
                int length = Array.getLength(paramValue);
                for (int idx = 0; idx < length; ++idx) {
                    Object val = Array.get(paramValue, idx);
                    values.add(val);
                }
            }
        }
        return values;
    }

    public static DataType getDatatype(InputControl control, RepositoryService repository) {
        ResourceReference dataTypeRef = control.getDataType();
        DataType dataType = dataTypeRef == null ? null : (dataTypeRef.isLocal() ? (DataType)dataTypeRef.getLocalResource() : (DataType)repository.getResource((ExecutionContext)new ExecutionContextImpl(), dataTypeRef.getReferenceURI()));
        return dataType;
    }

    public static java.util.Date toInputControlDate(Object paramValue, RuntimeInputControlWrapper wrapper, DateFormat dateFormat) {
        java.util.Date inputValue;
        if (paramValue instanceof java.util.Date) {
            java.util.Date dateValue = (java.util.Date)paramValue;
            inputValue = new java.util.Date(dateValue.getTime());
        } else if (paramValue instanceof String) {
            ReportParametersUtils.parseDateAndDateTime((String)paramValue, wrapper, dateFormat, null);
            if (wrapper.getValue() instanceof String) {
                throw new JSException("exception.report.unrecognized.date.type", new Object[]{paramValue.getClass().getName()});
            }
            inputValue = (java.util.Date)wrapper.getValue();
        } else {
            throw new JSException("exception.report.unrecognized.date.type", new Object[]{paramValue.getClass().getName()});
        }
        return inputValue;
    }

    public static BigDecimal toInputControlNumber(Object paramValue) {
        BigDecimal inputValue;
        if (paramValue instanceof Byte || paramValue instanceof Short || paramValue instanceof Integer || paramValue instanceof Long) {
            inputValue = BigDecimal.valueOf(((Number)paramValue).longValue());
        } else if (paramValue instanceof Float || paramValue instanceof Double) {
            inputValue = BigDecimal.valueOf(((Number)paramValue).doubleValue());
        } else if (paramValue instanceof BigDecimal) {
            inputValue = (BigDecimal)paramValue;
        } else if (paramValue instanceof BigInteger) {
            inputValue = new BigDecimal((BigInteger)paramValue);
        } else if (paramValue instanceof String) {
            if (((String)paramValue).trim().length() == 0) {
                return null;
            }
            inputValue = new BigDecimal((String)paramValue);
        } else {
            throw new JSException("exception.report.unrecognized.number.type", new Object[]{paramValue.getClass().getName()});
        }
        return inputValue;
    }

    protected static void parseDateAndDateTime(String strValue, RuntimeInputControlWrapper wrapper, DateFormat format, MessageSource messageSource) {
        try {
            Class paramClass;
            ReportInputControlInformation rici = wrapper.getControlInfo();
            Class clazz = paramClass = rici == null ? null : rici.getValueType();
            if (strValue == null || strValue.trim().length() == 0) {
                wrapper.setValue(null);
            } else {
                java.util.Date dateValue = format.parse(strValue);
                dateValue = ReportParametersUtils.convertToProperSubclass(dateValue, paramClass);
                wrapper.setValue(dateValue);
            }
        }
        catch (ParseException e) {
            if (messageSource != null) {
                wrapper.setErrorMessage(messageSource.getMessage("fillParameters.error.invalidDateTime", null, LocaleContextHolder.getLocale()));
            }
            wrapper.setValue(strValue);
        }
    }

    protected static java.util.Date convertToProperSubclass(java.util.Date value, Class parameterClass) {
        if (Timestamp.class.equals((Object)parameterClass)) {
            return new Timestamp(value.getTime());
        }
        if (Date.class.equals((Object)parameterClass)) {
            return new Date(value.getTime());
        }
        if (Time.class.equals((Object)parameterClass)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(value);
            cal.clear(1);
            cal.clear(2);
            cal.clear(5);
            return new Date(cal.getTimeInMillis());
        }
        return value;
    }
}

