/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.RepositoryUtils;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseRepositoryTest
extends BaseJasperServerTest {
    private static final Log log = LogFactory.getLog(BaseRepositoryTest.class);
    protected static final String TEMP_FOLDER_URI = "/unit_tests_tmp";
    protected static final String TEMP_FOLDER_LABEL = "Unit tests temporary folder";
    protected static final String USER_JOE = "joeuser";

    public BaseRepositoryTest() {
        this.setAutowireMode(1);
    }

    public BaseRepositoryTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInTempFolder(Callback callback) throws Exception {
        this.basicAuthSetup();
        this.createTempFolder();
        boolean deleteTemp = true;
        try {
            callback.execute();
            deleteTemp = false;
            this.deteleTempFolder();
        }
        finally {
            if (deleteTemp) {
                try {
                    this.deteleTempFolder();
                }
                catch (Exception e) {
                    log.error((Object)"Unable to delete the temp folder", (Throwable)e);
                }
            }
        }
    }

    protected void createTempFolder() {
        FolderImpl tempFolder = new FolderImpl();
        tempFolder.setURIString(TEMP_FOLDER_URI);
        tempFolder.setLabel(TEMP_FOLDER_LABEL);
        this.getUnsecureRepositoryService().saveFolder(this.getExecutionContext(), (Folder)tempFolder);
    }

    protected void deteleTempFolder() {
        this.getUnsecureRepositoryService().deleteFolder(this.getExecutionContext(), TEMP_FOLDER_URI);
    }

    protected ExecutionContext getExecutionContext() {
        return new ExecutionContextImpl();
    }

    protected void setBaseResource(Resource resource, String name) {
        this.setBaseResource(resource, TEMP_FOLDER_URI, name);
    }

    protected void setBaseResource(Resource resource, String parent, String name) {
        resource.setParentFolder(parent);
        resource.setName(name);
        resource.setLabel(name);
    }

    protected Resource newResource(Class type, String name) {
        return this.newResource(type, TEMP_FOLDER_URI, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileResource newFileResource(String name, String type, String dataResource) {
        FileResource resource = (FileResource)this.newResource(FileResource.class, name);
        resource.setFileType(type);
        InputStream data = ((Object)((Object)this)).getClass().getResourceAsStream(dataResource);
        try {
            resource.readData(data);
        }
        finally {
            try {
                data.close();
            }
            catch (IOException e) {
                log.warn((Object)"Unable to close input stream", (Throwable)e);
            }
        }
        return resource;
    }

    protected Resource newResource(Class type, Folder parent, String name) {
        return this.newResource(type, parent.getURIString(), name);
    }

    protected Resource newResource(Class type, String parent, String name) {
        Resource res = this.getUnsecureRepositoryService().newResource(this.getExecutionContext(), type);
        this.setBaseResource(res, parent, name);
        return res;
    }

    protected Resource saveResource(Resource res) {
        this.getUnsecureRepositoryService().saveResource(this.getExecutionContext(), res);
        Resource saved = this.getUnsecureRepositoryService().getResource(this.getExecutionContext(), res.getURIString(), res.getClass());
        return saved;
    }

    protected Folder saveNewFolder(String name) {
        return this.saveNewFolder(TEMP_FOLDER_URI, name);
    }

    protected Folder saveNewFolder(Folder parent, String name) {
        return this.saveNewFolder(parent.getURIString(), name);
    }

    protected Folder saveNewFolder(String parent, String name) {
        FolderImpl folder = new FolderImpl();
        folder.setParentFolder(parent);
        folder.setName(name);
        folder.setLabel(name);
        this.getUnsecureRepositoryService().saveFolder(this.getExecutionContext(), (Folder)folder);
        Folder saved = this.getUnsecureRepositoryService().getFolder(this.getExecutionContext(), folder.getURIString());
        return saved;
    }

    protected void assertResourceInexistent(String uri) {
        Resource resource = this.getUnsecureRepositoryService().getResource(this.getExecutionContext(), uri);
        BaseRepositoryTest.assertNull((Object)resource);
    }

    protected Resource assertResourceExists(Class type, Folder parent, String name) {
        return this.assertResourceExists(type, parent.getURIString(), name);
    }

    protected Resource assertResourceExists(Class type, String parent, String name) {
        return this.assertResourceExists(type, RepositoryUtils.concatenatePath((String)parent, (String)name));
    }

    protected Resource assertResourceExists(Class type, String uri) {
        Resource resource = this.getUnsecureRepositoryService().getResource(this.getExecutionContext(), uri, type);
        BaseRepositoryTest.assertNotNull((Object)resource);
        BaseRepositoryTest.assertEquals((String)uri, (String)resource.getURIString());
        return resource;
    }

    protected void assertFolderInexistent(String uri) {
        Folder folder = this.getUnsecureRepositoryService().getFolder(this.getExecutionContext(), uri);
        BaseRepositoryTest.assertNull((Object)folder);
    }

    protected Folder assertFolderExists(Folder parent, String name) {
        return this.assertFolderExists(parent.getURIString(), name);
    }

    protected Folder assertFolderExists(String parent, String name) {
        return this.assertFolderExists(RepositoryUtils.concatenatePath((String)parent, (String)name));
    }

    protected Folder assertFolderExists(String uri) {
        Folder folder = this.getUnsecureRepositoryService().getFolder(this.getExecutionContext(), uri);
        BaseRepositoryTest.assertNotNull((Object)folder);
        BaseRepositoryTest.assertEquals((String)uri, (String)folder.getURIString());
        return folder;
    }

    protected void assertFolderChildren(Folder folder, int subFoldersCount, int resourcesCount) {
        List subFolders = this.getUnsecureRepositoryService().getSubFolders(this.getExecutionContext(), folder.getURIString());
        if (subFoldersCount == 0) {
            BaseRepositoryTest.assertTrue((subFolders == null || subFolders.isEmpty() ? 1 : 0) != 0);
        } else {
            BaseRepositoryTest.assertNotNull((Object)subFolders);
            BaseRepositoryTest.assertEquals((int)subFoldersCount, (int)subFolders.size());
        }
        FilterCriteria filter = FilterCriteria.createFilter();
        filter.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folder.getURIString()));
        List resources = this.getUnsecureRepositoryService().loadResourcesList(this.getExecutionContext(), filter);
        if (resourcesCount == 0) {
            BaseRepositoryTest.assertTrue((resources == null || resources.isEmpty() ? 1 : 0) != 0);
        } else {
            BaseRepositoryTest.assertNotNull((Object)resources);
            BaseRepositoryTest.assertEquals((int)resourcesCount, (int)resources.size());
        }
    }

    protected String makeUri(String name) {
        return RepositoryUtils.concatenatePath((String)TEMP_FOLDER_URI, (String)name);
    }

    protected void assertExternalReference(ResourceReference reference, String uri) {
        BaseRepositoryTest.assertNotNull((Object)reference);
        BaseRepositoryTest.assertFalse((boolean)reference.isLocal());
        BaseRepositoryTest.assertEquals((String)uri, (String)reference.getReferenceURI());
    }

    protected Resource assertLocalReference(ResourceReference reference, Class type) {
        BaseRepositoryTest.assertNotNull((Object)reference);
        BaseRepositoryTest.assertTrue((boolean)reference.isLocal());
        Resource res = reference.getLocalResource();
        BaseRepositoryTest.assertNotNull((Object)res);
        BaseRepositoryTest.assertTrue((boolean)type.isInstance(res));
        return res;
    }

    protected void setUserPermission(int permissionMask, String uri, String username) {
        ObjectPermission permission = this.getObjectPermissionService().newObjectPermission(this.getExecutionContext());
        permission.setPermissionRecipient((Object)this.getUser(username));
        permission.setURI("repo:" + uri);
        permission.setPermissionMask(permissionMask);
        this.getObjectPermissionService().putObjectPermission(this.getExecutionContext(), permission);
    }

    protected User getUser(String username) {
        User user = this.getUserAuthorityService().getUser(this.getExecutionContext(), username);
        BaseRepositoryTest.assertNotNull((Object)user);
        BaseRepositoryTest.assertEquals((String)username, (String)user.getUsername());
        return user;
    }

    protected List getPermissions(Resource resource) {
        return this.getObjectPermissionService().getObjectPermissionsForObject(this.getExecutionContext(), (Object)resource);
    }

    protected void assertUserPermission(int permissionMask, Resource resource, String username) {
        List permissions = this.getObjectPermissionService().getObjectPermissionsForObjectAndRecipient(this.getExecutionContext(), (Object)resource, (Object)this.getUser(username));
        BaseRepositoryTest.assertNotNull((Object)permissions);
        BaseRepositoryTest.assertFalse((boolean)permissions.isEmpty());
        BaseRepositoryTest.assertEquals((int)1, (int)permissions.size());
        ObjectPermission permission = (ObjectPermission)permissions.get(0);
        BaseRepositoryTest.assertNotNull((Object)permission);
        BaseRepositoryTest.assertEquals((int)permissionMask, (int)permission.getPermissionMask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertFileData(FileResource resource, String dataResource) throws IOException {
        ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream();
        InputStream data = ((Object)((Object)this)).getClass().getResourceAsStream(dataResource);
        try {
            DataContainerStreamUtil.pipeData((InputStream)data, (OutputStream)dataBuffer);
        }
        finally {
            try {
                data.close();
            }
            catch (IOException e) {
                log.warn((Object)"Unable to close input stream", (Throwable)e);
            }
        }
        FileResourceData resourceData = this.getUnsecureRepositoryService().getResourceData(this.getExecutionContext(), resource.getURIString());
        BaseRepositoryTest.assertNotNull((Object)resourceData);
        BaseRepositoryTest.assertTrue((boolean)resourceData.hasData());
        this.assertDataEqual(dataBuffer.toByteArray(), resourceData.getData());
    }

    protected void assertDataEqual(byte[] data1, byte[] data2) {
        BaseRepositoryTest.assertNotNull((Object)data1);
        BaseRepositoryTest.assertNotNull((Object)data2);
        BaseRepositoryTest.assertEquals((int)data1.length, (int)data2.length);
        boolean eq = true;
        for (int i = 0; i < data1.length; ++i) {
            if (data1[i] == data2[i]) continue;
            eq = false;
            break;
        }
        BaseRepositoryTest.assertTrue((boolean)eq);
    }

    protected static interface Callback {
        public void execute() throws Exception;
    }
}

