/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.selection;

import com.tonbeller.wcf.component.Form;
import com.tonbeller.wcf.component.FormListener;
import com.tonbeller.wcf.component.RenderListener;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.convert.BooleanConverter;
import com.tonbeller.wcf.convert.CheckBoxConverter;
import com.tonbeller.wcf.convert.RadioButtonConverter;
import com.tonbeller.wcf.selection.DefaultSelectionModel;
import com.tonbeller.wcf.selection.SelectionModel;
import com.tonbeller.wcf.selection.TitleProvider;
import com.tonbeller.wcf.ui.CheckBox;
import com.tonbeller.wcf.ui.Item;
import com.tonbeller.wcf.ui.RadioButton;
import com.tonbeller.wcf.utils.DomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class SelectionMgr
implements FormListener,
RenderListener {
    String groupId = DomUtils.randomId();
    BooleanConverter radioConv = new RadioButtonConverter();
    BooleanConverter checkConv = new CheckBoxConverter();
    List selectionHandlers = new ArrayList();
    Dispatcher dispatcher = new DispatcherSupport();
    TitleProvider titleProvider = null;
    boolean readOnly;
    private static Logger logger = Logger.getLogger(SelectionMgr.class);
    SelectionModel selectionModel;

    public SelectionMgr(Dispatcher dispatcher, Form form) {
        this(dispatcher, form, new DefaultSelectionModel());
    }

    public SelectionMgr(Dispatcher dispatcher, Form form, SelectionModel selectionModel) {
        this.selectionModel = selectionModel;
        form.addFormListener(this);
        dispatcher.addRequestListener(null, null, this.dispatcher);
    }

    public void startRendering(RequestContext context) {
        this.selectionHandlers.clear();
        this.dispatcher.clear();
    }

    public void stopRendering() {
    }

    public void renderButton(Element parent, Object obj) {
        if (!this.selectionModel.isSelectable(obj)) {
            DomUtils.appendNbsp(parent);
            return;
        }
        int selMode = this.selectionModel.getMode();
        if (selMode == 3 || selMode == 5) {
            if (this.readOnly) {
                if (this.selectionModel.contains(obj)) {
                    parent.setAttribute("style", "selected");
                }
            } else {
                String id = DomUtils.randomId();
                parent.setAttribute("hrefId", id);
                if (selMode == 3) {
                    this.dispatcher.addRequestListener(id, null, new SingleSelectHandler(obj));
                } else {
                    this.dispatcher.addRequestListener(id, null, new MultipleSelectHandler(obj));
                }
                if (this.selectionModel.contains(obj)) {
                    parent.setAttribute("style", "selected");
                }
            }
        } else if (selMode == 6 || selMode == 4) {
            if (this.readOnly) {
                if (this.selectionModel.contains(obj)) {
                    parent.setAttribute("style", "selected");
                }
            } else {
                String id = DomUtils.randomId();
                parent.setAttribute("buttonId", id);
                if (selMode == 6) {
                    this.dispatcher.addRequestListener(id, null, new SingleSelectHandler(obj));
                } else {
                    this.dispatcher.addRequestListener(id, null, new MultipleSelectHandler(obj));
                }
                if (this.selectionModel.contains(obj)) {
                    parent.setAttribute("selected", "true");
                }
            }
        } else if (selMode == 1 || selMode == 2) {
            Element button;
            String buttonId = DomUtils.randomId();
            if (this.selectionModel.getMode() == 1) {
                button = RadioButton.addRadioButton(parent);
                RadioButton.setGroupId(button, this.groupId);
                RadioButton.setId(button, buttonId);
                RadioButton.setDisabled(button, this.readOnly);
                this.selectionHandlers.add(new SelectionHandler(obj, button, this.radioConv));
            } else {
                button = CheckBox.addCheckBox(parent);
                CheckBox.setId(button, buttonId);
                CheckBox.setDisabled(button, this.readOnly);
                this.selectionHandlers.add(new SelectionHandler(obj, button, this.checkConv));
            }
            Item.setId(button, DomUtils.randomId());
            Item.setSelected(button, this.selectionModel.contains(obj));
            if (this.titleProvider != null) {
                String title = this.titleProvider.getLabel(obj);
                button.setAttribute("title", title);
            }
        }
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public void revert(RequestContext context) {
    }

    public boolean validate(RequestContext context) {
        logger.info((Object)"enter");
        for (SelectionHandler sh : this.selectionHandlers) {
            sh.validate(context);
        }
        return true;
    }

    public TitleProvider getTitleProvider() {
        return this.titleProvider;
    }

    public void setTitleProvider(TitleProvider provider) {
        this.titleProvider = provider;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    class MultipleSelectHandler
    implements RequestListener {
        private Object node;

        MultipleSelectHandler(Object node) {
            this.node = node;
        }

        public void request(RequestContext context) throws Exception {
            if (SelectionMgr.this.selectionModel.contains(this.node)) {
                SelectionMgr.this.selectionModel.remove(this.node);
            } else {
                SelectionMgr.this.selectionModel.add(this.node);
            }
            SelectionMgr.this.selectionModel.fireSelectionChanged(context);
        }
    }

    class SingleSelectHandler
    implements RequestListener {
        private Object node;

        SingleSelectHandler(Object node) {
            this.node = node;
        }

        public void request(RequestContext context) throws Exception {
            SelectionMgr.this.selectionModel.setSingleSelection(this.node);
            SelectionMgr.this.selectionModel.fireSelectionChanged(context);
        }
    }

    class SelectionHandler {
        Object obj;
        Element elem;
        BooleanConverter conv;

        public SelectionHandler(Object obj, Element elem, BooleanConverter conv) {
            this.obj = obj;
            this.elem = elem;
            this.conv = conv;
        }

        public void validate(RequestContext context) {
            Map params = context.getParameters();
            switch (this.conv.isSelected(this.elem, params)) {
                case 2: {
                    if (SelectionMgr.this.selectionModel.getMode() == 1) {
                        SelectionMgr.this.selectionModel.setSingleSelection(this.obj);
                    } else {
                        SelectionMgr.this.selectionModel.add(this.obj);
                    }
                    SelectionMgr.this.selectionModel.fireSelectionChanged(context);
                    break;
                }
                case 3: {
                    SelectionMgr.this.selectionModel.remove(this.obj);
                    SelectionMgr.this.selectionModel.fireSelectionChanged(context);
                    break;
                }
            }
        }
    }
}

