/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.tbutils.res;

import com.tonbeller.tbutils.res.Dumper;
import com.tonbeller.tbutils.res.ResourceProvider;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReplacingResourceProvider
implements ResourceProvider {
    ResourceProvider decoree;
    int maxRecurse = 10;
    Pattern pattern = Pattern.compile("\\$\\{([a-zA-Z0-9_\\.]+)\\}");

    public ReplacingResourceProvider(ResourceProvider decoree) {
        this.decoree = decoree;
    }

    public void close() {
        this.decoree.close();
    }

    public String getString(String key) {
        String s = this.decoree.getString(key);
        return this.replace(s);
    }

    public Collection keySet() {
        return this.decoree.keySet();
    }

    public String replace(String s) {
        return this.replace(s, this.maxRecurse);
    }

    private String replace(String s, int recurseLevel) {
        if (s == null) {
            return null;
        }
        Matcher m = this.pattern.matcher(s);
        if (!m.find()) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        int start = 0;
        do {
            sb.append(s.substring(start, m.start()));
            start = m.end();
            if (m.start() > 0 && s.charAt(m.start() - 1) == '$') {
                sb.append(s.substring(m.start() + 1, m.end()));
                continue;
            }
            String key = m.group(1);
            String val = this.decoree.getString(key);
            if (val != null) {
                if (recurseLevel <= 0) {
                    throw new RecursionOverflowException(val);
                }
                val = this.replace(val, recurseLevel - 1);
                sb.append(val);
                continue;
            }
            sb.append(s.substring(m.start(), m.end()));
        } while (m.find());
        sb.append(s.substring(start, s.length()));
        return sb.toString();
    }

    public void dump(Dumper d) {
        this.decoree.dump(d);
    }

    public String getName() {
        return this.getClass().getName();
    }

    public int getMaxRecurse() {
        return this.maxRecurse;
    }

    public void setMaxRecurse(int maxRecurse) {
        this.maxRecurse = maxRecurse;
    }

    public class RecursionOverflowException
    extends RuntimeException {
        RecursionOverflowException(String s) {
            super(s);
        }
    }
}

