/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.ListService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.rest.RESTUtils;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RESTResources
extends RESTAbstractService {
    private static final Log log = LogFactory.getLog(RESTResources.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String uri = RESTUtils.extractRepositoryUri(req.getPathInfo());
        if (uri == null) {
            uri = "/";
        }
        String queryString = req.getParameter("q");
        String[] resourceTypes = req.getParameterValues("type");
        int limit = 0;
        if (req.getParameter("limit") != null) {
            try {
                limit = Integer.parseInt(req.getParameter("limit"));
                if (limit < 0) {
                    throw new Exception();
                }
            }
            catch (Throwable ex) {
                RESTUtils.setStatusAndBody(400, resp, "Invalid value set for parameter limit.");
                return;
            }
        }
        List list = new ArrayList();
        ListService service = new ListService(this.context);
        if (queryString == null && (resourceTypes == null || resourceTypes.length == 0)) {
            list = service.listResources(uri, limit);
        } else {
            boolean recursive = false;
            if (req.getParameter("recursive") != null && (req.getParameter("recursive").equals("1") || req.getParameter("recursive").equalsIgnoreCase("true") || req.getParameter("recursive").equalsIgnoreCase("yes"))) {
                recursive = true;
            }
            list = service.getResources(uri, queryString, resourceTypes == null ? null : Arrays.asList(resourceTypes), recursive, limit);
        }
        StringBuilder xml = new StringBuilder();
        Marshaller m = new Marshaller();
        xml.append("<resourceDescriptors>\n");
        for (Object rd : list) {
            xml.append(m.writeResourceDescriptor((ResourceDescriptor)rd));
        }
        xml.append("</resourceDescriptors>");
        RESTUtils.setStatusAndBody(200, resp, xml.toString());
    }
}

