/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest;

import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.rest.MultipartFileDataSource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataSource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTUtils {
    private static final Log log = LogFactory.getLog(RESTUtils.class);
    public static final String REQUEST_PARAMENTER_RD = "ResourceDescriptor";
    public static final String REQUEST_PARAMENTER_MOVE_TO = "moveTo";
    public static final String REQUEST_PARAMENTER_COPY_TO = "copyTo";

    public static boolean isMultipartContent(HttpServletRequest request) {
        if (!"put".equals(request.getMethod().toLowerCase()) && !"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static HttpServletRequest extractAttachments(AbstractService context, HttpServletRequest hRequest) {
        MultipartHttpServletRequest mreq;
        CommonsMultipartResolver resolver = new CommonsMultipartResolver();
        if (RESTUtils.isMultipartContent(hRequest) && hRequest.getContentLength() != -1 && (mreq = resolver.resolveMultipart(hRequest)) != null) {
            Iterator iterator = mreq.getFileNames();
            String fieldName = null;
            while (iterator.hasNext()) {
                fieldName = (String)iterator.next();
                MultipartFile file = mreq.getFile(fieldName);
                if (file == null) continue;
                MultipartFileDataSource ds = new MultipartFileDataSource(file);
                context.getInputAttachments().put(fieldName, ds);
            }
            return mreq;
        }
        return hRequest;
    }

    public static String extractServiceName(String path) {
        int startIndex;
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((startIndex = path.indexOf("/")) > 0) {
            path = path.substring(0, startIndex);
        }
        return path;
    }

    public static String extractRepositoryUri(String path) {
        int startIndex;
        if (path == null) {
            return "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((startIndex = path.indexOf("/")) > 0) {
            path = path.substring(startIndex);
        }
        while (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getURIName(String uri) {
        return uri.replace("\\", "").replace("//", "");
    }

    public static Map<String, Object> extractParameters(HttpServletRequest req) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Enumeration penum = req.getParameterNames();
        while (penum.hasMoreElements()) {
            String pname = (String)penum.nextElement();
            if (pname.startsWith("P_")) {
                parameters.put(pname.substring(2), req.getParameter(pname));
                continue;
            }
            if (!pname.startsWith("PL_")) continue;
            parameters.put(pname.substring(3), Arrays.asList(req.getParameterValues(pname)));
        }
        return parameters;
    }

    public static void setStatusAndBody(int errorCode, HttpServletResponse response, String body) {
        response.setStatus(errorCode);
        try {
            PrintWriter pw = response.getWriter();
            pw.print(body == null ? "" : body);
        }
        catch (Exception ioEx) {
            log.error((Object)"Error sending output a file", (Throwable)ioEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendFile(DataSource ds, HttpServletResponse response) {
        response.setContentType(ds.getContentType());
        if (ds.getName() != null && ds.getName().length() > 0) {
            response.addHeader("Content-Disposition", "attachment; filename=" + ds.getName());
        }
        ServletOutputStream outputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            outputStream = response.getOutputStream();
            bufferedInputStream = new BufferedInputStream(ds.getInputStream());
            int readBytes = 0;
            while ((readBytes = bufferedInputStream.read()) != -1) {
                outputStream.write(readBytes);
            }
        }
        catch (IOException ex) {
            log.error((Object)("Error serving a file: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception ex) {}
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public static String getDetinationUri(HttpServletRequest req) {
        if (req.getParameterMap().containsKey(REQUEST_PARAMENTER_MOVE_TO)) {
            return req.getParameter(REQUEST_PARAMENTER_MOVE_TO);
        }
        if (req.getParameterMap().containsKey(REQUEST_PARAMENTER_COPY_TO)) {
            return req.getParameter(REQUEST_PARAMENTER_COPY_TO);
        }
        return null;
    }
}

