/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.token;

import java.security.SecureRandom;
import java.util.Date;
import junit.framework.Assert;
import org.junit.Test;
import org.springframework.security.token.DefaultToken;
import org.springframework.security.token.KeyBasedPersistenceTokenService;
import org.springframework.security.token.SecureRandomFactoryBean;
import org.springframework.security.token.Token;

public class KeyBasedPersistenceTokenServiceTests {
    private KeyBasedPersistenceTokenService getService() {
        SecureRandomFactoryBean fb = new SecureRandomFactoryBean();
        KeyBasedPersistenceTokenService service = new KeyBasedPersistenceTokenService();
        service.setServerSecret("MY:SECRET$$$#");
        service.setServerInteger(new Integer(454545));
        try {
            SecureRandom rnd = (SecureRandom)fb.getObject();
            service.setSecureRandom(rnd);
            service.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return service;
    }

    @Test
    public void testOperationWithSimpleExtendedInformation() {
        KeyBasedPersistenceTokenService service = this.getService();
        Token token = service.allocateToken("Hello world");
        Token result = service.verifyToken(token.getKey());
        Assert.assertEquals((Object)token, (Object)result);
    }

    @Test
    public void testOperationWithComplexExtendedInformation() {
        KeyBasedPersistenceTokenService service = this.getService();
        Token token = service.allocateToken("Hello:world:::");
        Token result = service.verifyToken(token.getKey());
        Assert.assertEquals((Object)token, (Object)result);
    }

    @Test
    public void testOperationWithEmptyRandomNumber() {
        KeyBasedPersistenceTokenService service = this.getService();
        service.setPseudoRandomNumberBits(0);
        Token token = service.allocateToken("Hello:world:::");
        Token result = service.verifyToken(token.getKey());
        Assert.assertEquals((Object)token, (Object)result);
    }

    @Test
    public void testOperationWithNoExtendedInformation() {
        KeyBasedPersistenceTokenService service = this.getService();
        Token token = service.allocateToken("");
        Token result = service.verifyToken(token.getKey());
        Assert.assertEquals((Object)token, (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOperationWithMissingKey() {
        KeyBasedPersistenceTokenService service = this.getService();
        DefaultToken token = new DefaultToken("", new Date().getTime(), "");
        service.verifyToken(token.getKey());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOperationWithTamperedKey() {
        KeyBasedPersistenceTokenService service = this.getService();
        Token goodToken = service.allocateToken("");
        String fake = goodToken.getKey().toUpperCase();
        DefaultToken token = new DefaultToken(fake, new Date().getTime(), "");
        service.verifyToken(token.getKey());
    }
}

