/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.ldap.authenticator;

import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.Constraint;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.Authentication;
import org.springframework.security.ldap.MockSpringSecurityContextSource;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.ldap.authenticator.PasswordComparisonAuthenticator;

public class PasswordComparisonAuthenticatorMockTests
extends MockObjectTestCase {
    public void testLdapCompareIsUsedWhenPasswordIsNotRetrieved() throws Exception {
        Mock mockCtx = this.mock(DirContext.class);
        BasicAttributes attrs = new BasicAttributes();
        attrs.put(new BasicAttribute("uid", "bob"));
        PasswordComparisonAuthenticator authenticator = new PasswordComparisonAuthenticator((BaseLdapPathContextSource)new MockSpringSecurityContextSource((DirContext)mockCtx.proxy(), ""));
        authenticator.setUserDnPatterns(new String[]{"cn={0},ou=people"});
        mockCtx.expects(this.once()).method("getAttributes").with((Constraint)this.eq("cn=Bob,ou=people"), NULL).will(this.returnValue(attrs));
        mockCtx.expects(this.once()).method("getNameInNamespace").will(this.returnValue("dc=springframework,dc=org"));
        BasicAttributes searchResults = new BasicAttributes("", null);
        mockCtx.expects(this.once()).method("search").with((Constraint)this.eq("cn=Bob, ou=people"), (Constraint)this.eq("(userPassword={0})"), NOT_NULL, NOT_NULL).will(this.returnValue(searchResults.getAll()));
        mockCtx.expects(this.atLeastOnce()).method("close");
        authenticator.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"Bob", (Object)"bobspassword"));
    }
}

