/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.search;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.ldap.AbstractLdapIntegrationTests;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class FilterBasedLdapUserSearchTests
extends AbstractLdapIntegrationTests {
    private BaseLdapPathContextSource dirCtxFactory;

    public void onSetUp() throws Exception {
        super.onSetUp();
        this.dirCtxFactory = this.getContextSource();
    }

    @Test
    public void basicSearchSucceeds() {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("ou=people", "(uid={0})", this.dirCtxFactory);
        locator.setSearchSubtree(false);
        locator.setSearchTimeLimit(0);
        locator.setDerefLinkFlag(false);
        DirContextOperations bob = locator.searchForUser("bob");
        Assert.assertEquals((Object)"bob", (Object)bob.getStringAttribute("uid"));
        Assert.assertEquals((Object)new DistinguishedName("uid=bob,ou=people"), (Object)bob.getDn());
    }

    @Test
    public void searchForNameWithCommaSucceeds() {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("ou=people", "(uid={0})", this.dirCtxFactory);
        locator.setSearchSubtree(false);
        DirContextOperations jerry = locator.searchForUser("jerry");
        Assert.assertEquals((Object)"jerry", (Object)jerry.getStringAttribute("uid"));
        Assert.assertEquals((Object)new DistinguishedName("cn=mouse\\, jerry,ou=people"), (Object)jerry.getDn());
    }

    @Test
    public void extraFilterPartToExcludeBob() throws Exception {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("ou=people", "(&(cn=*)(!(|(uid={0})(uid=rod)(uid=jerry)(uid=slashguy))))", this.dirCtxFactory);
        DirContextOperations ben = locator.searchForUser("bob");
        Assert.assertEquals((Object)"Ben Alex", (Object)ben.getStringAttribute("cn"));
    }

    @Test(expected=IncorrectResultSizeDataAccessException.class)
    public void searchFailsOnMultipleMatches() {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("ou=people", "(cn=*)", this.dirCtxFactory);
        locator.searchForUser("Ignored");
    }

    @Test(expected=UsernameNotFoundException.class)
    public void searchForInvalidUserFails() {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("ou=people", "(uid={0})", this.dirCtxFactory);
        locator.searchForUser("Joe");
    }

    @Test
    public void subTreeSearchSucceeds() {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("", "(cn={0})", this.dirCtxFactory);
        locator.setSearchSubtree(true);
        DirContextOperations ben = locator.searchForUser("Ben Alex");
        Assert.assertEquals((Object)"ben", (Object)ben.getStringAttribute("uid"));
        Assert.assertEquals((Object)new DistinguishedName("uid=ben,ou=people"), (Object)ben.getDn());
    }

    @Test
    public void searchWithDifferentSearchBaseIsSuccessful() throws Exception {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("ou=otherpeople", "(cn={0})", this.dirCtxFactory);
        DirContextOperations joe = locator.searchForUser("Joe Smeth");
        Assert.assertEquals((Object)"Joe Smeth", (Object)joe.getStringAttribute("cn"));
    }
}

