/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.intercept.method.MockMethodDefinitionSource;
import org.springframework.security.util.SimpleMethodInvocation;

public class AbstractMethodDefinitionSourceTests
extends TestCase {
    public AbstractMethodDefinitionSourceTests() {
    }

    public AbstractMethodDefinitionSourceTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(AbstractMethodDefinitionSourceTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDoesNotSupportAnotherObject() {
        MockMethodDefinitionSource mds = new MockMethodDefinitionSource(false, true);
        AbstractMethodDefinitionSourceTests.assertFalse((boolean)mds.supports(String.class));
    }

    public void testGetAttributesForANonMethodInvocation() {
        MockMethodDefinitionSource mds = new MockMethodDefinitionSource(false, true);
        try {
            mds.getAttributes(new String());
            AbstractMethodDefinitionSourceTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractMethodDefinitionSourceTests.assertTrue((boolean)true);
        }
    }

    public void testGetAttributesForANullObject() {
        MockMethodDefinitionSource mds = new MockMethodDefinitionSource(false, true);
        try {
            mds.getAttributes(null);
            AbstractMethodDefinitionSourceTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractMethodDefinitionSourceTests.assertTrue((boolean)true);
        }
    }

    public void testGetAttributesForMethodInvocation() {
        MockMethodDefinitionSource mds = new MockMethodDefinitionSource(false, true);
        try {
            mds.getAttributes(new SimpleMethodInvocation());
            AbstractMethodDefinitionSourceTests.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            AbstractMethodDefinitionSourceTests.assertTrue((boolean)true);
        }
    }

    public void testSupportsMethodInvocation() {
        MockMethodDefinitionSource mds = new MockMethodDefinitionSource(false, true);
        AbstractMethodDefinitionSourceTests.assertTrue((boolean)mds.supports(MethodInvocation.class));
    }
}

