/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.context.httpinvoker;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.context.httpinvoker.AuthenticationSimpleHttpInvokerRequestExecutor;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class AuthenticationSimpleHttpInvokerRequestExecutorTests
extends TestCase {
    public AuthenticationSimpleHttpInvokerRequestExecutorTests() {
    }

    public AuthenticationSimpleHttpInvokerRequestExecutorTests(String arg0) {
        super(arg0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testNormalOperation() throws Exception {
        UsernamePasswordAuthenticationToken clientSideAuthentication = new UsernamePasswordAuthenticationToken((Object)"Aladdin", (Object)"open sesame");
        SecurityContextHolder.getContext().setAuthentication((Authentication)clientSideAuthentication);
        AuthenticationSimpleHttpInvokerRequestExecutor executor = new AuthenticationSimpleHttpInvokerRequestExecutor();
        MockHttpURLConnection conn = new MockHttpURLConnection(new URL("http://localhost/"));
        executor.prepareConnection((HttpURLConnection)conn, 10);
        AuthenticationSimpleHttpInvokerRequestExecutorTests.assertEquals((String)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==", (String)((URLConnection)conn).getRequestProperty("Authorization"));
    }

    public void testNullContextHolderIsNull() throws Exception {
        SecurityContextHolder.getContext().setAuthentication(null);
        AuthenticationSimpleHttpInvokerRequestExecutor executor = new AuthenticationSimpleHttpInvokerRequestExecutor();
        MockHttpURLConnection conn = new MockHttpURLConnection(new URL("http://localhost/"));
        executor.prepareConnection((HttpURLConnection)conn, 10);
        AuthenticationSimpleHttpInvokerRequestExecutorTests.assertNull((Object)((URLConnection)conn).getRequestProperty("Authorization"));
    }

    private class MockHttpURLConnection
    extends HttpURLConnection {
        private Map requestProperties;

        public MockHttpURLConnection(URL u) {
            super(u);
            this.requestProperties = new HashMap();
        }

        public void connect() throws IOException {
            throw new UnsupportedOperationException("mock not implemented");
        }

        public void disconnect() {
            throw new UnsupportedOperationException("mock not implemented");
        }

        public String getRequestProperty(String key) {
            return (String)this.requestProperties.get(key);
        }

        public void setRequestProperty(String key, String value) {
            this.requestProperties.put(key, value);
        }

        public boolean usingProxy() {
            throw new UnsupportedOperationException("mock not implemented");
        }
    }
}

