/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.security.afterinvocation.AfterInvocationProviderManager;
import org.springframework.security.config.MockAfterInvocationProvider;
import org.springframework.security.intercept.method.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.util.InMemoryXmlApplicationContext;

public class CustomAfterInvocationProviderBeanDefinitionDecoratorTests {
    private AbstractXmlApplicationContext appContext;

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
            this.appContext = null;
        }
    }

    @Test
    public void customAfterInvocationProviderIsAddedToInterceptor() {
        this.setContext("<global-method-security /><b:bean id='aip' class='org.springframework.security.config.MockAfterInvocationProvider'>    <custom-after-invocation-provider /></b:bean>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        MethodSecurityInterceptor msi = (MethodSecurityInterceptor)this.appContext.getBean("_methodSecurityInterceptor");
        AfterInvocationProviderManager apm = (AfterInvocationProviderManager)msi.getAfterInvocationManager();
        Assert.assertNotNull((Object)apm);
        Assert.assertEquals((long)1L, (long)apm.getProviders().size());
        Assert.assertTrue((boolean)(apm.getProviders().get(0) instanceof MockAfterInvocationProvider));
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }
}

