/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.afterinvocation;

import java.util.Vector;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.SecurityConfig;
import org.springframework.security.afterinvocation.AfterInvocationProvider;
import org.springframework.security.afterinvocation.AfterInvocationProviderManager;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.util.SimpleMethodInvocation;

public class AfterInvocationProviderManagerTests
extends TestCase {
    public AfterInvocationProviderManagerTests() {
    }

    public AfterInvocationProviderManagerTests(String arg0) {
        super(arg0);
    }

    public void testCorrectOperation() throws Exception {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        Vector<MockAfterInvocationProvider> list = new Vector<MockAfterInvocationProvider>();
        list.add(new MockAfterInvocationProvider("swap1", MethodInvocation.class, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP1")));
        list.add(new MockAfterInvocationProvider("swap2", MethodInvocation.class, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP2")));
        list.add(new MockAfterInvocationProvider("swap3", MethodInvocation.class, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP3")));
        manager.setProviders(list);
        AfterInvocationProviderManagerTests.assertEquals(list, (Object)manager.getProviders());
        manager.afterPropertiesSet();
        ConfigAttributeDefinition attr1 = new ConfigAttributeDefinition(new String[]{"GIVE_ME_SWAP1"});
        ConfigAttributeDefinition attr2 = new ConfigAttributeDefinition(new String[]{"GIVE_ME_SWAP2"});
        ConfigAttributeDefinition attr3 = new ConfigAttributeDefinition(new String[]{"GIVE_ME_SWAP3"});
        ConfigAttributeDefinition attr2and3 = new ConfigAttributeDefinition(new String[]{"GIVE_ME_SWAP2", "GIVE_ME_SWAP3"});
        ConfigAttributeDefinition attr4 = new ConfigAttributeDefinition(new String[]{"NEVER_CAUSES_SWAP"});
        AfterInvocationProviderManagerTests.assertEquals((Object)"swap1", (Object)manager.decide(null, (Object)new SimpleMethodInvocation(), attr1, (Object)"content-before-swapping"));
        AfterInvocationProviderManagerTests.assertEquals((Object)"swap2", (Object)manager.decide(null, (Object)new SimpleMethodInvocation(), attr2, (Object)"content-before-swapping"));
        AfterInvocationProviderManagerTests.assertEquals((Object)"swap3", (Object)manager.decide(null, (Object)new SimpleMethodInvocation(), attr3, (Object)"content-before-swapping"));
        AfterInvocationProviderManagerTests.assertEquals((Object)"content-before-swapping", (Object)manager.decide(null, (Object)new SimpleMethodInvocation(), attr4, (Object)"content-before-swapping"));
        AfterInvocationProviderManagerTests.assertEquals((Object)"swap3", (Object)manager.decide(null, (Object)new SimpleMethodInvocation(), attr2and3, (Object)"content-before-swapping"));
    }

    public void testRejectsEmptyProvidersList() {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        Vector list = new Vector();
        try {
            manager.setProviders(list);
            AfterInvocationProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AfterInvocationProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNonAfterInvocationProviders() {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        Vector<Object> list = new Vector<Object>();
        list.add(new MockAfterInvocationProvider("swap1", MethodInvocation.class, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP1")));
        list.add(new Integer(45));
        list.add(new MockAfterInvocationProvider("swap3", MethodInvocation.class, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP3")));
        try {
            manager.setProviders(list);
            AfterInvocationProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AfterInvocationProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNullProvidersList() throws Exception {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        try {
            manager.afterPropertiesSet();
            AfterInvocationProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AfterInvocationProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testSupportsConfigAttributeIteration() throws Exception {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        Vector<MockAfterInvocationProvider> list = new Vector<MockAfterInvocationProvider>();
        list.add(new MockAfterInvocationProvider("swap1", MethodInvocation.class, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP1")));
        list.add(new MockAfterInvocationProvider("swap2", MethodInvocation.class, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP2")));
        list.add(new MockAfterInvocationProvider("swap3", MethodInvocation.class, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP3")));
        manager.setProviders(list);
        manager.afterPropertiesSet();
        AfterInvocationProviderManagerTests.assertFalse((boolean)manager.supports((ConfigAttribute)new SecurityConfig("UNKNOWN_ATTRIB")));
        AfterInvocationProviderManagerTests.assertTrue((boolean)manager.supports((ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP2")));
    }

    public void testSupportsSecureObjectIteration() throws Exception {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        Vector<MockAfterInvocationProvider> list = new Vector<MockAfterInvocationProvider>();
        list.add(new MockAfterInvocationProvider("swap1", MethodInvocation.class, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP1")));
        list.add(new MockAfterInvocationProvider("swap2", MethodInvocation.class, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP2")));
        list.add(new MockAfterInvocationProvider("swap3", MethodInvocation.class, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP3")));
        manager.setProviders(list);
        manager.afterPropertiesSet();
        AfterInvocationProviderManagerTests.assertFalse((boolean)manager.supports(FilterInvocation.class));
        AfterInvocationProviderManagerTests.assertTrue((boolean)manager.supports(MethodInvocation.class));
    }

    private class MockAfterInvocationProvider
    implements AfterInvocationProvider {
        private Class secureObject;
        private ConfigAttribute configAttribute;
        private Object forceReturnObject;

        public MockAfterInvocationProvider(Object forceReturnObject, Class secureObject, ConfigAttribute configAttribute) {
            this.forceReturnObject = forceReturnObject;
            this.secureObject = secureObject;
            this.configAttribute = configAttribute;
        }

        public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
            if (config.contains(this.configAttribute)) {
                return this.forceReturnObject;
            }
            return returnedObject;
        }

        public boolean supports(Class clazz) {
            return this.secureObject.isAssignableFrom(clazz);
        }

        public boolean supports(ConfigAttribute attribute) {
            return attribute.equals(this.configAttribute);
        }
    }
}

