/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;

public class GrantedAuthorityImplTests {
    @Test
    public void equalsBehavesAsExpected() throws Exception {
        GrantedAuthorityImpl auth1 = new GrantedAuthorityImpl("TEST");
        GrantedAuthorityImpl auth2 = new GrantedAuthorityImpl("TEST");
        Assert.assertEquals((Object)auth1, (Object)auth2);
        String authString1 = "TEST";
        Assert.assertEquals((Object)auth1, (Object)authString1);
        String authString2 = "NOT_EQUAL";
        Assert.assertTrue((!auth1.equals((Object)authString2) ? 1 : 0) != 0);
        GrantedAuthorityImpl auth3 = new GrantedAuthorityImpl("NOT_EQUAL");
        Assert.assertTrue((!auth1.equals((Object)auth3) ? 1 : 0) != 0);
        MockGrantedAuthority mock1 = new MockGrantedAuthority("TEST");
        Assert.assertEquals((Object)auth1, (Object)mock1);
        MockGrantedAuthority mock2 = new MockGrantedAuthority("NOT_EQUAL");
        Assert.assertTrue((!auth1.equals((Object)mock2) ? 1 : 0) != 0);
        Integer int1 = new Integer(222);
        Assert.assertTrue((!auth1.equals((Object)int1) ? 1 : 0) != 0);
    }

    @Test
    public void toStringReturnsAuthorityValue() {
        GrantedAuthorityImpl auth = new GrantedAuthorityImpl("TEST");
        Assert.assertEquals((Object)"TEST", (Object)auth.toString());
    }

    @Test
    public void compareToGrantedAuthorityWithSameValueReturns0() {
        Assert.assertEquals((long)0L, (long)new GrantedAuthorityImpl("TEST").compareTo((Object)new MockGrantedAuthority("TEST")));
    }

    @Test
    public void compareToNullReturnsNegativeOne() {
        Assert.assertEquals((long)-1L, (long)new GrantedAuthorityImpl("TEST").compareTo(null));
    }

    @Test
    public void compareToHandlesCustomAuthorityWhichReturnsNullFromGetAuthority() {
        Assert.assertEquals((long)-1L, (long)new GrantedAuthorityImpl("TEST").compareTo((Object)new MockGrantedAuthority()));
    }

    private class MockGrantedAuthority
    implements GrantedAuthority {
        private String role;

        public MockGrantedAuthority() {
        }

        public MockGrantedAuthority(String role) {
            this.role = role;
        }

        public int compareTo(Object o) {
            throw new UnsupportedOperationException();
        }

        public String getAuthority() {
            return this.role;
        }
    }
}

