/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.HtmlExportUtil;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ReportExporter;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.GetService;
import com.jaspersoft.jasperserver.ws.xml.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.activation.DataSource;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.GenericElementReportTransformer;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunReportService
extends AbstractService {
    private static final Log log = LogFactory.getLog(GetService.class);

    public RunReportService(ApplicationContext context) {
        super(context);
    }

    public OperationResult runReport(String reportUnitURI, Map<String, Object> parameters, Map<String, String> arguments) throws ServiceException {
        long currentTime = System.currentTimeMillis();
        this.getManagementServices().getAuditHelper().createAuditEvent("runReport");
        OperationResult or = this.getServicesUtils().createOperationResult(0, null);
        try {
            String format = arguments.get("RUN_OUTPUT_FORMAT");
            if (format == null) {
                format = "PDF";
            }
            format = format.toUpperCase();
            String transformerKey = arguments.get("TRANSFORMER_KEY");
            Resource reportResource = this.getManagementServices().getRepository().getResource(null, reportUnitURI);
            if (reportResource == null || !(reportResource instanceof ReportUnit)) {
                throw new ServiceException(2, this.getMessage("webservices.error.notValidReportUnit", new Object[]{reportUnitURI}));
            }
            parameters = this.getManagementServices().getRepositoryHelper().convertParameterValues(reportUnitURI, parameters);
            ReportUnitResult result = (ReportUnitResult)this.getManagementServices().getRunReportEngine().execute(this.createExecutionContext(), (Request)new ReportUnitRequest(reportUnitURI, parameters));
            if (result == null) {
                throw new ServiceException(5, this.getMessage("webservices.error.errorExecutingReportUnit", new Object[]{reportUnitURI}));
            }
            JasperPrint jasperPrint = result.getJasperPrint();
            or = this.exportReport(reportUnitURI, jasperPrint, arguments);
            this.getAttributes().put("jasperPrint", jasperPrint);
            if (or.getReturnCode() != 0) {
                this.getManagementServices().getAuditHelper().addExceptionToAllAuditEvents(new Exception(or.getMessage()));
            }
        }
        catch (ServiceException e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)((Object)e));
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
            this.getManagementServices().getAuditHelper().addExceptionToAllAuditEvents((Throwable)((Object)e));
        }
        catch (Throwable e) {
            log.error((Object)("caught Throwable exception: " + e.getMessage()), e);
            e.printStackTrace(System.out);
            System.out.flush();
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.getManagementServices().getAuditHelper().addExceptionToAllAuditEvents(e);
        }
        this.getManagementServices().getAuditHelper().addPropertyToAuditEvent("runReport", "reportExecutionStartTime", new Date(currentTime));
        this.getManagementServices().getAuditHelper().addPropertyToAuditEvent("runReport", "reportExecutionTime", System.currentTimeMillis() - currentTime);
        return or;
    }

    public OperationResult exportReport(String reportUnitURI, JasperPrint jasperPrint, Map<String, String> arguments) throws ServiceException {
        long currentTime = System.currentTimeMillis();
        this.getManagementServices().getAuditHelper().createAuditEvent("runReport");
        OperationResult or = this.getServicesUtils().createOperationResult(0, null);
        try {
            String format = arguments.get("RUN_OUTPUT_FORMAT");
            if (format == null) {
                format = "PDF";
            }
            format = format.toUpperCase();
            String transformerKey = arguments.get("TRANSFORMER_KEY");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayDataSource bads = null;
            if (format.equals("JRPRINT")) {
                log.debug((Object)"Returning JasperPrint");
                if (transformerKey != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Transforming JasperPrint generic element for key " + transformerKey));
                    }
                    GenericElementReportTransformer.transformGenericElements((JasperPrint)jasperPrint, (String)transformerKey);
                }
                JRSaver.saveObject((Object)jasperPrint, (OutputStream)bos);
                bads = new ByteArrayDataSource(bos.toByteArray());
                this.getOutputAttachments().put("jasperPrint", (DataSource)bads);
            } else {
                Map exporterParams;
                HashMap<String, String> exportParameters = new HashMap<String, String>();
                String value = arguments.get("PAGE");
                if (value != null) {
                    exportParameters.put("PAGE", value);
                }
                if ((value = arguments.get("IMAGES_URI")) != null) {
                    exportParameters.put("IMAGES_URI", value);
                }
                try {
                    exporterParams = this.exportReport(reportUnitURI, jasperPrint, format, bos, exportParameters);
                    log.error((Object)("Exporter params: " + Arrays.asList(exporterParams.keySet().toArray())));
                }
                catch (Exception e) {
                    log.error((Object)"Error exporting report", (Throwable)e);
                    throw new ServiceException(4, this.getMessage("webservices.error.errorExportingReportUnit", new Object[]{e.getMessage()}));
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException ex) {}
                    }
                }
                bads = new ByteArrayDataSource(bos.toByteArray(), this.getContentType(format));
                this.getOutputAttachments().put("report", (DataSource)bads);
                this.addAdditionalAttachmentsForReport(jasperPrint, format, exporterParams);
            }
            if (or.getReturnCode() != 0) {
                this.getManagementServices().getAuditHelper().addExceptionToAllAuditEvents(new Exception(or.getMessage()));
            }
        }
        catch (ServiceException e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)((Object)e));
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
            this.getManagementServices().getAuditHelper().addExceptionToAllAuditEvents((Throwable)((Object)e));
        }
        catch (Throwable e) {
            log.error((Object)("caught Throwable exception: " + e.getMessage()), e);
            e.printStackTrace(System.out);
            System.out.flush();
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.getManagementServices().getAuditHelper().addExceptionToAllAuditEvents(e);
        }
        this.getManagementServices().getAuditHelper().addPropertyToAuditEvent("runReport", "reportExecutionStartTime", new Date(currentTime));
        this.getManagementServices().getAuditHelper().addPropertyToAuditEvent("runReport", "reportExecutionTime", System.currentTimeMillis() - currentTime);
        return or;
    }

    protected ExecutionContext createExecutionContext() {
        ExecutionContextImpl ctx = new ExecutionContextImpl();
        ctx.setLocale(this.getLocale());
        ctx.setTimeZone(TimeZone.getDefault());
        return ctx;
    }

    public JRExporter getExporter(String type, Map exportParameters) {
        JRExporter exporter = null;
        if (type.equals("HTML")) {
            exporter = HtmlExportUtil.getHtmlExporter();
            if (exportParameters.get("IMAGES_URI") != null) {
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)("" + exportParameters.get("IMAGES_URI")));
            } else {
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"images/");
            }
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, new LinkedHashMap());
        } else if (type.equals("XLS")) {
            exporter = new JExcelApiExporter();
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        } else if (type.equals("CSV")) {
            exporter = new JRCsvExporter();
        } else if (type.equals("XML")) {
            exporter = new JRXmlExporter();
        } else if (type.equals("RTF")) {
            exporter = new JRRtfExporter();
        }
        if (exporter != null && exportParameters.get("PAGE") != null) {
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)new Integer("" + exportParameters.get("PAGE")));
        }
        return exporter;
    }

    public String getContentType(String type) {
        String contentType = null;
        if (type.equals("PDF")) {
            contentType = "application/pdf";
        } else if (type.equals("HTML")) {
            contentType = "text/html";
        } else if (type.equals("XLS")) {
            contentType = "application/xls";
        } else if (type.equals("CSV")) {
            contentType = "application/vnd.ms-excel";
        } else if (type.equals("XML")) {
            contentType = "text/xml";
        } else if (type.equals("RTF")) {
            contentType = "application/rtf";
        }
        return contentType;
    }

    private void addAdditionalAttachmentsForReport(JasperPrint jasperPrint, String format, Map exportParameters) throws ServiceException {
        log.error((Object)("Format requested: " + format + "  " + "HTML"));
        if (!format.equals("HTML")) {
            return;
        }
        try {
            Map imagesMap = (Map)exportParameters.get(JRHtmlExporterParameter.IMAGES_MAP);
            log.error((Object)("imagesMap : " + Arrays.asList(imagesMap.keySet().toArray())));
            for (Map.Entry entry : imagesMap.entrySet()) {
                String name = (String)entry.getKey();
                byte[] data = (byte[])entry.getValue();
                byte imageType = JRTypeSniffer.getImageType((byte[])data);
                String mimeType = JRTypeSniffer.getImageMimeType((byte)imageType);
                log.error((Object)("Adding image for HTML: " + name + ", type: " + mimeType));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding image for HTML: " + name + ", type: " + mimeType));
                }
                ByteArrayDataSource bads = new ByteArrayDataSource(data, mimeType);
                this.getOutputAttachments().put(name, (DataSource)bads);
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new ServiceException(4, this.getMessage("webservices.error.errorAddingImage", new Object[]{e.getMessage()}));
        }
    }

    protected Map exportReport(String reportUnitURI, JasperPrint jasperPrint, String format, OutputStream output, HashMap exportParameters) throws ServiceException {
        ReportExporter exporter = this.getManagementServices().getServiceConfiguration().getExporter(format.toLowerCase());
        if (exporter == null) {
            throw new ServiceException(3, "Export format " + format.toLowerCase() + " not supported or misconfigured");
        }
        try {
            return exporter.exportReport(jasperPrint, output, this.getManagementServices().getEngine(), exportParameters, this.createExecutionContext(), reportUnitURI);
        }
        catch (Exception ex) {
            throw new ServiceException(3, ex.getMessage() + " (while exporting the report)");
        }
    }
}

