/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.AncestorFolderFilter;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElementOr;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ServiceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.UserDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListService
extends AbstractService {
    private static final Log log = LogFactory.getLog(ListService.class);

    public ListService(ApplicationContext context) {
        super(context);
    }

    public List listResources(String uri) throws ServiceException {
        return this.listResources(uri, 0);
    }

    public List listResources(String uri, int maxItems) throws ServiceException {
        log.debug((Object)("list for uri: " + uri));
        log.debug((Object)("Max items: " + maxItems));
        List<ResourceDescriptor> listOfResources = new ArrayList();
        Resource resource = this.getManagementServices().locateResource(uri);
        if (resource == null) {
            log.warn((Object)("No resource " + uri + " found"));
            throw new ServiceException(404, "Invalid uri or not existing resource");
        }
        if (resource instanceof Folder) {
            List folders = this.getManagementServices().getRepository().getSubFolders(null, uri);
            this.filterFolderList(folders);
            if (folders == null) {
                return listOfResources;
            }
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("NO_ATTACHMENT", Boolean.TRUE);
            for (int i = 0; i < folders.size(); ++i) {
                Resource folderRes = (Resource)folders.get(i);
                listOfResources.add(this.getManagementServices().createResourceDescriptor(folderRes));
            }
            FilterCriteria filterCriteria = new FilterCriteria();
            filterCriteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)uri));
            List units = this.getManagementServices().getRepository().loadClientResources(filterCriteria);
            if (units != null) {
                Iterator it = units.iterator();
                while (units != null && it.hasNext()) {
                    Resource fileRes = (Resource)it.next();
                    try {
                        listOfResources.add(this.getManagementServices().createResourceDescriptor(fileRes, options));
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                    }
                }
            }
        } else if (resource instanceof ReportUnit) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("ReportUnitContents", Boolean.TRUE);
            listOfResources = this.getManagementServices().createResourceDescriptor(uri).getChildren();
        }
        if (maxItems > 0 && maxItems < listOfResources.size()) {
            log.debug((Object)("There are " + listOfResources.size() + " found. Getting indexes from 0 to " + maxItems));
            listOfResources = listOfResources.subList(0, maxItems);
        }
        return listOfResources;
    }

    public List getResources(FilterCriteria criteria) throws ServiceException {
        return this.getResources(criteria, 0, null);
    }

    public List getResources(FilterCriteria criteria, int maxItems, List<String> wsTypes) throws ServiceException {
        ArrayList<ResourceDescriptor> listOfResources = new ArrayList<ResourceDescriptor>();
        if (criteria == null) {
            return listOfResources;
        }
        List lookups = this.getManagementServices().getRepository().loadClientResources(criteria);
        if (lookups != null && !lookups.isEmpty()) {
            Iterator it = lookups.iterator();
            while (it.hasNext()) {
                ResourceDescriptor rd = this.getManagementServices().createResourceDescriptor((Resource)it.next());
                if (wsTypes != null && !wsTypes.contains(rd.getWsType())) continue;
                listOfResources.add(rd);
                if (maxItems <= 0 || listOfResources.size() != maxItems) continue;
                break;
            }
        }
        return listOfResources;
    }

    public List getResources(String uri, String queryString, List<String> wsTypes, boolean recursive, int maxItems) throws ServiceException {
        AncestorFolderFilter fe;
        Resource resource = this.getManagementServices().locateResource(uri);
        if (resource instanceof Folder) {
            ArrayList<Folder> folders = new ArrayList<Folder>();
            folders.add((Folder)resource);
            this.filterFolderList(folders);
            if (folders.isEmpty()) {
                throw new ServiceException(403, "Folder not accessible");
            }
        }
        FilterCriteria criteria = FilterCriteria.createFilter();
        ArrayList filters = new ArrayList();
        if (recursive) {
            fe = FilterCriteria.createAncestorFolderFilter((String)uri);
            criteria.addFilterElement((FilterElement)fe);
        } else {
            fe = FilterCriteria.createParentFolderFilter((String)uri);
            criteria.addFilterElement((FilterElement)fe);
        }
        if (queryString != null && queryString.length() > 0) {
            FilterElementOr feOr_left = new FilterElementOr((FilterElement)FilterCriteria.createPropertyLikeFilter((String)"name", (Object)("%" + queryString + "%")), (FilterElement)FilterCriteria.createPropertyLikeFilter((String)"label", (Object)("%" + queryString + "%")));
            FilterElementOr feOr = new FilterElementOr((FilterElement)feOr_left, (FilterElement)FilterCriteria.createPropertyLikeFilter((String)"description", (Object)("%" + queryString + "%")));
            criteria.addFilterElement((FilterElement)feOr);
        }
        if (wsTypes != null && !wsTypes.isEmpty()) {
            for (String resourceType : wsTypes) {
                ResourceHandler resHandler = this.getManagementServices().getHandlerRegistry().getHandler(resourceType);
                if (resHandler == null) {
                    throw new ServiceException(400, "Invalid resource type: " + resourceType);
                }
                criteria.setFilterClass(resHandler.getResourceType());
            }
        }
        return this.getResources(criteria, maxItems, wsTypes);
    }

    private void filterFolderList(List folderList) {
        if (folderList == null || folderList.isEmpty()) {
            return;
        }
        Set<String> roles = this.getCurrentUserRoles();
        Iterator i = folderList.iterator();
        while (i.hasNext()) {
            Folder folder = (Folder)i.next();
            if (!this.getManagementServices().getServiceConfiguration().getTempFolder().equals(folder.getURIString())) continue;
            boolean accessDenied = true;
            if (roles != null && roles.size() > 0) {
                for (String role : roles) {
                    if (!this.getManagementServices().getServiceConfiguration().getRoleToAccessTempFolder().equals(role)) continue;
                    accessDenied = false;
                    break;
                }
            }
            if (!accessDenied) continue;
            i.remove();
        }
    }

    private Set<String> getCurrentUserRoles() {
        HashSet<String> roleNames = new HashSet<String>();
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        if (authenticationToken == null) {
            return roleNames;
        }
        if (authenticationToken.getPrincipal() instanceof UserDetails) {
            UserDetails contextUserDetails = (UserDetails)authenticationToken.getPrincipal();
            for (GrantedAuthority authority : contextUserDetails.getAuthorities()) {
                roleNames.add(authority.getAuthority());
            }
        }
        return roleNames;
    }
}

