/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.UniversalValidationErrorFilter;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.core.util.ResourceUtil;
import com.jaspersoft.jasperserver.remote.RepositoryServiceContext;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.AbstractResourceHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RepositoryResourceHandler
extends AbstractResourceHandler {
    private static final Log log = LogFactory.getLog(RepositoryResourceHandler.class);

    protected void saveValidated(RepositoryService repository, Resource resource, RepositoryServiceContext serviceContext) throws ServiceException {
        Object filter = resource.isNew() ? UniversalValidationErrorFilter.getInstance() : null;
        ValidationErrors errors = repository.validateResource(null, resource, (ValidationErrorFilter)filter);
        if (errors.isError()) {
            throw new ServiceException(403, errors.toString());
        }
        repository.saveResource(null, resource);
    }

    public void move(Request request, RepositoryServiceContext serviceContext) throws ServiceException {
        String sourceURI = request.getResourceDescriptor().getUriString();
        String destinationURI = this.getDestinationURI(request, serviceContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Moving resource " + sourceURI + " to folder " + destinationURI));
        }
        if (!this.getResourceActionResolver().canCreateResource(destinationURI)) {
            throw new ServiceException(1, serviceContext.getMessage("webservices.error.cannotCreateResource", new String[]{destinationURI}));
        }
        serviceContext.getRepository().moveResource(null, sourceURI, destinationURI);
    }

    public ResourceDescriptor copy(Request request, RepositoryServiceContext serviceContext) throws ServiceException {
        String sourceURI = request.getResourceDescriptor().getUriString();
        String destinationURI = this.getDestinationURI(request, serviceContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Copying resource " + sourceURI + " to URI " + destinationURI));
        }
        if (!this.getResourceActionResolver().canCreateResource(ResourceUtil.getParentFolder((String)destinationURI))) {
            throw new ServiceException(1, serviceContext.getMessage("webservices.error.cannotCreateResource", new String[]{ResourceUtil.getParentFolder((String)destinationURI)}));
        }
        Resource copy = serviceContext.getRepository().copyResource(null, sourceURI, destinationURI);
        return this.get(copy, new HashMap());
    }

    protected Map getDefaultDescribeArguments() {
        return null;
    }

    protected String getDestinationURI(Request request, RepositoryServiceContext serviceContext) throws ServiceException {
        String destinationURI = request.getArgumentValue("DESTINATION_URI");
        if (destinationURI == null) {
            throw new ServiceException(6, serviceContext.getMessage("webservices.error.request.no.destination.URI", null));
        }
        return destinationURI;
    }

    protected FilterElement additionalListResourcesFilterCriteria(Request request) {
        return null;
    }
}

