/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import java.util.Map;

public class QueryHandler
extends RepositoryResourceHandler {
    public Class getResourceType() {
        return Query.class;
    }

    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        Query fileResource = (Query)resource;
        descriptor.setWsType("query");
        descriptor.setHasData(false);
        descriptor.setIsReference(false);
        descriptor.setSql(fileResource.getSql());
        descriptor.setResourceProperty("PROP_QUERY_LANGUAGE", fileResource.getLanguage());
        ResourceReference rref = fileResource.getDataSource();
        if (rref != null) {
            ResourceDescriptor childRd = null;
            if (rref.isLocal()) {
                childRd = AbstractService.getContext().getManagementServices().createResourceDescriptor(rref.getLocalResource());
            } else {
                childRd = new ResourceDescriptor();
                childRd.setWsType("datasource");
                childRd.setReferenceUri(rref.getReferenceURI());
                childRd.setIsReference(true);
            }
            if (childRd != null) {
                descriptor.getChildren().add(childRd);
            }
        }
    }

    protected void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) {
        super.updateResource(resource, descriptor, options);
        Query query = (Query)resource;
        query.setSql(descriptor.getSql());
        for (int i = 0; i < descriptor.getChildren().size(); ++i) {
            ResourceDescriptor childResource = (ResourceDescriptor)descriptor.getChildren().get(i);
            if (!this.isDataSource(childResource)) continue;
            if (childResource.getIsReference()) {
                query.setDataSourceReference(childResource.getReferenceUri());
                continue;
            }
            ReportDataSource datasource = (ReportDataSource)this.createChildResource(childResource);
            query.setDataSource(datasource);
        }
        String lang = descriptor.getResourcePropertyValue("PROP_QUERY_LANGUAGE");
        if (lang == null || lang.length() == 0) {
            lang = "sql";
        }
        query.setLanguage(lang);
    }
}

