/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.InputControlQueryDataRow;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InputControlHandler
extends RepositoryResourceHandler {
    protected static final Log log = LogFactory.getLog(InputControlHandler.class);

    public Class getResourceType() {
        return InputControl.class;
    }

    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        InputControl fileResource = (InputControl)resource;
        descriptor.setWsType("inputControl");
        descriptor.setHasData(false);
        descriptor.setIsReference(false);
        descriptor.setMandatory(fileResource.isMandatory());
        descriptor.setReadOnly(fileResource.isReadOnly());
        descriptor.setVisible(fileResource.isVisible());
        descriptor.setControlType(fileResource.getType());
        ResourceReference childReference = null;
        if (descriptor.getControlType() == 2) {
            childReference = fileResource.getDataType();
        } else if (descriptor.getControlType() == 3 || descriptor.getControlType() == 8 || descriptor.getControlType() == 6 || descriptor.getControlType() == 10) {
            childReference = fileResource.getListOfValues();
        } else if (descriptor.getControlType() == 4 || descriptor.getControlType() == 9 || descriptor.getControlType() == 7 || descriptor.getControlType() == 11) {
            childReference = fileResource.getQuery();
            descriptor.setQueryValueColumn(fileResource.getQueryValueColumn());
            descriptor.setQueryVisibleColumns(fileResource.getQueryVisibleColumns());
        }
        if (childReference != null) {
            ResourceDescriptor childRd = null;
            if (childReference.isLocal()) {
                childRd = AbstractService.getContext().getManagementServices().createResourceDescriptor(childReference.getLocalResource());
            } else {
                childRd = new ResourceDescriptor();
                childRd.setWsType("reference");
                childRd.setReferenceUri(childReference.getReferenceURI());
            }
            if (childRd != null) {
                descriptor.getChildren().add(childRd);
            }
        }
        if (options != null && options.containsKey("IC_GET_QUERY_DATA")) {
            String dsUri = (String)options.get("IC_GET_QUERY_DATA");
            if ("null".equalsIgnoreCase(dsUri)) {
                dsUri = null;
            }
            List data = this.getInputControlItems(fileResource, dsUri, (Map)options.get("PARAMS_ARG"));
            descriptor.setQueryData(data);
        }
    }

    protected List getInputControlItems(InputControl control, String datasourceUri, Map params) throws ServiceException {
        ArrayList<InputControlQueryDataRow> rows;
        ResourceReference fallbackDataSource = null;
        if (datasourceUri != null && datasourceUri.trim().length() > 0) {
            fallbackDataSource = new ResourceReference(datasourceUri);
        }
        ResourceReference queryRef = control.getQuery();
        String valueColumn = control.getQueryValueColumn();
        String[] visibleColumns = control.getQueryVisibleColumns();
        Map parameters = params == null ? new HashMap() : params;
        parameters.put("REPORT_MAX_COUNT", new Integer(100000));
        OrderedMap results = AbstractService.getContext().getManagementServices().getEngine().executeQuery(null, queryRef, valueColumn, visibleColumns, fallbackDataSource, parameters);
        if (results == null || results.isEmpty()) {
            rows = new ArrayList<InputControlQueryDataRow>(0);
        } else {
            rows = new ArrayList(results.size());
            for (Map.Entry entry : results.entrySet()) {
                Object keyValue = entry.getKey();
                String[] columnValues = (String[])entry.getValue();
                InputControlQueryDataRow ic = new InputControlQueryDataRow();
                ic.setValue(keyValue);
                for (int i = 0; i < columnValues.length; ++i) {
                    String value = columnValues[i];
                    ic.getColumnValues().add(value != null ? value : "");
                }
                rows.add(ic);
            }
        }
        return rows;
    }

    protected void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        super.updateResource(resource, descriptor, options);
        InputControl inputControl = (InputControl)resource;
        inputControl.setMandatory(descriptor.isMandatory());
        inputControl.setReadOnly(descriptor.isReadOnly());
        inputControl.setVisible(descriptor.isVisible());
        inputControl.setType(descriptor.getControlType());
        if (inputControl.getType() == 2) {
            if (descriptor.getChildren().isEmpty()) {
                throw new ServiceException(2, AbstractService.getContext().getMessage("webservices.error.missingDataType"));
            }
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(0);
            if (rd.getWsType().equals("reference")) {
                inputControl.setDataTypeReference(rd.getReferenceUri());
            } else {
                DataType dataType = (DataType)this.createChildResource(rd);
                inputControl.setDataType(dataType);
            }
        } else if (inputControl.getType() == 3 || inputControl.getType() == 8 || inputControl.getType() == 6 || inputControl.getType() == 10) {
            if (descriptor.getChildren().isEmpty()) {
                throw new ServiceException(2, AbstractService.getContext().getMessage("webservices.error.missingLOV"));
            }
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(0);
            if (rd.getWsType().equals("reference")) {
                inputControl.setListOfValuesReference(rd.getReferenceUri());
            } else {
                ListOfValues lovResource = (ListOfValues)this.createChildResource(rd);
                inputControl.setListOfValues(lovResource);
            }
        } else if (inputControl.getType() == 4 || inputControl.getType() == 9 || inputControl.getType() == 7 || inputControl.getType() == 11) {
            int i;
            if (descriptor.getChildren().isEmpty()) {
                throw new ServiceException(2, AbstractService.getContext().getMessage("webservices.error.missingQuery"));
            }
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(0);
            inputControl.setQueryValueColumn(descriptor.getQueryValueColumn());
            String[] visibleColumns = descriptor.getQueryVisibleColumns();
            String[] oldColumns = inputControl.getQueryVisibleColumns();
            if (oldColumns != null) {
                for (i = 0; i < oldColumns.length; ++i) {
                    inputControl.removeQueryVisibleColumn(oldColumns[i]);
                }
            }
            for (i = 0; i < visibleColumns.length; ++i) {
                inputControl.addQueryVisibleColumn(visibleColumns[i]);
            }
            if (rd.getWsType().equals("reference")) {
                inputControl.setQueryReference(rd.getReferenceUri());
            } else {
                Query queryResource = (Query)this.createChildResource(rd);
                inputControl.setQuery(queryResource);
            }
        }
    }
}

