/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ResourceDataSource;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileResourceHandler
extends RepositoryResourceHandler {
    private static final Log log = LogFactory.getLog(FileResourceHandler.class);

    public Class getResourceType() {
        return FileResource.class;
    }

    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        FileResource fileResource = (FileResource)resource;
        descriptor.setWsType(fileResource.getFileType());
        descriptor.setHasData(fileResource.hasData());
        descriptor.setIsReference(fileResource.isReference());
        if (descriptor.getIsReference()) {
            descriptor.setReferenceUri(fileResource.getReferenceURI());
        }
        String resourceType = fileResource.getFileType();
        String contentType = "application/octet-stream";
        if (descriptor.getIsReference()) {
            descriptor.setWsType("reference");
        } else if (resourceType == null) {
            descriptor.setWsType("unknow");
        } else if (resourceType.equals("jrxml")) {
            descriptor.setWsType("jrxml");
            contentType = "text/xml";
        } else if (resourceType.equals("img")) {
            descriptor.setWsType("img");
        } else if (resourceType.equals("font")) {
            descriptor.setWsType("font");
        } else if (resourceType.equals("jar")) {
            descriptor.setWsType("jar");
        } else if (resourceType.equals("prop")) {
            descriptor.setWsType("prop");
            contentType = "text/plain";
        } else if (resourceType.equals("jrtx")) {
            descriptor.setWsType("jrtx");
            contentType = "text/xml";
        } else if (resourceType.equals("xml")) {
            descriptor.setWsType("xml");
            contentType = "text/xml";
        }
        descriptor.setHasData(false);
        if (options == null || !options.containsKey("NO_ATTACHMENT")) {
            descriptor.setHasData(true);
            FileResourceData fileData = AbstractService.getContext().getManagementServices().getRepository().getResourceData(null, descriptor.getUriString());
            ResourceDataSource attachmentSource = new ResourceDataSource(descriptor.getName(), fileData);
            attachmentSource.setContentType(contentType);
            AbstractService.getContext().getOutputAttachments().put("attachment", attachmentSource);
            log.warn((Object)("Placed attachment for " + descriptor.getName() + " in the output attachments list" + " " + AbstractService.getContext()));
            descriptor.setResourceProperty("PROP_ATTACHMENT_ID", "attachment");
        }
    }

    protected Resource createResource(ResourceDescriptor descriptor) throws ServiceException {
        try {
            FileResource resource = (FileResource)super.createResource(descriptor);
            resource.setFileType(descriptor.getWsType());
            InputStream ds = AbstractService.getContext().getInputAttachments().get(descriptor.getUriString()).getInputStream();
            resource.setData(IOUtils.toByteArray((InputStream)ds));
            this.updateResource((Resource)resource, descriptor, null);
            return resource;
        }
        catch (ClassCastException e) {
            throw new ServiceException(500, e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new ServiceException(500, e.getLocalizedMessage());
        }
    }

    protected String getFileType(String wsType) {
        String type = null;
        if (wsType.equals("img")) {
            type = "img";
        } else if (wsType.equals("font")) {
            type = "font";
        } else if (wsType.equals("jar")) {
            type = "jar";
        } else if (wsType.equals("jrxml")) {
            type = "jrxml";
        } else if (wsType.equals("prop")) {
            type = "prop";
        } else if (wsType.equals("jrtx")) {
            type = "jrtx";
        } else if (wsType.equals("xml")) {
            type = "xml";
        }
        return type;
    }
}

