/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote;

import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ResourceActionResolver;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ResourceHandlerRegistry;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.ServicesConfiguration;
import com.jaspersoft.jasperserver.remote.utils.AuditHelper;
import com.jaspersoft.jasperserver.remote.utils.RepositoryHelper;
import com.jaspersoft.jasperserver.ws.axis2.scheduling.ReportSchedulerService;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.MessageSource;
import org.springframework.security.AccessDeniedException;

public class ManagementServices {
    protected static final Log log = LogFactory.getLog(ManagementServices.class);
    private RepositoryService repository;
    private EngineService engine;
    private EngineService runReportEngine;
    private RepositoryHelper repositoryHelper;
    private ResourceHandlerRegistry handlerRegistry;
    private ServicesConfiguration servicesConfiguration;
    private AuditContext auditContext;
    private AuditHelper auditHelper;
    private MessageSource messageSource;
    private BeanFactory beanFactory;
    private ResourceActionResolver resourceActionResolver;
    private ReportSchedulerService reportSchedulerService;

    public String getMessage(String messageCode, Object[] args, Locale locale) {
        return this.getMessageSource().getMessage(messageCode, args, locale);
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public ReportSchedulerService getSchedulerService() {
        return this.reportSchedulerService;
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public EngineService getRunReportEngine() {
        return this.runReportEngine;
    }

    public ResourceHandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }

    public RepositoryHelper getRepositoryHelper() {
        if (this.repositoryHelper == null) {
            this.repositoryHelper = new RepositoryHelper(this.engine);
        }
        return this.repositoryHelper;
    }

    public AuditHelper getAuditHelper() {
        if (this.auditHelper == null) {
            this.auditHelper = new AuditHelper(this.auditContext);
        }
        return this.auditHelper;
    }

    public ServicesConfiguration getServiceConfiguration() {
        return this.servicesConfiguration;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    public void setHandlerRegistry(ResourceHandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setRunReportEngine(EngineService runReportEngine) {
        this.runReportEngine = runReportEngine;
    }

    public void setServiceConfiguration(ServicesConfiguration servicesConfiguration) {
        this.servicesConfiguration = servicesConfiguration;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setReportSchedulerService(ReportSchedulerService reportSchedulerService) throws BeansException {
        this.reportSchedulerService = reportSchedulerService;
    }

    public Resource locateResource(String uri) throws ServiceException {
        try {
            Folder res = null;
            int sep = uri.lastIndexOf("/");
            if (sep < 0) {
                throw new ServiceException("jsexception.invalid.uri", new Object[]{uri});
            }
            String name = uri.substring(sep + Folder.SEPARATOR_LENGTH);
            String folderName = uri.substring(0, sep);
            if (folderName.endsWith("_files")) {
                String parentUri = folderName.substring(0, folderName.length() - "_files".length());
                log.warn((Object)("Loading uri: " + parentUri));
                Resource parentRes = this.getRepository().getResource(null, parentUri);
                if (parentRes != null) {
                    ResourceDescriptor ruRd = this.createResourceDescriptor(folderName);
                    log.warn((Object)("Loaded RU " + res));
                    if (ruRd == null) {
                        return null;
                    }
                    res = this.getRepository().getResource(null, uri);
                    log.warn((Object)("Loaded resource " + uri + " " + res));
                }
            }
            if (res == null) {
                if (folderName.length() == 0) {
                    folderName = "/";
                }
                FilterCriteria filterCriteria = new FilterCriteria();
                filterCriteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderName));
                filterCriteria.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"name", (Object)name));
                List resources = this.getRepository().loadClientResources(filterCriteria);
                if (resources != null && !resources.isEmpty()) {
                    res = (Resource)resources.get(0);
                }
            }
            if (res == null) {
                Folder folder = this.getRepository().getFolder(null, uri);
                if (folder != null) {
                    res = folder;
                } else {
                    throw new ServiceException(404, "Could not locate resource");
                }
            }
            return res;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (ex instanceof AccessDeniedException) {
                throw new ServiceException(403, ex.getLocalizedMessage());
            }
            throw new ServiceException(ex);
        }
    }

    public ResourceDescriptor createResourceDescriptor(Resource resource) throws ServiceException {
        return this.createResourceDescriptor(resource, null);
    }

    public ResourceDescriptor createResourceDescriptor(Resource resource, Map options) throws ServiceException {
        if (resource == null) {
            return null;
        }
        if (resource instanceof ResourceLookup) {
            throw new ServiceException("jsexception.resourcelookup.not.a.resource", new Object[]{resource.getClass().getName()});
        }
        ResourceHandler resourceHandler = this.getHandlerRegistry().getHandler(resource);
        if (resourceHandler == null) {
            throw new ServiceException("No resource handler found for class " + resource.getClass().getName());
        }
        return resourceHandler.get(resource, options);
    }

    public ResourceDescriptor createResourceDescriptor(String uri) throws ServiceException {
        return this.createResourceDescriptor(uri, null);
    }

    public ResourceDescriptor createResourceDescriptor(String uri, Map options) throws ServiceException {
        Resource res = this.locateResource(uri);
        return this.createResourceDescriptor(res, options);
    }

    public ResourceActionResolver getResourceActionResolver() {
        return this.resourceActionResolver;
    }

    public void setResourceActionResolver(ResourceActionResolver resourceActionResolver) {
        this.resourceActionResolver = resourceActionResolver;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }
}

