/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.javadoc.JavadocReport;
import org.apache.maven.plugin.javadoc.JavadocUtil;
import org.apache.maven.plugin.javadoc.options.DocletArtifact;
import org.apache.maven.plugin.javadoc.options.Group;
import org.apache.maven.plugin.javadoc.options.JavadocPathArtifact;
import org.apache.maven.plugin.javadoc.options.OfflineLink;
import org.apache.maven.plugin.javadoc.options.Tag;
import org.apache.maven.plugin.javadoc.options.Taglet;
import org.apache.maven.plugin.javadoc.options.TagletArtifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.PathUtils;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractJavadocMojo
extends AbstractMojo {
    private static final String RESOURCE_DIR = ClassUtils.getPackageName((Class)JavadocReport.class).replace('.', '/');
    private static final String DEFAULT_CSS_NAME = "stylesheet.css";
    private static final String RESOURCE_CSS_DIR = RESOURCE_DIR + "/css";
    private static final float SINCE_JAVADOC_1_4 = 1.4f;
    private static final float SINCE_JAVADOC_1_4_2 = 1.42f;
    private static final float SINCE_JAVADOC_1_5 = 1.5f;
    private static final float SINCE_JAVADOC_1_6 = 1.6f;
    private Settings settings;
    protected MavenProject project;
    private boolean isOffline;
    private File javadocDirectory;
    private String additionalparam;
    private String additionalJOption;
    private ArtifactResolver resolver;
    private ArtifactFactory factory;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private List reactorProjects;
    protected boolean aggregate;
    private ArtifactMetadataSource artifactMetadataSource;
    private boolean debug;
    private String javadocExecutable;
    private String javadocVersion;
    private float fJavadocVersion = 0.0f;
    private boolean breakiterator;
    private String doclet;
    private String docletPath;
    private DocletArtifact docletArtifact;
    private DocletArtifact[] docletArtifacts;
    private String encoding;
    private String excludePackageNames;
    private String extdirs;
    private String locale;
    private String maxmemory;
    private String minmemory;
    private String proxyHost;
    private int proxyPort;
    private boolean old;
    private File overview;
    private String show;
    private boolean quiet;
    private String source;
    private String sourcepath;
    private String subpackages;
    private boolean verbose;
    private boolean author;
    private String bottom;
    private String charset;
    protected File outputDirectory;
    private boolean docfilessubdirs;
    private String docencoding;
    private String doctitle;
    private String excludedocfilessubdir;
    private String footer;
    private Group[] groups;
    private String header;
    private String helpfile;
    private boolean keywords;
    private ArrayList links;
    private OfflineLink[] offlineLinks;
    private boolean linksource;
    private boolean nocomment;
    private boolean nodeprecated;
    private boolean nodeprecatedlist;
    private boolean nohelp;
    private boolean noindex;
    private boolean nonavbar;
    private boolean nooverview;
    private String noqualifier;
    private boolean nosince;
    private boolean notimestamp;
    private boolean notree;
    private String packagesheader;
    private boolean serialwarn;
    private String sourcetab;
    private boolean splitindex;
    private String stylesheet;
    private String stylesheetfile;
    private Tag[] tags;
    private String taglet;
    private String tagletpath;
    private TagletArtifact tagletArtifact;
    private Taglet[] taglets;
    private String top;
    private boolean use;
    private boolean version;
    private String windowtitle;

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    protected List getProjectBuildOutputDirs(MavenProject p) {
        if (StringUtils.isEmpty((String)p.getBuild().getOutputDirectory())) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(p.getBuild().getOutputDirectory());
    }

    protected List getProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getCompileSourceRoots();
    }

    protected List getExecutionProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getExecutionProject().getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getExecutionProject().getCompileSourceRoots();
    }

    protected List getProjectArtifacts(MavenProject p) {
        return p.getCompileArtifacts();
    }

    protected File getJavadocDirectory() {
        return this.javadocDirectory;
    }

    protected String getDoctitle() {
        return this.doctitle;
    }

    protected File getOverview() {
        return this.overview;
    }

    protected String getWindowtitle() {
        return this.windowtitle;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Commandline cmd;
        block65: {
            String classpath;
            File javadocOutputDirectory;
            float jVersion;
            String jExecutable;
            if (this.aggregate && !this.project.isExecutionRoot()) {
                return;
            }
            this.validateJavadocOptions();
            List sourcePaths = this.getSourcePaths();
            List files = this.getFiles(sourcePaths);
            List packageNames = this.getPackageNames(sourcePaths, files);
            List filesWithUnnamedPackages = this.getFilesWithUnnamedPackages(sourcePaths, files);
            if (!this.canGenerateReport(files)) {
                return;
            }
            try {
                jExecutable = this.getJavadocExecutable();
            }
            catch (IOException e) {
                throw new MavenReportException("Unable to find javadoc command: " + e.getMessage(), (Exception)e);
            }
            try {
                jVersion = JavadocUtil.getJavadocVersion(new File(jExecutable));
            }
            catch (IOException e) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)("Unable to find the javadoc version: " + e.getMessage()));
                    this.getLog().warn((CharSequence)("Using the Java version instead of, i.e. " + SystemUtils.JAVA_VERSION_FLOAT));
                }
                jVersion = SystemUtils.JAVA_VERSION_FLOAT;
            }
            catch (CommandLineException e) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)("Unable to find the javadoc version: " + e.getMessage()));
                    this.getLog().warn((CharSequence)("Using the Java the version instead of, i.e. " + SystemUtils.JAVA_VERSION_FLOAT));
                }
                jVersion = SystemUtils.JAVA_VERSION_FLOAT;
            }
            catch (IllegalArgumentException e) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)("Unable to find the javadoc version: " + e.getMessage()));
                    this.getLog().warn((CharSequence)("Using the Java the version instead of, i.e. " + SystemUtils.JAVA_VERSION_FLOAT));
                }
                jVersion = SystemUtils.JAVA_VERSION_FLOAT;
            }
            if (StringUtils.isNotEmpty((String)this.javadocVersion)) {
                try {
                    this.fJavadocVersion = Float.parseFloat(this.javadocVersion);
                }
                catch (NumberFormatException e) {
                    throw new MavenReportException("Unable to parse javadoc version: " + e.getMessage(), (Exception)e);
                }
                if (this.fJavadocVersion != jVersion && this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)("Are you sure about the <javadocVersion/> parameter? It seems to be " + jVersion));
                }
            } else {
                this.fJavadocVersion = jVersion;
            }
            if ((javadocOutputDirectory = new File(this.getOutputDirectory())).exists() && !javadocOutputDirectory.isDirectory()) {
                throw new MavenReportException("IOException: " + this.getOutputDirectory() + " is not a directory.");
            }
            if (javadocOutputDirectory.exists() && !javadocOutputDirectory.canWrite()) {
                throw new MavenReportException("IOException: " + this.getOutputDirectory() + " is not writable.");
            }
            javadocOutputDirectory.mkdirs();
            try {
                this.copyDefaultStylesheet(javadocOutputDirectory);
            }
            catch (IOException e) {
                throw new MavenReportException("Unable to copy default stylesheet: " + e.getMessage(), (Exception)e);
            }
            if (this.docfilessubdirs) {
                try {
                    this.copyJavadocResources(javadocOutputDirectory);
                }
                catch (IOException e) {
                    throw new MavenReportException("Unable to copy javadoc resources: " + e.getMessage(), (Exception)e);
                }
            }
            StringBuffer options = new StringBuffer();
            if (StringUtils.isNotEmpty((String)this.locale)) {
                options.append("-locale ");
                options.append(JavadocUtil.quotedArgument(this.locale));
                options.append(SystemUtils.LINE_SEPARATOR);
            }
            if ((classpath = this.getClasspath()).length() > 0) {
                options.append("-classpath ");
                options.append(JavadocUtil.quotedPathArgument(classpath));
                options.append(SystemUtils.LINE_SEPARATOR);
            }
            cmd = new Commandline();
            cmd.getShell().setQuotedArgumentsEnabled(false);
            cmd.setWorkingDirectory(javadocOutputDirectory.getAbsolutePath());
            cmd.setExecutable(jExecutable);
            this.addMemoryArg(cmd, "-Xmx", this.maxmemory);
            this.addMemoryArg(cmd, "-Xms", this.minmemory);
            this.addProxyArg(cmd);
            if (StringUtils.isNotEmpty((String)this.additionalJOption)) {
                cmd.createArgument().setValue(this.additionalJOption);
            }
            ArrayList<String> arguments = new ArrayList<String>();
            this.addArgIf(arguments, this.breakiterator, "-breakiterator", 1.4f);
            if (StringUtils.isNotEmpty((String)this.doclet)) {
                this.addArgIfNotEmpty(arguments, "-doclet", JavadocUtil.quotedArgument(this.doclet));
                this.addArgIfNotEmpty(arguments, "-docletpath", JavadocUtil.quotedPathArgument(this.getDocletPath()));
            }
            this.addArgIfNotEmpty(arguments, "-encoding", JavadocUtil.quotedArgument(this.encoding));
            this.addArgIfNotEmpty(arguments, "-extdirs", JavadocUtil.quotedPathArgument(this.extdirs));
            if (this.old && this.isJavaDocVersionAtLeast(1.4f)) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)"Javadoc 1.4+ doesn't support the -1.1 switch anymore. Ignore this option.");
                }
            } else {
                this.addArgIf(arguments, this.old, "-1.1");
            }
            if (this.getOverview() != null && this.getOverview().exists()) {
                this.addArgIfNotEmpty(arguments, "-overview", JavadocUtil.quotedPathArgument(this.getOverview().getAbsolutePath()));
            }
            arguments.add(this.getAccessLevel());
            this.addArgIf(arguments, this.quiet, "-quiet", 1.5f);
            this.addArgIfNotEmpty(arguments, "-source", JavadocUtil.quotedArgument(this.source), 1.4f);
            this.addArgIf(arguments, this.verbose, "-verbose");
            this.addArgIfNotEmpty(arguments, null, this.additionalparam);
            if (StringUtils.isEmpty((String)this.sourcepath) && StringUtils.isNotEmpty((String)this.subpackages)) {
                this.sourcepath = StringUtils.join(sourcePaths.iterator(), (String)File.pathSeparator);
            }
            this.addArgIfNotEmpty(arguments, "-sourcepath", JavadocUtil.quotedPathArgument(this.getSourcePath(sourcePaths)));
            if (StringUtils.isNotEmpty((String)this.sourcepath)) {
                this.addArgIfNotEmpty(arguments, "-subpackages", this.subpackages, 1.4f);
            }
            this.addArgIfNotEmpty(arguments, "-exclude", this.getExcludedPackages(sourcePaths), 1.4f);
            if (StringUtils.isEmpty((String)this.doclet)) {
                int i;
                this.validateStandardDocletOptions();
                this.addArgIf(arguments, this.author, "-author");
                this.addArgIfNotEmpty(arguments, "-bottom", JavadocUtil.quotedArgument(this.getBottomText()), false, false);
                this.addArgIf(arguments, this.breakiterator, "-breakiterator", 1.4f);
                this.addArgIfNotEmpty(arguments, "-charset", JavadocUtil.quotedArgument(this.charset));
                this.addArgIfNotEmpty(arguments, "-d", JavadocUtil.quotedPathArgument(javadocOutputDirectory.toString()));
                this.addArgIf(arguments, this.docfilessubdirs, "-docfilessubdirs", 1.4f);
                this.addArgIfNotEmpty(arguments, "-docencoding", JavadocUtil.quotedArgument(this.docencoding));
                this.addArgIfNotEmpty(arguments, "-doctitle", JavadocUtil.quotedArgument(this.getDoctitle()), false, false);
                if (this.docfilessubdirs) {
                    this.addArgIfNotEmpty(arguments, "-excludedocfilessubdir", JavadocUtil.quotedPathArgument(this.excludedocfilessubdir), 1.4f);
                }
                this.addArgIfNotEmpty(arguments, "-footer", JavadocUtil.quotedArgument(this.footer), false, false);
                if (this.groups != null) {
                    for (i = 0; i < this.groups.length; ++i) {
                        if (this.groups[i] == null || StringUtils.isEmpty((String)this.groups[i].getTitle()) || StringUtils.isEmpty((String)this.groups[i].getPackages())) {
                            if (!this.getLog().isWarnEnabled()) continue;
                            this.getLog().warn((CharSequence)"A group option is empty. Ignore this option.");
                            continue;
                        }
                        String groupTitle = StringUtils.replace((String)this.groups[i].getTitle(), (String)",", (String)"&#44;");
                        this.addArgIfNotEmpty(arguments, "-group", JavadocUtil.quotedArgument(groupTitle) + " " + JavadocUtil.quotedArgument(this.groups[i].getPackages()), true);
                    }
                }
                this.addArgIfNotEmpty(arguments, "-header", JavadocUtil.quotedArgument(this.header), false, false);
                this.addArgIfNotEmpty(arguments, "-helpfile", JavadocUtil.quotedPathArgument(this.helpfile));
                this.addArgIf(arguments, this.keywords, "-keywords", 1.42f);
                if (!this.isOffline) {
                    this.addLinkArguments(arguments);
                }
                this.addLinkofflineArguments(arguments);
                this.addArgIf(arguments, this.nodeprecated, "-nodeprecated");
                this.addArgIf(arguments, this.nodeprecatedlist, "-nodeprecatedlist");
                this.addArgIf(arguments, this.nocomment, "-nocomment", 1.4f);
                this.addArgIf(arguments, this.nohelp, "-nohelp");
                this.addArgIf(arguments, this.noindex, "-noindex");
                this.addArgIf(arguments, this.nonavbar, "-nonavbar");
                this.addArgIf(arguments, this.nooverview, "-nooverview");
                this.addArgIfNotEmpty(arguments, "-noqualifier", JavadocUtil.quotedArgument(this.noqualifier), 1.4f);
                this.addArgIf(arguments, this.nosince, "-nosince");
                this.addArgIf(arguments, this.notimestamp, "-notimestamp", 1.5f);
                this.addArgIf(arguments, this.notree, "-notree");
                this.addArgIfNotEmpty(arguments, "-packagesheader", JavadocUtil.quotedArgument(this.packagesheader), 1.42f);
                if (this.fJavadocVersion >= 1.4f && this.fJavadocVersion < 1.5f) {
                    this.addArgIf(arguments, this.quiet, "-quiet");
                }
                this.addArgIf(arguments, this.serialwarn, "-serialwarn");
                this.addArgIf(arguments, this.linksource, "-linksource", 1.4f);
                if (this.fJavadocVersion == 1.42f) {
                    this.addArgIfNotEmpty(arguments, "-linksourcetab", this.sourcetab);
                } else {
                    this.addArgIfNotEmpty(arguments, "-sourcetab", this.sourcetab, 1.5f);
                }
                this.addArgIf(arguments, this.splitindex, "-splitindex");
                this.addArgIfNotEmpty(arguments, "-stylesheetfile", JavadocUtil.quotedPathArgument(this.getStylesheetFile(javadocOutputDirectory)));
                this.addArgIfNotEmpty(arguments, "-taglet", JavadocUtil.quotedArgument(this.taglet), 1.4f);
                if (this.taglets != null) {
                    for (i = 0; i < this.taglets.length; ++i) {
                        if (this.taglets[i] == null || StringUtils.isEmpty((String)this.taglets[i].getTagletClass())) {
                            if (!this.getLog().isWarnEnabled()) continue;
                            this.getLog().warn((CharSequence)"A taglet option is empty. Ignore this option.");
                            continue;
                        }
                        this.addArgIfNotEmpty(arguments, "-taglet", JavadocUtil.quotedArgument(this.taglets[i].getTagletClass()), 1.4f);
                    }
                }
                this.addArgIfNotEmpty(arguments, "-tagletpath", JavadocUtil.quotedPathArgument(this.getTagletPath()), 1.4f);
                if (this.tags != null) {
                    for (i = 0; i < this.tags.length; ++i) {
                        if (StringUtils.isEmpty((String)this.tags[i].getName())) {
                            if (!this.getLog().isWarnEnabled()) continue;
                            this.getLog().warn((CharSequence)"A tag name is empty. Ignore this option.");
                            continue;
                        }
                        String value = "\"" + this.tags[i].getName();
                        if (StringUtils.isNotEmpty((String)this.tags[i].getPlacement())) {
                            value = value + ":" + this.tags[i].getPlacement();
                            if (StringUtils.isNotEmpty((String)this.tags[i].getHead())) {
                                value = value + ":" + this.tags[i].getHead();
                            }
                        }
                        value = value + "\"";
                        this.addArgIfNotEmpty(arguments, "-tag", value, 1.4f);
                    }
                }
                this.addArgIfNotEmpty(arguments, "-top", JavadocUtil.quotedArgument(this.top), false, false, 1.6f);
                this.addArgIf(arguments, this.use, "-use");
                this.addArgIf(arguments, this.version, "-version");
                this.addArgIfNotEmpty(arguments, "-windowtitle", JavadocUtil.quotedArgument(this.getWindowtitle()), false, false);
            }
            if (options.length() > 0 || arguments.size() > 0) {
                this.addCommandLineOptions(cmd, options, arguments, javadocOutputDirectory);
            }
            if (!packageNames.isEmpty()) {
                this.addCommandLinePackages(cmd, javadocOutputDirectory, packageNames);
                if (!filesWithUnnamedPackages.isEmpty()) {
                    this.addCommandLineArgFile(cmd, javadocOutputDirectory, filesWithUnnamedPackages);
                }
            } else if (!files.isEmpty()) {
                this.addCommandLineArgFile(cmd, javadocOutputDirectory, files);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)Commandline.toString((String[])cmd.getCommandline()).replaceAll("'", ""));
            }
            if (this.debug) {
                File commandLineFile = new File(javadocOutputDirectory, "javadoc." + (SystemUtils.IS_OS_WINDOWS ? "bat" : "sh"));
                try {
                    FileUtils.fileWrite((String)commandLineFile.getAbsolutePath(), (String)Commandline.toString((String[])cmd.getCommandline()).replaceAll("'", ""));
                    if (!SystemUtils.IS_OS_WINDOWS) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
                    }
                }
                catch (IOException e) {
                    if (!this.getLog().isWarnEnabled()) break block65;
                    this.getLog().warn((CharSequence)("Unable to write '" + commandLineFile.getName() + "' debug script file"), (Throwable)e);
                }
            }
        }
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)err);
            if (exitCode != 0) {
                String cmdLine = Commandline.toString((String[])cmd.getCommandline()).replaceAll("'", "");
                cmdLine = JavadocUtil.hideProxyPassword(cmdLine, this.settings);
                StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
                msg.append('\n');
                msg.append("Command line was:" + cmdLine);
                throw new MavenReportException(msg.toString());
            }
        }
        catch (CommandLineException e) {
            throw new MavenReportException("Unable to execute javadoc command: " + e.getMessage(), (Exception)((Object)e));
        }
        if (StringUtils.isNotEmpty((String)err.getOutput()) && this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)"Javadoc Warnings");
            StringTokenizer token = new StringTokenizer(err.getOutput(), "\n");
            while (token.hasMoreTokens()) {
                String current = token.nextToken().trim();
                this.getLog().warn((CharSequence)current);
            }
        }
    }

    protected List getFiles(List sourcePaths) {
        ArrayList files = new ArrayList();
        if (StringUtils.isEmpty((String)this.subpackages)) {
            String[] excludedPackages = this.getExcludedPackages();
            Iterator i = sourcePaths.iterator();
            while (i.hasNext()) {
                File sourceDirectory = new File((String)i.next());
                JavadocUtil.addFilesFromSource(files, sourceDirectory, excludedPackages);
            }
        }
        return files;
    }

    protected List getSourcePaths() {
        List<Object> sourcePaths;
        if (StringUtils.isEmpty((String)this.sourcepath)) {
            File javadocDir;
            sourcePaths = new ArrayList(this.getProjectSourceRoots(this.project));
            if (this.project.getExecutionProject() != null) {
                sourcePaths.addAll(this.getExecutionProjectSourceRoots(this.project));
            }
            if (this.getJavadocDirectory() != null && (javadocDir = this.getJavadocDirectory()).exists() && javadocDir.isDirectory()) {
                sourcePaths.add(this.getJavadocDirectory().getAbsolutePath());
            }
            if (this.aggregate && this.project.isExecutionRoot()) {
                Iterator i = this.reactorProjects.iterator();
                while (i.hasNext()) {
                    MavenProject subProject = (MavenProject)i.next();
                    if (subProject == this.project) continue;
                    List sourceRoots = this.getProjectSourceRoots(subProject);
                    ArtifactHandler artifactHandler = subProject.getArtifact().getArtifactHandler();
                    if ("java".equals(artifactHandler.getLanguage())) {
                        sourcePaths.addAll(sourceRoots);
                    }
                    if (subProject.getExecutionProject() == null) continue;
                    String javadocDirRelative = PathUtils.toRelative((File)this.project.getBasedir(), (String)this.getJavadocDirectory().getAbsolutePath());
                    File javadocDir2 = new File(subProject.getExecutionProject().getBasedir(), javadocDirRelative);
                    if (!javadocDir2.exists() || !javadocDir2.isDirectory()) continue;
                    sourcePaths.add(javadocDir2.getAbsolutePath());
                }
            }
        } else {
            sourcePaths = new ArrayList<String>(Arrays.asList(this.sourcepath.split("[;]")));
            if (this.getJavadocDirectory() != null) {
                sourcePaths.add(this.getJavadocDirectory().getAbsolutePath());
            }
        }
        sourcePaths = JavadocUtil.pruneDirs(sourcePaths);
        return sourcePaths;
    }

    protected boolean canGenerateReport(List files) {
        boolean canGenerate = true;
        if (files.isEmpty() && StringUtils.isEmpty((String)this.subpackages)) {
            canGenerate = false;
        }
        return canGenerate;
    }

    private String getExcludedPackages(List sourcePaths) {
        List excludedNames = null;
        if (StringUtils.isNotEmpty((String)this.sourcepath) && StringUtils.isNotEmpty((String)this.subpackages)) {
            String[] excludedPackages = this.getExcludedPackages();
            String[] subpackagesList = this.subpackages.split("[:]");
            excludedNames = JavadocUtil.getExcludedNames(sourcePaths, subpackagesList, excludedPackages);
        }
        String excludeArg = "";
        if (StringUtils.isNotEmpty((String)this.subpackages) && excludedNames != null) {
            Iterator it = excludedNames.iterator();
            while (it.hasNext()) {
                String str = (String)it.next();
                excludeArg = excludeArg + str;
                if (!it.hasNext()) continue;
                excludeArg = excludeArg + ":";
            }
        }
        return excludeArg;
    }

    private String getSourcePath(List sourcePaths) {
        String sourcePath = null;
        if (StringUtils.isEmpty((String)this.subpackages) || StringUtils.isNotEmpty((String)this.sourcepath)) {
            sourcePath = StringUtils.join(sourcePaths.iterator(), (String)File.pathSeparator);
        }
        return sourcePath;
    }

    private String[] getExcludedPackages() {
        String[] excludePackages = new String[]{};
        if (this.excludePackageNames != null) {
            excludePackages = this.excludePackageNames.split("[ ,:;]");
        }
        for (int i = 0; i < excludePackages.length; ++i) {
            excludePackages[i] = excludePackages[i].replace('.', File.separatorChar);
        }
        return excludePackages;
    }

    private String getClasspath() throws MavenReportException {
        ArrayList<File> classpathElements = new ArrayList<File>();
        HashMap compileArtifactMap = new HashMap();
        classpathElements.addAll(this.getProjectBuildOutputDirs(this.project));
        this.populateCompileArtifactMap(compileArtifactMap, this.getProjectArtifacts(this.project));
        if (this.aggregate && this.project.isExecutionRoot()) {
            try {
                Iterator i = this.reactorProjects.iterator();
                while (i.hasNext()) {
                    MavenProject subProject = (MavenProject)i.next();
                    if (subProject == this.project) continue;
                    classpathElements.addAll(this.getProjectBuildOutputDirs(subProject));
                    Set dependencyArtifacts = subProject.createArtifacts(this.factory, null, null);
                    if (dependencyArtifacts.isEmpty()) continue;
                    ArtifactResolutionResult result = null;
                    try {
                        result = this.resolver.resolveTransitively(dependencyArtifacts, subProject.getArtifact(), subProject.getRemoteArtifactRepositories(), this.localRepository, this.artifactMetadataSource);
                    }
                    catch (MultipleArtifactsNotFoundException e) {
                        if (this.checkMissingArtifactsInReactor(dependencyArtifacts, e.getMissingArtifacts())) {
                            this.getLog().warn((CharSequence)"IGNORED to add some artifacts in the classpath. See above.");
                        }
                        throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
                    }
                    catch (ArtifactNotFoundException e) {
                        throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
                    }
                    catch (ArtifactResolutionException e) {
                        throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
                    }
                    if (result == null) continue;
                    this.populateCompileArtifactMap(compileArtifactMap, JavadocUtil.getCompileArtifacts(result.getArtifacts()));
                    if (!this.getLog().isDebugEnabled()) continue;
                    StringBuffer sb = new StringBuffer();
                    sb.append("Compiled artifacts for ");
                    sb.append(subProject.getGroupId()).append(":");
                    sb.append(subProject.getArtifactId()).append(":");
                    sb.append(subProject.getVersion()).append('\n');
                    Iterator it = compileArtifactMap.keySet().iterator();
                    while (it.hasNext()) {
                        String key = it.next().toString();
                        Artifact a = (Artifact)compileArtifactMap.get(key);
                        sb.append(a.getFile()).append('\n');
                    }
                    this.getLog().debug((CharSequence)sb.toString());
                }
            }
            catch (InvalidDependencyVersionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
        }
        Iterator it = compileArtifactMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Artifact a = (Artifact)compileArtifactMap.get(key);
            classpathElements.add(a.getFile());
        }
        return StringUtils.join(classpathElements.iterator(), (String)File.pathSeparator);
    }

    private void populateCompileArtifactMap(Map compileArtifactMap, List artifactList) throws MavenReportException {
        if (artifactList != null) {
            Iterator i = artifactList.iterator();
            while (i.hasNext()) {
                Artifact newArtifact = (Artifact)i.next();
                File file = newArtifact.getFile();
                if (file == null) {
                    throw new MavenReportException("Error in plugin descriptor - dependency was not resolved for artifact: " + newArtifact.getGroupId() + ":" + newArtifact.getArtifactId() + ":" + newArtifact.getVersion());
                }
                if (compileArtifactMap.get(newArtifact.getDependencyConflictId()) != null) {
                    Artifact oldArtifact = (Artifact)compileArtifactMap.get(newArtifact.getDependencyConflictId());
                    DefaultArtifactVersion oldVersion = new DefaultArtifactVersion(oldArtifact.getVersion());
                    DefaultArtifactVersion newVersion = new DefaultArtifactVersion(newArtifact.getVersion());
                    if (newVersion.compareTo((Object)oldVersion) <= 0) continue;
                    compileArtifactMap.put(newArtifact.getDependencyConflictId(), newArtifact);
                    continue;
                }
                compileArtifactMap.put(newArtifact.getDependencyConflictId(), newArtifact);
            }
        }
    }

    private String getBottomText() {
        int actualYear = Calendar.getInstance().get(1);
        String year = String.valueOf(actualYear);
        String inceptionYear = this.project.getInceptionYear();
        String theBottom = StringUtils.replace((String)this.bottom, (String)"{currentYear}", (String)year);
        theBottom = inceptionYear != null ? (inceptionYear.equals(year) ? StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"") : StringUtils.replace((String)theBottom, (String)"{inceptionYear}", (String)inceptionYear)) : StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"");
        theBottom = this.project.getOrganization() == null ? StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)"") : (StringUtils.isNotEmpty((String)this.project.getOrganization().getName()) ? (StringUtils.isNotEmpty((String)this.project.getOrganization().getUrl()) ? StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)("<a href=\"" + this.project.getOrganization().getUrl() + "\">" + this.project.getOrganization().getName() + "</a>")) : StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)this.project.getOrganization().getName())) : StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)""));
        return theBottom;
    }

    private String getStylesheetFile(File javadocOutputDirectory) {
        String stylesheetfile = this.stylesheetfile;
        if (StringUtils.isEmpty((String)stylesheetfile) && "maven".equals(this.stylesheet)) {
            stylesheetfile = javadocOutputDirectory + File.separator + DEFAULT_CSS_NAME;
        }
        return stylesheetfile;
    }

    private String getAccessLevel() {
        String accessLevel;
        if ("public".equalsIgnoreCase(this.show) || "protected".equalsIgnoreCase(this.show) || "package".equalsIgnoreCase(this.show) || "private".equalsIgnoreCase(this.show)) {
            accessLevel = "-" + this.show;
        } else {
            if (this.getLog().isErrorEnabled()) {
                this.getLog().error((CharSequence)("Unrecognized access level to show '" + this.show + "'. Defaulting to protected."));
            }
            accessLevel = "-protected";
        }
        return accessLevel;
    }

    private String getDocletPath() throws MavenReportException {
        StringBuffer path = new StringBuffer();
        if (!this.isDocletArtifactEmpty(this.docletArtifact)) {
            path.append(this.getArtifactAbsolutePath(this.docletArtifact));
        } else if (this.docletArtifacts != null) {
            for (int i = 0; i < this.docletArtifacts.length; ++i) {
                if (this.isDocletArtifactEmpty(this.docletArtifacts[i])) continue;
                path.append(this.getArtifactAbsolutePath(this.docletArtifacts[i]));
                if (i >= this.docletArtifacts.length - 1) continue;
                path.append(File.pathSeparator);
            }
        }
        if (!StringUtils.isEmpty((String)this.docletPath)) {
            path.append(this.docletPath);
        }
        if (StringUtils.isEmpty((String)path.toString()) && this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)"No docletpath option was found. Please review <docletpath/> or <docletArtifact/> or <doclets/>.");
        }
        return path.toString();
    }

    private boolean isDocletArtifactEmpty(DocletArtifact aDocletArtifact) {
        if (aDocletArtifact == null) {
            return true;
        }
        return StringUtils.isEmpty((String)aDocletArtifact.getGroupId()) && StringUtils.isEmpty((String)aDocletArtifact.getArtifactId()) && StringUtils.isEmpty((String)aDocletArtifact.getVersion());
    }

    private String getTagletPath() throws MavenReportException {
        StringBuffer path = new StringBuffer();
        if (this.tagletArtifact != null && StringUtils.isNotEmpty((String)this.tagletArtifact.getGroupId()) && StringUtils.isNotEmpty((String)this.tagletArtifact.getArtifactId()) && StringUtils.isNotEmpty((String)this.tagletArtifact.getVersion())) {
            path.append(this.getArtifactAbsolutePath(this.tagletArtifact));
        } else if (this.taglets != null) {
            List<String> tagletsPath = new ArrayList();
            for (int i = 0; i < this.taglets.length; ++i) {
                Taglet current = this.taglets[i];
                if (current == null) continue;
                if (current.getTagletArtifact() != null) {
                    tagletsPath.add(this.getArtifactAbsolutePath(current.getTagletArtifact()));
                    continue;
                }
                if (current.getTagletArtifact() != null && StringUtils.isNotEmpty((String)current.getTagletArtifact().getGroupId()) && StringUtils.isNotEmpty((String)current.getTagletArtifact().getArtifactId()) && StringUtils.isNotEmpty((String)current.getTagletArtifact().getVersion())) {
                    tagletsPath.add(this.getArtifactAbsolutePath(current.getTagletArtifact()));
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)current.getTagletpath())) continue;
                tagletsPath.add(current.getTagletpath());
            }
            tagletsPath = JavadocUtil.pruneFiles(tagletsPath);
            path.append(StringUtils.join(tagletsPath.iterator(), (String)File.pathSeparator));
        } else {
            path.append(this.tagletpath);
        }
        return path.toString();
    }

    private String getArtifactAbsolutePath(JavadocPathArtifact javadocArtifact) throws MavenReportException {
        if (StringUtils.isEmpty((String)javadocArtifact.getGroupId()) && StringUtils.isEmpty((String)javadocArtifact.getArtifactId()) && StringUtils.isEmpty((String)javadocArtifact.getVersion())) {
            return "";
        }
        Artifact artifact = this.factory.createArtifact(javadocArtifact.getGroupId(), javadocArtifact.getArtifactId(), javadocArtifact.getVersion(), "compile", "jar");
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            return artifact.getFile().getAbsolutePath();
        }
        catch (ArtifactResolutionException e) {
            throw new MavenReportException("Unable to resolve artifact:" + javadocArtifact, (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MavenReportException("Unable to find artifact:" + javadocArtifact, (Exception)((Object)e));
        }
    }

    private void addMemoryArg(Commandline cmd, String arg, String memory) {
        block3: {
            if (StringUtils.isNotEmpty((String)memory)) {
                try {
                    cmd.createArgument().setValue("-J" + arg + JavadocUtil.parseJavadocMemory(memory));
                }
                catch (IllegalArgumentException e) {
                    if (!this.getLog().isErrorEnabled()) break block3;
                    this.getLog().error((CharSequence)("Malformed memory pattern for '" + arg + memory + "'. Ignore this option."));
                }
            }
        }
    }

    private void addProxyArg(Commandline cmd) {
        if (StringUtils.isNotEmpty((String)this.proxyHost)) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)"The Javadoc plugin parameter 'proxyHost' is deprecated since 2.4. Please configure an active proxy in your settings.xml.");
            }
            cmd.createArgument().setValue("-J-DproxyHost=" + this.proxyHost);
            if (this.proxyPort > 0) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)"The Javadoc plugin parameter 'proxyPort' is deprecated since 2.4. Please configure an active proxy in your settings.xml.");
                }
                cmd.createArgument().setValue("-J-DproxyPort=" + this.proxyPort);
            }
        }
        if (this.settings == null) {
            return;
        }
        Proxy activeProxy = this.settings.getActiveProxy();
        if (activeProxy != null) {
            String protocol;
            String string = protocol = StringUtils.isNotEmpty((String)activeProxy.getProtocol()) ? activeProxy.getProtocol() + "." : "";
            if (StringUtils.isNotEmpty((String)activeProxy.getHost())) {
                cmd.createArgument().setValue("-J-D" + protocol + "proxySet=true");
                cmd.createArgument().setValue("-J-D" + protocol + "proxyHost=" + activeProxy.getHost());
                if (activeProxy.getPort() > 0) {
                    cmd.createArgument().setValue("-J-D" + protocol + "proxyPort=" + activeProxy.getPort());
                }
                if (StringUtils.isNotEmpty((String)activeProxy.getNonProxyHosts())) {
                    cmd.createArgument().setValue("-J-D" + protocol + "nonProxyHosts=\"" + activeProxy.getNonProxyHosts() + "\"");
                }
                if (StringUtils.isNotEmpty((String)activeProxy.getUsername())) {
                    cmd.createArgument().setValue("-J-Dhttp.proxyUser=\"" + activeProxy.getUsername() + "\"");
                    if (StringUtils.isNotEmpty((String)activeProxy.getPassword())) {
                        cmd.createArgument().setValue("-J-Dhttp.proxyPassword=\"" + activeProxy.getPassword() + "\"");
                    }
                }
            }
        }
    }

    private String getJavadocExecutable() throws IOException {
        String javadocCommand = "javadoc" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (StringUtils.isNotEmpty((String)this.javadocExecutable)) {
            File javadocExe = new File(this.javadocExecutable);
            if (!javadocExe.exists() || !javadocExe.isFile()) {
                throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. " + "Verify the <javadocExecutable/> parameter.");
            }
            return javadocExe.getAbsolutePath();
        }
        File javadocExe = SystemUtils.IS_OS_AIX ? new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "sh", javadocCommand) : (SystemUtils.IS_OS_MAC_OSX ? new File(SystemUtils.getJavaHome() + File.separator + "bin", javadocCommand) : new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "bin", javadocCommand));
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            String javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).exists() || !new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is " + "not a valid directory.");
            }
            javadocExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javadocCommand);
        }
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. " + "Verify the JAVA_HOME environment variable.");
        }
        return javadocExe.getAbsolutePath();
    }

    private boolean isJavaDocVersionAtLeast(float requiredVersion) {
        return this.fJavadocVersion >= requiredVersion;
    }

    private void addArgIf(List arguments, boolean b, String value) {
        if (b) {
            arguments.add(value);
        }
    }

    private void addArgIf(List arguments, boolean b, String value, float requiredJavaVersion) {
        if (this.isJavaDocVersionAtLeast(requiredJavaVersion)) {
            this.addArgIf(arguments, b, value);
        } else if (this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)(value + " option is not supported on Java version < " + requiredJavaVersion + ". Ignore this option."));
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value) {
        this.addArgIfNotEmpty(arguments, key, value, false);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, boolean repeatKey, boolean splitValue, float requiredJavaVersion) {
        if (this.isJavaDocVersionAtLeast(requiredJavaVersion)) {
            this.addArgIfNotEmpty(arguments, key, value, repeatKey, splitValue);
        } else if (this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)(key + " option is not supported on Java version < " + requiredJavaVersion + ". Ignore this option."));
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, boolean repeatKey, boolean splitValue) {
        if (StringUtils.isNotEmpty((String)value)) {
            if (StringUtils.isNotEmpty((String)key)) {
                arguments.add(key);
            }
            if (splitValue) {
                StringTokenizer token = new StringTokenizer(value, ",");
                while (token.hasMoreTokens()) {
                    String current = token.nextToken().trim();
                    if (!StringUtils.isNotEmpty((String)current)) continue;
                    arguments.add(current);
                    if (!token.hasMoreTokens() || !repeatKey) continue;
                    arguments.add(key);
                }
            } else {
                arguments.add(value);
            }
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, boolean repeatKey) {
        this.addArgIfNotEmpty(arguments, key, value, repeatKey, true);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, float requiredJavaVersion) {
        this.addArgIfNotEmpty(arguments, key, value, requiredJavaVersion, false);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, float requiredJavaVersion, boolean repeatKey) {
        if (this.isJavaDocVersionAtLeast(requiredJavaVersion)) {
            this.addArgIfNotEmpty(arguments, key, value, repeatKey);
        } else if (this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)(key + " option is not supported on Java version < " + requiredJavaVersion));
        }
    }

    private void addLinkofflineArguments(List arguments) {
        ArrayList<OfflineLink> offlineLinksList;
        ArrayList<OfflineLink> arrayList = offlineLinksList = this.offlineLinks != null ? new ArrayList<OfflineLink>(Arrays.asList(this.offlineLinks)) : new ArrayList();
        if (!this.aggregate && this.reactorProjects != null) {
            MavenProject p;
            String javadocDirRelative = PathUtils.toRelative((File)this.project.getBasedir(), (String)this.getOutputDirectory());
            Iterator it = this.reactorProjects.iterator();
            while (it.hasNext() && !(p = (MavenProject)it.next()).getId().equals(this.project.getId())) {
                if (p.getUrl() == null) continue;
                String url = p.getUrl() + "/apidocs";
                File location = new File(p.getBasedir(), javadocDirRelative);
                if (!location.exists()) continue;
                OfflineLink ol = new OfflineLink();
                ol.setUrl(url);
                ol.setLocation(location.getAbsolutePath());
                offlineLinksList.add(ol);
            }
        }
        if (offlineLinksList != null) {
            for (int i = 0; i < offlineLinksList.size(); ++i) {
                OfflineLink offlineLink = (OfflineLink)offlineLinksList.get(i);
                this.addArgIfNotEmpty(arguments, "-linkoffline", JavadocUtil.quotedPathArgument(offlineLink.getUrl()) + " " + JavadocUtil.quotedPathArgument(offlineLink.getLocation()), true);
            }
        }
    }

    private void addLinkArguments(List arguments) {
        if (this.links != null) {
            for (int i = 0; i < this.links.size(); ++i) {
                String link = (String)this.links.get(i);
                if (StringUtils.isEmpty((String)link)) continue;
                if (link.endsWith("/")) {
                    link = link.substring(0, link.length() - 1);
                }
                try {
                    URL linkUrl = new URL(link + "/package-list");
                    JavadocUtil.fetchURL(this.settings, linkUrl);
                    this.addArgIfNotEmpty(arguments, "-link", JavadocUtil.quotedPathArgument(link), true);
                    continue;
                }
                catch (MalformedURLException e) {
                    if (!this.getLog().isErrorEnabled()) continue;
                    this.getLog().error((CharSequence)("Malformed link: " + link + "/package-list. Ignored it."));
                    continue;
                }
                catch (IOException e) {
                    if (!this.getLog().isErrorEnabled()) continue;
                    this.getLog().error((CharSequence)("Error fetching link: " + link + "/package-list. Ignored it."));
                }
            }
        }
    }

    private InputStream getStream(String resource) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
    }

    private void copyDefaultStylesheet(File outputDirectory) throws IOException {
        if (outputDirectory == null || !outputDirectory.exists()) {
            throw new IOException("The outputDirectory " + outputDirectory + " doesn't exists.");
        }
        InputStream is = this.getStream(RESOURCE_CSS_DIR + "/" + DEFAULT_CSS_NAME);
        if (is == null) {
            throw new IOException("The resource stylesheet.css doesn't exists.");
        }
        File outputFile = new File(outputDirectory, DEFAULT_CSS_NAME);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        FileOutputStream w = new FileOutputStream(outputFile);
        IOUtil.copy((InputStream)is, (OutputStream)w);
        IOUtil.close((InputStream)is);
        IOUtil.close((OutputStream)w);
    }

    private void copyJavadocResources(File outputDirectory) throws IOException {
        if (outputDirectory == null || !outputDirectory.exists()) {
            throw new IOException("The outputDirectory " + outputDirectory + " doesn't exists.");
        }
        if (this.getJavadocDirectory() != null) {
            JavadocUtil.copyJavadocResources(outputDirectory, this.getJavadocDirectory());
        }
        if (this.aggregate && this.project.isExecutionRoot()) {
            Iterator i = this.reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject subProject = (MavenProject)i.next();
                if (subProject == this.project) continue;
                String javadocDirRelative = PathUtils.toRelative((File)this.project.getBasedir(), (String)this.getJavadocDirectory().getAbsolutePath());
                File javadocDir = new File(subProject.getBasedir(), javadocDirRelative);
                JavadocUtil.copyJavadocResources(outputDirectory, javadocDir);
            }
        }
    }

    private List getPackageNames(List sourcePaths, List files) {
        return this.getPackageNamesOrFilesWithUnnamedPackages(sourcePaths, files, true);
    }

    private List getFilesWithUnnamedPackages(List sourcePaths, List files) {
        return this.getPackageNamesOrFilesWithUnnamedPackages(sourcePaths, files, false);
    }

    private List getPackageNamesOrFilesWithUnnamedPackages(List sourcePaths, List files, boolean onlyPackageName) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.sourcepath)) {
            return returnList;
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String currentFile = (String)it.next();
            currentFile = currentFile.replace('\\', '/');
            Iterator it2 = sourcePaths.iterator();
            while (it2.hasNext()) {
                String currentSourcePath = (String)it2.next();
                if (!(currentSourcePath = currentSourcePath.replace('\\', '/')).endsWith("/")) {
                    currentSourcePath = currentSourcePath + "/";
                }
                if (currentFile.indexOf(currentSourcePath) == -1) continue;
                String packagename = currentFile.substring(currentSourcePath.length() + 1);
                if (onlyPackageName && packagename.lastIndexOf("/") != -1) {
                    packagename = packagename.substring(0, packagename.lastIndexOf("/"));
                    if (!returnList.contains(packagename = packagename.replace('/', '.'))) {
                        returnList.add(packagename);
                    }
                }
                if (onlyPackageName || packagename.lastIndexOf("/") != -1) continue;
                returnList.add(currentFile);
            }
        }
        return returnList;
    }

    private void addCommandLineOptions(Commandline cmd, StringBuffer options, List arguments, File javadocOutputDirectory) throws MavenReportException {
        File optionsFile = new File(javadocOutputDirectory, "options");
        options.append(" ");
        options.append(StringUtils.join((Object[])arguments.toArray(new String[0]), (String)SystemUtils.LINE_SEPARATOR));
        try {
            FileUtils.fileWrite((String)optionsFile.getAbsolutePath(), (String)options.toString());
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + optionsFile.getName() + "' temporary file for command execution", (Exception)e);
        }
        cmd.createArgument().setValue("@options");
        if (!this.debug) {
            optionsFile.deleteOnExit();
        }
    }

    private void addCommandLineArgFile(Commandline cmd, File javadocOutputDirectory, List files) throws MavenReportException {
        File argfileFile = this.isJavaDocVersionAtLeast(1.4f) ? new File(javadocOutputDirectory, "argfile") : new File(javadocOutputDirectory, "files");
        try {
            FileUtils.fileWrite((String)argfileFile.getAbsolutePath(), (String)StringUtils.join(files.iterator(), (String)SystemUtils.LINE_SEPARATOR));
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + argfileFile.getName() + "' temporary file for command execution", (Exception)e);
        }
        if (this.isJavaDocVersionAtLeast(1.4f)) {
            cmd.createArgument().setValue("@argfile");
        } else {
            cmd.createArgument().setValue("@files");
        }
        if (!this.debug) {
            argfileFile.deleteOnExit();
        }
    }

    private void addCommandLinePackages(Commandline cmd, File javadocOutputDirectory, List packageNames) throws MavenReportException {
        File packagesFile = new File(javadocOutputDirectory, "packages");
        try {
            FileUtils.fileWrite((String)packagesFile.getAbsolutePath(), (String)StringUtils.join((Object[])packageNames.toArray(new String[0]), (String)SystemUtils.LINE_SEPARATOR));
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + packagesFile.getName() + "' temporary file for command execution", (Exception)e);
        }
        cmd.createArgument().setValue("@packages");
        if (!this.debug) {
            packagesFile.deleteOnExit();
        }
    }

    private void validateJavadocOptions() throws MavenReportException {
        if (StringUtils.isNotEmpty((String)this.encoding) && !JavadocUtil.validateEncoding(this.encoding)) {
            throw new MavenReportException("Encoding not supported: " + this.encoding);
        }
    }

    private void validateStandardDocletOptions() throws MavenReportException {
        if (StringUtils.isNotEmpty((String)this.docencoding) && !JavadocUtil.validateEncoding(this.docencoding)) {
            throw new MavenReportException("Encoding not supported: " + this.docencoding);
        }
        if (StringUtils.isNotEmpty((String)this.helpfile) && this.nohelp) {
            throw new MavenReportException("Option <nohelp/> conflicts with <helpfile/>");
        }
        if (StringUtils.isNotEmpty((String)this.helpfile) && !new File(this.helpfile).exists()) {
            throw new MavenReportException("File not found: " + this.helpfile);
        }
        if (this.getOverview() != null && this.nooverview) {
            throw new MavenReportException("Option <nooverview/> conflicts with <overview/>");
        }
        if (this.splitindex && this.noindex) {
            throw new MavenReportException("Option <noindex/> conflicts with <splitindex/>");
        }
    }

    private boolean checkMissingArtifactsInReactor(Collection dependencyArtifacts, Collection missing) {
        HashSet<MavenProject> foundInReactor = new HashSet<MavenProject>();
        Iterator iter = missing.iterator();
        block0: while (iter.hasNext()) {
            Artifact mArtifact = (Artifact)iter.next();
            Iterator pIter = this.reactorProjects.iterator();
            while (pIter.hasNext()) {
                MavenProject p = (MavenProject)pIter.next();
                if (!p.getArtifactId().equals(mArtifact.getArtifactId()) || !p.getGroupId().equals(mArtifact.getGroupId()) || !p.getVersion().equals(mArtifact.getVersion())) continue;
                this.getLog().warn((CharSequence)("The dependency: [" + p.getId() + "} can't be resolved but has been found in the reactor (probably snapshots).\n" + "This dependency has been excluded from the Javadoc classpath. " + "You should rerun javadoc after executing mvn install."));
                foundInReactor.add(p);
                continue block0;
            }
        }
        return foundInReactor.size() == missing.size();
    }
}

