/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableCellContainer;
import org.apache.fop.fo.properties.BreakPropertySet;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class TableRow
extends TableCellContainer
implements BreakPropertySet {
    private LengthRangeProperty blockProgressionDimension;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private int breakAfter;
    private int breakBefore;
    private Length height;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;

    public TableRow(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.breakAfter = pList.get(58).getEnum();
        this.breakBefore = pList.get(59).getEnum();
        this.height = pList.get(106).getLength();
        this.keepTogether = pList.get(118).getKeep();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        super.bind(pList);
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList pList) throws FOPException {
        if (!this.inMarker()) {
            TableBody body = (TableBody)this.parent;
            this.pendingSpans = body.pendingSpans;
            this.columnNumberManager = body.columnNumberManager;
        }
        super.processNode(elementName, locator, attlist, pList);
    }

    protected void addChildNode(FONode child) throws FOPException {
        if (!this.inMarker()) {
            TableCell cell = (TableCell)child;
            TableBody body = (TableBody)this.getParent();
            this.addTableCellChild(cell, body.isFirst(this));
        }
        super.addChildNode(child);
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startRow(this);
    }

    public void endOfNode() throws FOPException {
        if (this.firstChild == null) {
            this.missingChildElementError("(table-cell+)");
        }
        if (!this.inMarker()) {
            this.pendingSpans = null;
            this.columnNumberManager = null;
        }
        this.getFOEventHandler().endRow(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (!"http://www.w3.org/1999/XSL/Format".equals(nsURI) || !localName.equals("table-cell")) {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    TableBody getTablePart() {
        return (TableBody)this.parent;
    }

    boolean isTableRow() {
        return true;
    }

    protected void setCollapsedBorders() {
        TableBody body = (TableBody)this.parent;
        this.createBorder(2, body);
        this.createBorder(3, body);
        this.createBorder(0);
        this.createBorder(1);
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public boolean mustKeepTogether() {
        return !this.getKeepTogether().getWithinPage().isAuto() || !this.getKeepTogether().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.getKeepWithNext().getWithinPage().isAuto() || !this.getKeepWithNext().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithPrevious() {
        return !this.getKeepWithPrevious().getWithinPage().isAuto() || !this.getKeepWithPrevious().getWithinColumn().isAuto();
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public Length getHeight() {
        return this.height;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public String getLocalName() {
        return "table-row";
    }

    public int getNameId() {
        return 54;
    }
}

