/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Criteria;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionException;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.StatefulPersistenceContext;
import org.hibernate.engine.Versioning;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.event.EventListeners;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.impl.AbstractSessionImpl;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.jdbc.Batcher;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;

public class StatelessSessionImpl
extends AbstractSessionImpl
implements JDBCContext.Context,
StatelessSession {
    private JDBCContext jdbcContext;
    private PersistenceContext temporaryPersistenceContext = new StatefulPersistenceContext(this);

    StatelessSessionImpl(Connection connection, SessionFactoryImpl factory) {
        super(factory);
        this.jdbcContext = new JDBCContext(this, connection, EmptyInterceptor.INSTANCE);
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    public void close() {
        this.managedClose();
    }

    public void delete(Object entity) {
        this.errorIfClosed();
        this.delete(null, entity);
    }

    public Serializable insert(Object entity) {
        this.errorIfClosed();
        return this.insert(null, entity);
    }

    public void update(Object entity) {
        this.errorIfClosed();
        this.update(null, entity);
    }

    public Serializable insert(String entityName, Object entity) {
        boolean substitute;
        this.errorIfClosed();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifierGenerator().generate(this, entity);
        Object[] state = persister.getPropertyValues(entity, EntityMode.POJO);
        if (persister.isVersioned() && (substitute = Versioning.seedVersion(state, persister.getVersionProperty(), persister.getVersionType(), this))) {
            persister.setPropertyValues(entity, state, EntityMode.POJO);
        }
        if (id == IdentifierGeneratorFactory.POST_INSERT_INDICATOR) {
            id = persister.insert(state, entity, this);
        } else {
            persister.insert(id, state, entity, this);
        }
        persister.setIdentifier(entity, id, EntityMode.POJO);
        return id;
    }

    public void update(String entityName, Object entity) {
        Object oldVersion;
        this.errorIfClosed();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifier(entity, EntityMode.POJO);
        Object[] state = persister.getPropertyValues(entity, EntityMode.POJO);
        if (persister.isVersioned()) {
            oldVersion = persister.getVersion(entity, EntityMode.POJO);
            Object newVersion = Versioning.increment(oldVersion, persister.getVersionType(), this);
            Versioning.setVersion(state, newVersion, persister);
            persister.setPropertyValues(entity, state, EntityMode.POJO);
        } else {
            oldVersion = null;
        }
        persister.update(id, state, null, false, null, oldVersion, entity, null, this);
    }

    public void delete(String entityName, Object entity) {
        this.errorIfClosed();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifier(entity, EntityMode.POJO);
        Object version = persister.getVersion(entity, EntityMode.POJO);
        persister.delete(id, version, entity, this);
    }

    public ConnectionReleaseMode getConnectionReleaseMode() {
        return this.factory.getSettings().getConnectionReleaseMode();
    }

    public boolean isAutoCloseSessionEnabled() {
        return this.factory.getSettings().isAutoCloseSessionEnabled();
    }

    public boolean isFlushBeforeCompletionEnabled() {
        return true;
    }

    public boolean isFlushModeNever() {
        return false;
    }

    public void managedClose() {
        if (!this.isOpen()) {
            throw new SessionException("Session was already closed!");
        }
        this.jdbcContext.getConnectionManager().close();
        this.setClosed();
    }

    public void managedFlush() {
        this.errorIfClosed();
        this.getBatcher().executeBatch();
    }

    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && this.isOpen();
    }

    public void afterTransactionCompletion(boolean successful, Transaction tx) {
    }

    public void beforeTransactionCompletion(Transaction tx) {
    }

    public String bestGuessEntityName(Object object) {
        if (object instanceof HibernateProxy) {
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        return this.guessEntityName(object);
    }

    public Connection connection() {
        this.errorIfClosed();
        return this.jdbcContext.borrowConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        boolean success = false;
        int result = 0;
        try {
            result = plan.performExecuteUpdate(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return result;
    }

    public Batcher getBatcher() {
        this.errorIfClosed();
        return this.jdbcContext.getConnectionManager().getBatcher();
    }

    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }

    public int getDontFlushFromFind() {
        return 0;
    }

    public Map getEnabledFilters() {
        return CollectionHelper.EMPTY_MAP;
    }

    public Serializable getContextEntityIdentifier(Object object) {
        this.errorIfClosed();
        return null;
    }

    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    public EntityPersister getEntityPersister(String entityName, Object object) throws HibernateException {
        this.errorIfClosed();
        if (entityName == null) {
            return this.factory.getEntityPersister(this.guessEntityName(object));
        }
        return this.factory.getEntityPersister(entityName).getSubclassEntityPersister(object, this.getFactory(), EntityMode.POJO);
    }

    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        this.errorIfClosed();
        return null;
    }

    public Type getFilterParameterType(String filterParameterName) {
        throw new UnsupportedOperationException();
    }

    public Object getFilterParameterValue(String filterParameterName) {
        throw new UnsupportedOperationException();
    }

    public FlushMode getFlushMode() {
        return FlushMode.COMMIT;
    }

    public Interceptor getInterceptor() {
        return EmptyInterceptor.INSTANCE;
    }

    public EventListeners getListeners() {
        throw new UnsupportedOperationException();
    }

    public PersistenceContext getPersistenceContext() {
        return this.temporaryPersistenceContext;
    }

    public long getTimestamp() {
        throw new UnsupportedOperationException();
    }

    public Object get(Class entityClass, Serializable id) {
        return this.get(entityClass.getName(), id);
    }

    public Object get(Class entityClass, Serializable id, LockMode lockMode) {
        return this.get(entityClass.getName(), id, lockMode);
    }

    public Object get(String entityName, Serializable id) {
        return this.get(entityName, id, LockMode.NONE);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) {
        this.errorIfClosed();
        Object result = this.getFactory().getEntityPersister(entityName).load(id, null, lockMode, this);
        this.temporaryPersistenceContext.clear();
        return result;
    }

    public String guessEntityName(Object entity) throws HibernateException {
        this.errorIfClosed();
        return entity.getClass().getName();
    }

    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        throw new SessionException("proxies cannot be fetched by a stateless session");
    }

    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        throw new SessionException("collections cannot be fetched by a stateless session");
    }

    public Object instantiate(String entityName, Serializable id) throws HibernateException {
        this.errorIfClosed();
        return this.getFactory().getEntityPersister(entityName).instantiate(id, EntityMode.POJO);
    }

    public Object internalLoad(String entityName, Serializable id, boolean eager, boolean nullable) throws HibernateException {
        this.errorIfClosed();
        EntityPersister persister = this.getFactory().getEntityPersister(entityName);
        if (!eager && persister.hasProxy()) {
            return persister.createProxy(id, this);
        }
        Object loaded = this.temporaryPersistenceContext.getEntity(new EntityKey(id, persister, EntityMode.POJO));
        return loaded == null ? this.get(entityName, id) : loaded;
    }

    public boolean isConnected() {
        return this.jdbcContext.getConnectionManager().isCurrentlyConnected();
    }

    public boolean isTransactionInProgress() {
        return this.jdbcContext.isTransactionInProgress();
    }

    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public List listFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public void setAutoClear(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    public void setCacheMode(CacheMode cm) {
        throw new UnsupportedOperationException();
    }

    public void setFlushMode(FlushMode fm) {
        throw new UnsupportedOperationException();
    }

    public Transaction getTransaction() throws HibernateException {
        this.errorIfClosed();
        return this.jdbcContext.getTransaction();
    }

    public Transaction beginTransaction() throws HibernateException {
        this.errorIfClosed();
        Transaction result = this.getTransaction();
        result.begin();
        return result;
    }

    public boolean isEventSource() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        boolean success = false;
        List results = CollectionHelper.EMPTY_LIST;
        try {
            results = plan.performList(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    public void afterOperation(boolean success) {
        if (!this.jdbcContext.isTransactionInProgress()) {
            this.jdbcContext.afterNontransactionalQuery(success);
        }
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        this.errorIfClosed();
        return new CriteriaImpl(persistentClass.getName(), alias, this);
    }

    public Criteria createCriteria(String entityName, String alias) {
        this.errorIfClosed();
        return new CriteriaImpl(entityName, alias, this);
    }

    public Criteria createCriteria(Class persistentClass) {
        this.errorIfClosed();
        return new CriteriaImpl(persistentClass.getName(), this);
    }

    public Criteria createCriteria(String entityName) {
        this.errorIfClosed();
        return new CriteriaImpl(entityName, this);
    }

    public ScrollableResults scroll(CriteriaImpl criteria, ScrollMode scrollMode) {
        this.errorIfClosed();
        String entityName = criteria.getEntityOrClassName();
        CriteriaLoader loader = new CriteriaLoader(this.getOuterJoinLoadable(entityName), this.factory, criteria, entityName, this.getEnabledFilters());
        return loader.scroll(this, scrollMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(CriteriaImpl criteria) throws HibernateException {
        this.errorIfClosed();
        String[] implementors = this.factory.getImplementors(criteria.getEntityOrClassName());
        int size = implementors.length;
        CriteriaLoader[] loaders = new CriteriaLoader[size];
        HashSet spaces = new HashSet();
        for (int i = 0; i < size; ++i) {
            loaders[i] = new CriteriaLoader(this.getOuterJoinLoadable(implementors[i]), this.factory, criteria, implementors[i], this.getEnabledFilters());
            spaces.addAll(loaders[i].getQuerySpaces());
        }
        List results = Collections.EMPTY_LIST;
        boolean success = false;
        try {
            for (int i = 0; i < size; ++i) {
                List currentResults = loaders[i].list(this);
                currentResults.addAll(results);
                results = currentResults;
            }
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    private OuterJoinLoadable getOuterJoinLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.factory.getEntityPersister(entityName);
        if (!(persister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + entityName);
        }
        return (OuterJoinLoadable)persister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        List results;
        this.errorIfClosed();
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        boolean success = false;
        try {
            results = loader.list(this, queryParameters);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        return loader.scroll(queryParameters, this);
    }

    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        return plan.performScroll(queryParameters, this);
    }

    public void afterScrollOperation() {
        this.temporaryPersistenceContext.clear();
    }

    public void flush() {
    }

    public String getFetchProfile() {
        return null;
    }

    public JDBCContext getJDBCContext() {
        return this.jdbcContext;
    }

    public void setFetchProfile(String name) {
    }

    public void afterTransactionBegin(Transaction tx) {
    }

    protected boolean autoFlushIfRequired(Set querySpaces) throws HibernateException {
        return false;
    }
}

