/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceReferenceBean;

public class QueryBean
extends ResourceBean {
    private String language;
    private String queryString;
    private ResourceReferenceBean dataSource;

    protected void additionalCopyFrom(Resource res, ResourceExportHandler referenceHandler) {
        Query query = (Query)res;
        this.setLanguage(query.getLanguage());
        this.setQueryString(query.getSql().replaceAll("\r\n", "\n"));
        this.setDataSource(referenceHandler.handleReference(query.getDataSource()));
    }

    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        Query query = (Query)res;
        query.setLanguage(this.getLanguage());
        query.setSql(this.getQueryString());
        query.setDataSource(importHandler.handleReference(this.getDataSource()));
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String sql) {
        this.queryString = sql;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public ResourceReferenceBean getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ResourceReferenceBean dataSource) {
        this.dataSource = dataSource;
    }
}

