/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.IlikeEscapeAwareExpression;
import com.jaspersoft.jasperserver.api.metadata.common.util.DatabaseCharactersEscapeResolver;
import com.jaspersoft.jasperserver.api.metadata.tenant.service.TenantPersistenceResolver;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoRole;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoTenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.ExternalUserService;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.UserAuthorityPersistenceService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.switchuser.SwitchUserGrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAuthorityServiceImpl
extends HibernateDaoImpl
implements UserDetailsService,
ExternalUserService,
UserAuthorityPersistenceService {
    protected static final Log log = LogFactory.getLog(UserAuthorityServiceImpl.class);
    private ResourceFactory objectFactory;
    private ResourceFactory persistentClassFactory;
    private ProfileAttributeService profileAttributeService;
    private TenantPersistenceResolver tenantPersistenceResolver;
    private AuditContext auditContext;
    private List defaultInternalRoles;
    private DatabaseCharactersEscapeResolver databaseCharactersEscapeResolver;

    public void setDatabaseCharactersEscapeResolver(DatabaseCharactersEscapeResolver databaseCharactersEscapeResolver) {
        this.databaseCharactersEscapeResolver = databaseCharactersEscapeResolver;
    }

    public DatabaseCharactersEscapeResolver getDatabaseCharactersEscapeResolver() {
        return this.databaseCharactersEscapeResolver;
    }

    public ResourceFactory getObjectMappingFactory() {
        return this.objectFactory;
    }

    public void setObjectMappingFactory(ResourceFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ResourceFactory getPersistentClassFactory() {
        return this.persistentClassFactory;
    }

    public void setPersistentClassFactory(ResourceFactory persistentClassFactory) {
        this.persistentClassFactory = persistentClassFactory;
    }

    public ProfileAttributeService getProfileAttributeService() {
        return this.profileAttributeService;
    }

    public void setProfileAttributeService(ProfileAttributeService pas) {
        this.profileAttributeService = pas;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    protected RepoUser getRepoUser(ExecutionContext context, String username) {
        return this.getRepoUser(username, null);
    }

    protected RepoUser getRepoUser(String username, String tenantId) {
        RepoTenant tenant = this.getPersistentTenant(tenantId, false);
        if (tenant == null && !this.isNullTenant(tenantId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant " + tenantId + " not found, returning null user"));
            }
            return null;
        }
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentUserClass());
        criteria.add((Criterion)Restrictions.naturalId().set("username", (Object)username).set("tenant", (Object)tenant));
        List userList = this.getHibernateTemplate().findByCriteria(criteria);
        RepoUser user = null;
        if (userList.isEmpty()) {
            log.debug((Object)("User not found with username \"" + username + "\" in tenant " + tenantId));
        } else {
            user = (RepoUser)userList.get(0);
        }
        return user;
    }

    protected RepoUser getRepoUser(ExecutionContext context, User user) {
        return this.getRepoUser(user.getUsername(), user.getTenantId());
    }

    protected Class getPersistentUserClass() {
        return this.getPersistentClassFactory().getImplementationClass(User.class);
    }

    protected Class getPersistentTenantClass() {
        return this.getPersistentClassFactory().getImplementationClass(Tenant.class);
    }

    public User getUser(ExecutionContext context, String username) {
        RepoUser user = this.getRepoUser(context, username);
        User userDTO = null;
        if (user != null) {
            userDTO = (User)user.toClient(this.getObjectMappingFactory());
            List attrs = this.getProfileAttributeService().getProfileAttributesForPrincipal(null, (Object)user);
            userDTO.setAttributes(attrs);
        } else {
            log.debug((Object)("No such user as: " + username));
        }
        return userDTO;
    }

    protected RepoUser getRepoUser(ExecutionContext context, Long id) {
        RepoUser user = (RepoUser)this.getHibernateTemplate().load(this.getPersistentUserClass(), (Serializable)id);
        return user;
    }

    protected User getUser(ExecutionContext context, Long id) {
        RepoUser user = this.getRepoUser(context, id);
        User userDTO = null;
        if (user != null) {
            userDTO = (User)user.toClient(this.getObjectMappingFactory());
        }
        return userDTO;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        User u = this.getUser(null, username);
        if (u == null) {
            throw new UsernameNotFoundException("User not found with username \"" + username + "\"");
        }
        return this.makeUserDetails(u);
    }

    protected MetadataUserDetails makeUserDetails(User user) {
        return new MetadataUserDetails(user);
    }

    public void putUser(ExecutionContext context, User aUser) {
        RepoUser existingUser;
        if (aUser instanceof RepoUser) {
            existingUser = (RepoUser)aUser;
        } else {
            existingUser = this.getRepoUser(context, aUser);
            if (existingUser == null) {
                existingUser = (RepoUser)this.getPersistentClassFactory().newObject(User.class);
            }
            this.updatePersistentUser(aUser, existingUser);
        }
        this.addPropertiesToUserEvent(new String[]{"createUser", "updateUser"}, existingUser);
        this.getHibernateTemplate().saveOrUpdate((Object)existingUser);
    }

    protected void updatePersistentUser(User user, RepoUser persistentUser) {
        persistentUser.copyFromClient((Object)user, this);
    }

    public List<User> getUsers(ExecutionContext context, FilterCriteria filterCriteria) {
        List results = this.getHibernateTemplate().loadAll(this.getPersistentUserClass());
        ArrayList<User> userDTOs = null;
        if (results != null) {
            userDTOs = new ArrayList<User>(results.size());
            for (RepoUser u : results) {
                User newUser = (User)u.toClient(this.getObjectMappingFactory());
                userDTOs.add(newUser);
            }
        }
        return userDTOs;
    }

    public List<User> getUsersByCriteria(ExecutionContext context, DetachedCriteria detachedCriteria) {
        List results = this.getHibernateTemplate().findByCriteria(detachedCriteria);
        ArrayList<User> userDTOs = null;
        if (results != null) {
            userDTOs = new ArrayList<User>(results.size());
            for (RepoUser u : results) {
                User newUser = (User)u.toClient(this.getObjectMappingFactory());
                userDTOs.add(newUser);
            }
        }
        return userDTOs;
    }

    public int getUsersCountExceptExcluded(ExecutionContext executionContext, final Set<String> excludedUserNames, final boolean excludeDisabledUsers) {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = session.createCriteria(UserAuthorityServiceImpl.this.getPersistentUserClass());
                if (excludedUserNames != null && excludedUserNames.size() > 0) {
                    criteria.add(Restrictions.not((Criterion)Restrictions.in((String)"username", (Collection)excludedUserNames)));
                }
                if (excludeDisabledUsers) {
                    criteria.add((Criterion)Restrictions.eq((String)"enabled", (Object)true));
                }
                criteria.setProjection((Projection)Projections.count((String)"id"));
                return criteria.uniqueResult();
            }
        });
    }

    public User newUser(ExecutionContext context) {
        return (User)this.getObjectMappingFactory().newObject(User.class);
    }

    protected boolean disableUser(ExecutionContext context, Long id) {
        RepoUser user = this.getRepoUser(context, id);
        if (user != null && user.isEnabled()) {
            user.setEnabled(false);
            return true;
        }
        return false;
    }

    public boolean disableUser(ExecutionContext context, String username) {
        RepoUser user = this.getRepoUser(context, username);
        if (user != null && user.isEnabled()) {
            user.setEnabled(false);
            return true;
        }
        return false;
    }

    protected boolean enableUser(ExecutionContext context, Long id) {
        RepoUser user = this.getRepoUser(context, id);
        if (user != null && !user.isEnabled()) {
            user.setEnabled(true);
            return true;
        }
        return false;
    }

    public boolean enableUser(ExecutionContext context, String username) {
        RepoUser user = this.getRepoUser(context, username);
        if (user != null && !user.isEnabled()) {
            user.setEnabled(true);
            return true;
        }
        return false;
    }

    private void addPropertiesToUserEvent(String[] auditEventTypes, final User user) {
        this.auditContext.doInAuditContext(auditEventTypes, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                if (user != null) {
                    UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("username", (Object)user.getUsername(), auditEvent);
                    UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("tenantId", (Object)user.getTenantId(), auditEvent);
                    UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("email", (Object)user.getEmailAddress(), auditEvent);
                    UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("fullName", (Object)user.getFullName(), auditEvent);
                    UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("passwordChangeTime", (Object)user.getPreviousPasswordChangeTime(), auditEvent);
                    UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("enabled", (Object)user.isEnabled(), auditEvent);
                    UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("externallyDefined", (Object)user.isExternallyDefined(), auditEvent);
                    List attrs = UserAuthorityServiceImpl.this.getProfileAttributeService().getProfileAttributesForPrincipal(null, (Object)user);
                    if (attrs != null && !attrs.isEmpty()) {
                        for (Object attribute : attrs) {
                            UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("attribute", attribute, auditEvent);
                        }
                    }
                    if (user.getRoles() != null && !user.getRoles().isEmpty()) {
                        for (Object roleObject : user.getRoles()) {
                            Role role = (Role)roleObject;
                            UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("roleName", (Object)role.getRoleName(), auditEvent);
                        }
                    }
                }
            }
        });
    }

    public void deleteUser(ExecutionContext context, String username) {
        RepoUser user = this.getRepoUser(context, username);
        if (user == null) {
            return;
        }
        this.addPropertiesToUserEvent(new String[]{"deleteUser"}, user);
        this.removeAllRoles(context, user);
        this.getHibernateTemplate().delete((Object)user);
    }

    public void addRole(ExecutionContext context, User user, Role role) {
        if (user == null) {
            return;
        }
        RepoUser existingUser = this.getRepoUser(context, user);
        if (existingUser != null) {
            RepoRole existingRole = this.getRepoRole(role);
            existingUser.addRole(existingRole);
            this.putUser(null, existingUser);
        }
        user.addRole(role);
    }

    public void removeRole(ExecutionContext context, User user, Role role) {
        if (user == null || role == null) {
            return;
        }
        RepoUser existingUser = this.getRepoUser(context, user);
        if (existingUser != null) {
            RepoRole r = this.getRepoRole(role);
            if (r != null) {
                existingUser.removeRole(r);
                this.putUser(null, existingUser);
            } else {
                log.debug((Object)("removeRole: No role such as " + role.getRoleName()));
            }
        } else {
            log.debug((Object)("removeRole: No user such as " + user.getUsername()));
        }
        user.removeRole(role);
    }

    public void removeAllRoles(ExecutionContext context, User user) {
        if (user == null) {
            return;
        }
        RepoUser existingUser = this.getRepoUser(context, user);
        if (existingUser == null) {
            return;
        }
        existingUser.getRoles().clear();
        this.putUser(null, existingUser);
    }

    public Role getRole(ExecutionContext context, String roleName) {
        RepoRole repoRole = this.getRepoRole(context, roleName);
        Role role = null;
        if (repoRole != null) {
            role = (Role)repoRole.toClient(this.getObjectMappingFactory());
        }
        return role;
    }

    protected Class getPersistentRoleClass() {
        return this.getPersistentClassFactory().getImplementationClass(Role.class);
    }

    protected RepoRole getRepoRole(ExecutionContext context, String roleName) {
        return this.getRepoRole(roleName, (String)null);
    }

    protected RepoRole getRepoRole(Role role) {
        return this.getRepoRole(role.getRoleName(), role.getTenantId());
    }

    protected RepoRole getRepoRole(String roleName, String tenantId) {
        RepoTenant tenant = this.getPersistentTenant(tenantId, false);
        if (tenant == null && !this.isNullTenant(tenantId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant " + tenantId + " not found, returning null role"));
            }
            return null;
        }
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentRoleClass());
        if (tenant == null) {
            criteria.add(Restrictions.isNull((String)"tenant")).add((Criterion)Restrictions.eq((String)"roleName", (Object)roleName));
        } else {
            criteria.add((Criterion)Restrictions.naturalId().set("tenant", (Object)tenant).set("roleName", (Object)roleName));
        }
        List roleList = this.getHibernateTemplate().findByCriteria(criteria);
        RepoRole role = null;
        if (roleList.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Role not found with role name \"" + roleName + "\"" + (tenantId == null ? "" : ", tenant \"" + tenantId + "\"")));
            }
        } else {
            role = (RepoRole)roleList.get(0);
        }
        return role;
    }

    public void putRole(ExecutionContext context, Role aRole) {
        RepoRole existingRole = this.getRepoRole(aRole);
        log.debug((Object)("putRole: " + aRole.getRoleName() + ", " + existingRole));
        if (existingRole == null) {
            existingRole = (RepoRole)this.getPersistentClassFactory().newObject(Role.class);
            log.debug((Object)"New Object");
        }
        Set existingRoleUserIds = this.getIdsFromUserSet(existingRole.getUsers());
        existingRole.copyFromClient((Object)aRole, this);
        Set newRoleUserIds = this.getIdsFromUserSet(existingRole.getUsers());
        this.addParametersToRoleManagementAuditEvent(new String[]{"createRole", "updateRole"}, existingRole, false);
        this.addUserIdsToRoleManagementAuditEvent(existingRoleUserIds, newRoleUserIds);
        this.getHibernateTemplate().saveOrUpdate((Object)existingRole);
        this.updateRoleUsers(context, existingRole, aRole);
    }

    private void updateRoleUsers(ExecutionContext context, RepoRole existingRole, Role aRole) {
        Set repoUsers = existingRole.getUsers();
        for (RepoUser repoUser : repoUsers) {
            repoUser.getRoles().remove(this.getPersistentObject(aRole));
        }
        Set users = aRole.getUsers();
        for (User user : users) {
            this.addRole(context, user, aRole);
        }
    }

    public List getRoles(ExecutionContext context, FilterCriteria filterCriteria) {
        List results = this.getHibernateTemplate().loadAll(this.getPersistentRoleClass());
        ArrayList<Role> roleDTOs = null;
        if (results != null) {
            roleDTOs = new ArrayList<Role>(results.size());
            for (RepoRole r : results) {
                Role newRole = (Role)r.toClient(this.getObjectMappingFactory());
                roleDTOs.add(newRole);
            }
        }
        return roleDTOs;
    }

    public Role newRole(ExecutionContext context) {
        return (Role)this.getObjectMappingFactory().newObject(Role.class);
    }

    private void addParametersToRoleManagementAuditEvent(String[] auditEventTypes, final RepoRole role, final boolean logUsers) {
        this.auditContext.doInAuditContext(auditEventTypes, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("roleName", (Object)role.getRoleName(), auditEvent);
                UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("tenantId", (Object)role.getTenantId(), auditEvent);
                UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("externallyDefined", (Object)role.isExternallyDefined(), auditEvent);
                if (role.getAttributes() != null && !role.getAttributes().isEmpty()) {
                    for (Object attribute : role.getAttributes()) {
                        UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("attribute", attribute, auditEvent);
                    }
                }
                if (logUsers && role.getUsers() != null && !role.getUsers().isEmpty()) {
                    for (Object userObject : role.getUsers()) {
                        RepoUser user = (RepoUser)userObject;
                        UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("userId", (Object)user.getId(), auditEvent);
                    }
                }
            }
        });
    }

    private Set getIdsFromUserSet(Set userSet) {
        if (userSet != null && !userSet.isEmpty()) {
            HashSet<Long> userIds = new HashSet<Long>(userSet.size());
            for (Object user : userSet) {
                userIds.add(((RepoUser)user).getId());
            }
            return userIds;
        }
        return null;
    }

    private void addUserIdsToRoleManagementAuditEvent(final Set usersIdsBeforeUpdate, final Set usersIdsAfterUpdate) {
        this.auditContext.doInAuditContext(new String[]{"createRole", "updateRole"}, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                if (usersIdsAfterUpdate != null && !usersIdsAfterUpdate.isEmpty()) {
                    Iterator i = usersIdsAfterUpdate.iterator();
                    while (i.hasNext()) {
                        Long id = (Long)i.next();
                        if (usersIdsBeforeUpdate == null || !usersIdsBeforeUpdate.contains(id)) continue;
                        usersIdsBeforeUpdate.remove(id);
                        i.remove();
                    }
                }
                if (usersIdsBeforeUpdate != null && !usersIdsBeforeUpdate.isEmpty()) {
                    for (Object removedId : usersIdsBeforeUpdate) {
                        UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("removedUserId", removedId, auditEvent);
                    }
                }
                if (usersIdsAfterUpdate != null && !usersIdsAfterUpdate.isEmpty()) {
                    for (Object addedId : usersIdsAfterUpdate) {
                        UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent("addedUserId", addedId, auditEvent);
                    }
                }
            }
        });
    }

    public void deleteRole(ExecutionContext context, String roleName) {
        RepoRole role = this.getRepoRole(context, roleName);
        if (role == null) {
            return;
        }
        this.addParametersToRoleManagementAuditEvent(new String[]{"deleteRole"}, role, true);
        Set userList = role.getUsers();
        for (RepoUser u : userList) {
            u.removeRole(role);
        }
        this.getHibernateTemplate().delete((Object)role);
    }

    public List getUsersNotInRole(ExecutionContext context, String roleName) {
        List<User> allUsers = this.getUsers(context, null);
        List usersInRole = this.getUsersInRole(context, roleName);
        allUsers.removeAll(usersInRole);
        return allUsers;
    }

    public List getUsersInRole(ExecutionContext context, String roleName) {
        RepoRole repoRole = this.getRepoRole(context, roleName);
        Set repoUsers = repoRole.getUsers();
        ArrayList<User> users = new ArrayList<User>();
        for (RepoUser repoUser : repoUsers) {
            User user = (User)repoUser.toClient(this.getObjectMappingFactory());
            users.add(user);
        }
        return users;
    }

    public List getAssignedRoles(ExecutionContext context, String userName) {
        RepoUser repoUser = this.getRepoUser(context, userName);
        Set repoRoles = repoUser.getRoles();
        ArrayList<Role> roles = new ArrayList<Role>();
        for (RepoRole repoRole : repoRoles) {
            Role role = (Role)repoRole.toClient(this.getObjectMappingFactory());
            roles.add(role);
        }
        return roles;
    }

    public List getAvailableRoles(ExecutionContext context, String userName) {
        List allRoles = this.getRoles(context, null);
        List assignedRoles = this.getAssignedRoles(null, userName);
        allRoles.removeAll(assignedRoles);
        return allRoles;
    }

    public boolean roleExists(ExecutionContext context, String roleName) {
        return this.getRole(context, roleName) != null;
    }

    @Override
    public Object getPersistentObject(Object clientObject) {
        if (clientObject instanceof Role) {
            Role r = (Role)clientObject;
            return this.getRepoRole(r);
        }
        if (clientObject instanceof User) {
            User u = (User)clientObject;
            return this.getRepoUser(null, u);
        }
        return null;
    }

    @Override
    public User maintainInternalUser(UserDetails externalUserDetails, GrantedAuthority[] authorities) {
        log.debug((Object)("External user: " + externalUserDetails.getUsername()));
        User user = this.getUser((ExecutionContext)new ExecutionContextImpl(), externalUserDetails.getUsername());
        if (user == null) {
            user = this.createNewExternalUser(externalUserDetails.getUsername());
        }
        Set roles = this.persistRoles(this.getRolesFromGrantedAuthorities(authorities));
        this.alignInternalAndExternalUser(roles, user);
        return user;
    }

    @Override
    public User maintainInternalUser(String userName, GrantedAuthority[] authorities) {
        log.debug((Object)("External user(String): " + userName));
        User user = this.getUser((ExecutionContext)new ExecutionContextImpl(), userName);
        if (user == null) {
            user = this.createNewExternalUser(userName);
        }
        Set roles = this.persistRoles(this.getRolesFromGrantedAuthorities(authorities));
        this.alignInternalAndExternalUser(roles, user);
        return user;
    }

    protected User createNewExternalUser(String userName) {
        User user = this.newUser((ExecutionContext)new ExecutionContextImpl());
        user.setUsername(userName);
        user.setFullName(userName);
        user.setExternallyDefined(true);
        user.setEnabled(true);
        log.warn((Object)("Created new external user: " + user.getUsername()));
        return user;
    }

    protected void alignInternalAndExternalUser(Set externalRoles, User user) {
        Collection defaultInternalRolesToAdd;
        Collection rolesNeedingRemoval;
        Collection newExternalRoles;
        Predicate externallyDefinedRoles = new Predicate(){

            public boolean evaluate(Object input) {
                if (!(input instanceof Role)) {
                    return false;
                }
                return ((Role)input).isExternallyDefined();
            }
        };
        Set currentRoles = user.getRoles();
        boolean persistUserNeeded = currentRoles.size() == 0;
        Collection currentExternalRoles = CollectionUtils.select((Collection)user.getRoles(), (Predicate)externallyDefinedRoles);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Login of external User: " + user.getUsername()));
            log.debug((Object)("Roles from authentication:\n" + this.roleCollectionToString(externalRoles)));
            log.debug((Object)("Current roles from metadata:\n" + this.roleCollectionToString(user.getRoles())));
            log.debug((Object)("Current external roles for user from metadata: " + user.getUsername() + "\n" + this.roleCollectionToString(currentExternalRoles)));
        }
        if ((newExternalRoles = CollectionUtils.subtract((Collection)externalRoles, (Collection)currentExternalRoles)).size() > 0) {
            currentRoles.addAll(newExternalRoles);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Added following external roles to: " + user.getUsername() + "\n" + this.roleCollectionToString(newExternalRoles)));
            }
            persistUserNeeded = true;
        }
        if ((rolesNeedingRemoval = CollectionUtils.subtract((Collection)currentExternalRoles, (Collection)externalRoles)).size() > 0) {
            currentRoles.removeAll(rolesNeedingRemoval);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Removed following external roles from: " + user.getUsername() + "\n" + this.roleCollectionToString(rolesNeedingRemoval)));
            }
            persistUserNeeded = true;
        }
        if ((defaultInternalRolesToAdd = CollectionUtils.subtract((Collection)this.getNewDefaultInternalRoles(), (Collection)currentRoles)).size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Default internal roles: " + this.roleCollectionToString(this.getNewDefaultInternalRoles())));
            }
            currentRoles.addAll(defaultInternalRolesToAdd);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Added following new default internal roles to: " + user.getUsername() + "\n" + this.roleCollectionToString(defaultInternalRolesToAdd)));
            }
            persistUserNeeded = true;
        }
        if (persistUserNeeded) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Updated user: " + user.getUsername() + ". Roles are now:\n" + this.roleCollectionToString(currentRoles)));
            }
            user.setRoles(currentRoles);
            this.putUser((ExecutionContext)new ExecutionContextImpl(), user);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Updated user: " + user.getUsername() + ". Roles are now:\n" + this.roleCollectionToString(currentRoles)));
            }
        }
    }

    private String roleCollectionToString(Collection coll) {
        Iterator it = coll.iterator();
        StringBuffer rolesPrint = new StringBuffer();
        while (it.hasNext()) {
            String s = ((Role)it.next()).getRoleName();
            rolesPrint.append(s).append("\n");
        }
        return rolesPrint.toString();
    }

    protected Set getRolesFromGrantedAuthorities(GrantedAuthority[] authorities) {
        HashSet<Role> set = new HashSet<Role>();
        if (authorities == null || authorities.length == 0) {
            return set;
        }
        for (int i = 0; i < authorities.length; ++i) {
            GrantedAuthority auth = authorities[i];
            String authorityName = auth.getAuthority();
            if (!(authorityName = authorityName.replace(' ', '_')).startsWith("ROLE_")) {
                authorityName = "ROLE_" + authorityName;
            }
            Role r = this.newRole((ExecutionContext)new ExecutionContextImpl());
            r.setRoleName(authorityName);
            r.setExternallyDefined(true);
            set.add(r);
        }
        return set;
    }

    protected Set persistRoles(Set roles) {
        HashSet<Role> persistedRoles = new HashSet<Role>();
        for (Role r : roles) {
            persistedRoles.add(this.getOrCreateRole(r.getRoleName(), r.isExternallyDefined()));
        }
        return persistedRoles;
    }

    public static Authentication getSourceAuthentication() {
        Authentication current = SecurityContextHolder.getContext().getAuthentication();
        Authentication original = null;
        GrantedAuthority[] authorities = current.getAuthorities();
        for (int i = 0; i < authorities.length; ++i) {
            if (!(authorities[i] instanceof SwitchUserGrantedAuthority)) continue;
            original = ((SwitchUserGrantedAuthority)authorities[i]).getSource();
            log.debug((Object)("Found original switch user granted authority [" + original + "]"));
        }
        return original;
    }

    public static boolean isUserSwitched() {
        return UserAuthorityServiceImpl.getSourceAuthentication() != null;
    }

    private Set getNewDefaultInternalRoles() {
        HashSet<Role> set = new HashSet<Role>();
        if (this.getDefaultInternalRoles() == null || this.getDefaultInternalRoles().size() == 0) {
            return set;
        }
        for (int i = 0; i < this.getDefaultInternalRoles().size(); ++i) {
            String roleName = (String)this.getDefaultInternalRoles().get(i);
            set.add(this.getOrCreateRole(roleName, false));
        }
        return set;
    }

    private Role getOrCreateRole(String roleName, boolean externallyDefined) {
        Role r = this.getRole((ExecutionContext)new ExecutionContextImpl(), roleName);
        if (r == null) {
            r = this.newRole((ExecutionContext)new ExecutionContextImpl());
            r.setRoleName(roleName);
            r.setExternallyDefined(externallyDefined);
            this.putRole((ExecutionContext)new ExecutionContextImpl(), r);
            log.warn((Object)("Created new " + (externallyDefined ? "external" : "internal") + " role: " + roleName));
        }
        return r;
    }

    @Override
    public void makeUserLoggedIn(User user) {
        try {
            MetadataUserDetails ourUserDetails = this.makeUserDetails(user);
            if (ourUserDetails.getAuthorities().length != 0) {
                UsernamePasswordAuthenticationToken ourAuthentication = new UsernamePasswordAuthenticationToken((Object)ourUserDetails, (Object)ourUserDetails.getPassword(), ourUserDetails.getAuthorities());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting Authentication to: " + ourAuthentication));
                }
                SecurityContextHolder.getContext().setAuthentication((Authentication)ourAuthentication);
            } else {
                SecurityContextHolder.getContext().setAuthentication(null);
            }
        }
        catch (UsernameNotFoundException e) {
            log.warn((Object)("User: " + user.getUsername() + " was not found to make them logged in"));
        }
    }

    public List getDefaultInternalRoles() {
        return this.defaultInternalRoles;
    }

    public void setDefaultInternalRoles(List defaultInternalRoles) {
        this.defaultInternalRoles = defaultInternalRoles;
    }

    public boolean userExists(ExecutionContext context, String username) {
        return this.getUser(context, username) != null;
    }

    protected boolean isDateExpired(int nDate, Date previousExpirationDate) {
        long during = nDate * 3600 * 24;
        return previousExpirationDate.getTime() / 1000L + during <= new Date().getTime() / 1000L;
    }

    public boolean isPasswordExpired(ExecutionContext context, String username, int nDate) {
        Date previousExpirationDate = this.getUser(context, username).getPreviousPasswordChangeTime();
        if (previousExpirationDate == null || "".equals(previousExpirationDate)) {
            this.resetPasswordExpiration(context, username);
            return false;
        }
        return this.isDateExpired(nDate, previousExpirationDate);
    }

    public void resetPasswordExpiration(ExecutionContext context, String username) {
        User user = this.getUser(context, username);
        if (user != null) {
            user.setPreviousPasswordChangeTime(new Date());
            this.putUser(context, user);
        }
    }

    public String getTenantId(ExecutionContext context, String userName) {
        User user = this.getUser(context, userName);
        return user.getTenantId();
    }

    public List getTenantUsers(ExecutionContext context, final Set tenantIds, final String name) {
        List userList = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = UserAuthorityServiceImpl.this.createTenantUsersCriteria(session, tenantIds, name);
                return criteria.list();
            }
        });
        List userDTOs = this.convertUserListToDtoList(userList);
        return userDTOs;
    }

    public List getTenantUsers(ExecutionContext context, final Set tenantIds, final String name, final int firstResult, final int maxResults) {
        List userList = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = UserAuthorityServiceImpl.this.createTenantUsersCriteria(session, tenantIds, name);
                if (firstResult >= 0) {
                    criteria.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    criteria.setMaxResults(maxResults);
                }
                return criteria.list();
            }
        });
        List userDTOs = this.convertUserListToDtoList(userList);
        return userDTOs;
    }

    public List getTenantRoles(ExecutionContext context, final Set tenantIds, final String name) {
        List roleList = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = UserAuthorityServiceImpl.this.createTenantRolesCriteria(session, tenantIds, name);
                return criteria.list();
            }
        });
        return this.convertRoleListToDtoList(roleList);
    }

    public List getTenantRoles(ExecutionContext context, final Set tenantIds, final String name, final int firstResult, final int maxResults) {
        List roleList = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = UserAuthorityServiceImpl.this.createTenantRolesCriteria(session, tenantIds, name);
                if (firstResult >= 0) {
                    criteria.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    criteria.setMaxResults(maxResults);
                }
                return criteria.list();
            }
        });
        return this.convertRoleListToDtoList(roleList);
    }

    public List getTenantVisibleRoles(ExecutionContext context, Set tenantIds, String name, int firstResult, int maxResults) {
        DetachedCriteria criteria = this.createTenantVisibleRolesCriteria(tenantIds, name);
        List results = this.getHibernateTemplate().findByCriteria(criteria, firstResult, maxResults);
        List<Role> roleDTOs = this.convertRoleListToDtoList(results);
        return roleDTOs;
    }

    public int getTenantVisibleRolesCount(ExecutionContext context, Set tenantIds, String name) {
        DetachedCriteria criteria = this.createTenantVisibleRolesCriteria(tenantIds, name, false);
        criteria.setProjection(Projections.rowCount());
        List results = this.getHibernateTemplate().findByCriteria(criteria);
        Integer rowCount = new Integer(0);
        if (results != null && !results.isEmpty()) {
            rowCount = (Integer)results.get(0);
        }
        return rowCount;
    }

    public int getTenantUsersCount(ExecutionContext context, final Set tenantIds, final String name) {
        Integer rowCount = (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = UserAuthorityServiceImpl.this.createTenantUsersCriteria(session, tenantIds, name, false);
                criteria.setProjection(Projections.rowCount());
                return criteria.uniqueResult();
            }
        });
        return rowCount;
    }

    public int getTenantRolesCount(ExecutionContext context, final Set tenantIds, final String name) {
        Integer rowCount = (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = UserAuthorityServiceImpl.this.createTenantRolesCriteria(session, tenantIds, name, false);
                criteria.setProjection(Projections.rowCount());
                return criteria.uniqueResult();
            }
        });
        return rowCount;
    }

    private Criteria createTenantUsersCriteria(Session session, Set tenantIds, String name) {
        return this.createTenantUsersCriteria(session, tenantIds, name, true);
    }

    private Criteria createTenantUsersCriteria(Session session, Set tenantIds, String name, boolean order) {
        HashSet<String> internalTenantIds = null;
        if (tenantIds != null) {
            internalTenantIds = new HashSet<String>();
            internalTenantIds.addAll(tenantIds);
            if (internalTenantIds.contains(null)) {
                internalTenantIds.remove(null);
                internalTenantIds.add("organizations");
            }
        }
        Criteria criteria = session.createCriteria(this.getPersistentUserClass());
        criteria.createAlias("tenant", "tenant", 1);
        if (internalTenantIds == null) {
            criteria.add((Criterion)Restrictions.eq((String)"tenant.tenantId", (Object)"organizations"));
        } else if (!internalTenantIds.isEmpty()) {
            criteria.add(Restrictions.in((String)"tenant.tenantId", internalTenantIds));
        }
        if (name != null && (name = this.databaseCharactersEscapeResolver.getEscapedText(name.trim())).length() > 0) {
            IlikeEscapeAwareExpression userNameCriterion = new IlikeEscapeAwareExpression("username", name, MatchMode.ANYWHERE);
            IlikeEscapeAwareExpression fullNameCriterion = new IlikeEscapeAwareExpression("fullName", name, MatchMode.ANYWHERE);
            criteria.add((Criterion)Restrictions.or((Criterion)userNameCriterion, (Criterion)fullNameCriterion));
        }
        if (order) {
            criteria.addOrder(Order.asc((String)"username"));
            criteria.addOrder(Order.asc((String)"tenant.tenantId"));
        }
        return criteria;
    }

    protected Criteria createTenantRolesCriteria(Session session, Set tenantIds, String name) {
        return this.createTenantRolesCriteria(session, tenantIds, name, true);
    }

    protected Criteria createTenantRolesCriteria(Session session, Set tenantIds, String name, boolean order) {
        Criteria criteria = session.createCriteria(this.getPersistentRoleClass());
        String roleNameField = "roleName";
        this.addTenantCriteria(criteria, tenantIds);
        if (name != null && name.trim().length() > 0) {
            Criterion roleNameCriterion = Restrictions.ilike((String)roleNameField, (Object)("%" + name.trim() + "%"));
            criteria.add(roleNameCriterion);
        }
        if (order) {
            criteria.addOrder(Order.asc((String)roleNameField));
        }
        return criteria;
    }

    protected DetachedCriteria createTenantVisibleRolesCriteria(Set tenantIds, String name) {
        return this.createTenantVisibleRolesCriteria(tenantIds, name, true);
    }

    protected DetachedCriteria createTenantVisibleRolesCriteria(Set tenantIds, String name, boolean order) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentRoleClass());
        String roleNameField = "roleName";
        this.addVisibleTenantCriteria(criteria, tenantIds);
        if (name != null && (name = this.databaseCharactersEscapeResolver.getEscapedText(name.trim())).length() > 0) {
            criteria.add((Criterion)new IlikeEscapeAwareExpression(roleNameField, name, MatchMode.ANYWHERE));
        }
        if (order) {
            criteria.addOrder(Order.asc((String)roleNameField));
        }
        return criteria;
    }

    private List convertUserListToDtoList(List userList) {
        ArrayList<User> userDTOs = null;
        if (userList != null) {
            userDTOs = new ArrayList<User>(userList.size());
            for (RepoUser u : userList) {
                User newUser = (User)u.toClient(this.getObjectMappingFactory());
                userDTOs.add(newUser);
            }
        }
        return userDTOs;
    }

    public List getAvailableRoles(ExecutionContext context, String roleName, Set userRoles, String userName, int firstResult, int maxResults) {
        DetachedCriteria criteria = this.createAvailableRolesCriteria(roleName, userRoles, userName);
        List results = this.getHibernateTemplate().findByCriteria(criteria, firstResult, maxResults);
        List<Role> roleDTOs = this.convertRoleListToDtoList(results);
        return roleDTOs;
    }

    public int getAvailableRolesCount(ExecutionContext context, String roleName, Set userRoles, String userName) {
        DetachedCriteria criteria = this.createAvailableRolesCriteria(roleName, userRoles, userName, false);
        criteria.setProjection(Projections.rowCount());
        List results = this.getHibernateTemplate().findByCriteria(criteria);
        Integer rowCount = new Integer(0);
        if (results != null && !results.isEmpty()) {
            rowCount = (Integer)results.get(0);
        }
        return rowCount;
    }

    protected DetachedCriteria createAvailableRolesCriteria(String roleName, Set userRoles, String userName) {
        return this.createAvailableRolesCriteria(roleName, userRoles, userName, true);
    }

    protected DetachedCriteria createAvailableRolesCriteria(String roleName, Set userRoles, String userName, boolean order) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentRoleClass());
        String roleNameField = "roleName";
        String externallyDefinedField = "externallyDefined";
        if (userRoles != null && userRoles.size() > 0) {
            List userRoleIdList = this.getRoleIdList(userRoles);
            criteria.add(Restrictions.not((Criterion)Restrictions.in((String)"id", (Collection)userRoleIdList)));
        }
        Criterion roleNameCriterion = Restrictions.ilike((String)roleNameField, (Object)("%" + roleName.trim() + "%"));
        criteria.add(roleNameCriterion);
        criteria.add((Criterion)Restrictions.eq((String)externallyDefinedField, (Object)Boolean.FALSE));
        if (order) {
            criteria.addOrder(Order.asc((String)roleNameField));
        }
        return criteria;
    }

    protected List getRoleIdList(Set roleNames) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentRoleClass());
        if (roleNames == null || roleNames.size() <= 0) {
            return new ArrayList();
        }
        criteria.add(Restrictions.in((String)"roleName", (Collection)roleNames));
        criteria.setProjection((Projection)Projections.id());
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    private List<Role> convertRoleListToDtoList(List roleList) {
        ArrayList<Role> roleDTOs = null;
        if (roleList != null) {
            roleDTOs = new ArrayList<Role>(roleList.size());
            for (Object aRoleList : roleList) {
                RepoRole r = (RepoRole)aRoleList;
                Role newRole = (Role)r.toClient(this.getObjectMappingFactory());
                roleDTOs.add(newRole);
            }
        }
        return roleDTOs;
    }

    public List<Role> getAvailableRoles(ExecutionContext context, String userName, String text, int firstResult, int maxResults) {
        DetachedCriteria criteria = this.createAvailableRolesCriteria(context, userName, text, true);
        List results = this.getHibernateTemplate().findByCriteria(criteria, firstResult, maxResults);
        return this.convertRoleListToDtoList(results);
    }

    public int getAvailableRolesCount(ExecutionContext context, String userName, String text) {
        DetachedCriteria criteria = this.createAvailableRolesCriteria(context, userName, text, false);
        criteria.setProjection(Projections.rowCount());
        List results = this.getHibernateTemplate().findByCriteria(criteria);
        int rowCount = 0;
        if (results != null && !results.isEmpty()) {
            rowCount = (Integer)results.get(0);
        }
        return rowCount;
    }

    protected DetachedCriteria createAvailableRolesCriteria(ExecutionContext context, String userName, String text, boolean order) {
        String roleNameField = "roleName";
        String externallyDefinedField = "externallyDefined";
        RepoUser user = this.getRepoUser(context, userName);
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentRoleClass());
        List<Long> assignedRolesIds = this.getUserRolesIds(user);
        if (assignedRolesIds != null && assignedRolesIds.size() > 0) {
            criteria.add(Restrictions.not((Criterion)Restrictions.in((String)"id", assignedRolesIds)));
        }
        String roleNameLikeValue = text == null ? "" : text;
        Criterion roleNameCriterion = Restrictions.ilike((String)"roleName", (Object)("%" + roleNameLikeValue + "%"));
        criteria.add(roleNameCriterion);
        criteria.add((Criterion)Restrictions.eq((String)"externallyDefined", (Object)Boolean.FALSE));
        if (order) {
            criteria.addOrder(Order.asc((String)"roleName"));
        }
        return criteria;
    }

    protected List<Long> getUserRolesIds(RepoUser user) {
        DetachedCriteria criteria = this.createAssignedRolesCriteria(null, user, null, true);
        criteria.setProjection((Projection)Projections.id());
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    public List getAssignedRoles(ExecutionContext context, String userName, String text, int firstResult, int maxResults) {
        RepoUser user = this.getRepoUser(context, userName);
        DetachedCriteria criteria = this.createAssignedRolesCriteria(context, user, text, true);
        List results = this.getHibernateTemplate().findByCriteria(criteria, firstResult, maxResults);
        return this.convertRoleListToDtoList(results);
    }

    public int getAssignedRolesCount(ExecutionContext context, String userName, String text) {
        RepoUser user = this.getRepoUser(context, userName);
        DetachedCriteria criteria = this.createAssignedRolesCriteria(context, user, text, false);
        criteria.setProjection(Projections.rowCount());
        List results = this.getHibernateTemplate().findByCriteria(criteria);
        int rowCount = 0;
        if (results != null && !results.isEmpty()) {
            rowCount = (Integer)results.get(0);
        }
        return rowCount;
    }

    private DetachedCriteria createAssignedRolesCriteria(ExecutionContext context, RepoUser user, String text, boolean order) {
        String roleNameField = "roleName";
        String externallyDefinedField = "externallyDefined";
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentRoleClass());
        DetachedCriteria usersCriteria = criteria.createCriteria("users");
        usersCriteria.add(Restrictions.idEq((Object)user.getId()));
        String roleNameLikeValue = text == null ? "" : text;
        Criterion roleNameCriterion = Restrictions.ilike((String)"roleName", (Object)("%" + roleNameLikeValue + "%"));
        criteria.add(roleNameCriterion);
        criteria.add((Criterion)Restrictions.eq((String)"externallyDefined", (Object)Boolean.FALSE));
        if (order) {
            criteria.addOrder(Order.asc((String)"roleName"));
        }
        return criteria;
    }

    public void updateUser(ExecutionContext context, String userName, User aUser) {
        RepoUser existingUser = this.getRepoUser(context, userName);
        log.debug((Object)("updateUser: " + userName + ", " + existingUser));
        if (existingUser == null) {
            log.debug((Object)"User not found");
            throw new IllegalArgumentException("Cannot find user with name : " + userName);
        }
        this.updatePersistentUser(aUser, existingUser);
        this.addPropertiesToUserEvent(new String[]{"updateUser"}, existingUser);
        this.getHibernateTemplate().saveOrUpdate((Object)existingUser);
    }

    public void updateRole(ExecutionContext context, String roleName, Role roleDetails) throws IllegalArgumentException {
        RepoRole existingRole = this.getRepoRole(context, roleName);
        log.debug((Object)("updateRole: " + roleName + ", " + existingRole));
        if (existingRole == null) {
            log.debug((Object)"Role not found");
            throw new IllegalArgumentException("Cannot find role with name : " + roleName);
        }
        existingRole.copyFromClient((Object)roleDetails, this);
        this.addParametersToRoleManagementAuditEvent(new String[]{"updateRole"}, existingRole, false);
        this.getHibernateTemplate().saveOrUpdate((Object)existingRole);
    }

    public List getUsersWithoutRole(ExecutionContext context, String roleName, String userName, int firstResult, int maxResults) {
        DetachedCriteria criteria = this.createUsersWithoutRoleCriteria(roleName, userName);
        List userList = this.getHibernateTemplate().findByCriteria(criteria, firstResult, maxResults);
        return this.convertUserListToDtoList(userList);
    }

    public int getUsersCountWithoutRole(ExecutionContext context, String roleName, String userName) {
        DetachedCriteria criteria = this.createUsersWithoutRoleCriteria(roleName, userName, false);
        criteria.setProjection(Projections.rowCount());
        List results = this.getHibernateTemplate().findByCriteria(criteria);
        return this.getRowCountFromResult(results);
    }

    protected DetachedCriteria createUsersWithoutRoleCriteria(String roleName, String userName) {
        return this.createUsersWithoutRoleCriteria(roleName, userName, true);
    }

    protected DetachedCriteria createUsersWithoutRoleCriteria(String roleName, String userName, boolean order) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentUserClass());
        DetachedCriteria usersWithRoleCriteria = this.createUsersWithRoleCriteria(roleName, "");
        usersWithRoleCriteria.setProjection((Projection)Projections.id());
        List usersWithRole = this.getHibernateTemplate().findByCriteria(usersWithRoleCriteria);
        String userNameField = "username";
        this.createSearchByUserNameCriteria(criteria, userName);
        if (usersWithRole != null && usersWithRole.size() > 0) {
            criteria.add(Restrictions.not((Criterion)Restrictions.in((String)"id", (Collection)usersWithRole)));
        }
        if (order) {
            criteria.addOrder(Order.asc((String)userNameField));
        }
        return criteria;
    }

    private void addTenantCriteria(Criteria criteria, Set tenantIds) {
        HashSet<String> internalTenantIds = null;
        if (tenantIds != null) {
            internalTenantIds = new HashSet<String>();
            internalTenantIds.addAll(tenantIds);
            if (internalTenantIds.contains(null)) {
                internalTenantIds.remove(null);
                internalTenantIds.add("organizations");
            }
        }
        criteria.createAlias("tenant", "tenant", 1);
        if (internalTenantIds == null) {
            criteria.add((Criterion)Restrictions.eq((String)"tenant.tenantId", (Object)"organizations"));
        } else if (!internalTenantIds.isEmpty()) {
            Criterion idInCriterion = Restrictions.in((String)"tenant.tenantId", internalTenantIds);
            criteria.add(idInCriterion);
        }
    }

    protected List getIdByTenantIdSet(Set tenantIds) {
        DetachedCriteria idCriteria = DetachedCriteria.forClass((Class)this.getPersistentTenantClass());
        idCriteria.add(Restrictions.in((String)"tenantId", (Collection)tenantIds));
        idCriteria.setProjection((Projection)Projections.id());
        return this.getHibernateTemplate().findByCriteria(idCriteria);
    }

    protected void addVisibleTenantCriteria(DetachedCriteria criteria, Set tenantIds) {
        HashSet<String> internalTenantIds = null;
        if (tenantIds != null) {
            internalTenantIds = new HashSet<String>();
            internalTenantIds.addAll(tenantIds);
            if (internalTenantIds.contains(null)) {
                internalTenantIds.remove(null);
                internalTenantIds.add("organizations");
            }
        }
        if (internalTenantIds == null) {
            RepoTenant tenant = this.tenantPersistenceResolver.getPersistentTenant("organizations", true);
            criteria.add((Criterion)Restrictions.eq((String)"tenant.id", (Object)tenant.getId()));
        } else if (!internalTenantIds.isEmpty()) {
            Criterion idInCriterion = Restrictions.in((String)"tenant.id", (Collection)this.getIdByTenantIdSet(internalTenantIds));
            criteria.add(idInCriterion);
        }
    }

    public List getUsersWithRole(ExecutionContext context, String roleName, String userName, int firstResult, int maxResults) {
        DetachedCriteria criteria = this.createUsersWithRoleCriteria(roleName, userName);
        List userList = this.getHibernateTemplate().findByCriteria(criteria, firstResult, maxResults);
        return this.convertUserListToDtoList(userList);
    }

    public int getUsersCountWithRole(ExecutionContext context, String roleName, String userName) {
        DetachedCriteria criteria = this.createUsersWithRoleCriteria(roleName, userName, false);
        criteria.setProjection(Projections.rowCount());
        List results = this.getHibernateTemplate().findByCriteria(criteria);
        return this.getRowCountFromResult(results);
    }

    protected DetachedCriteria createUsersWithRoleCriteria(String roleName, String userName) {
        return this.createUsersWithRoleCriteria(roleName, userName, true);
    }

    protected DetachedCriteria createUsersWithRoleCriteria(String roleName, String userName, boolean order) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentUserClass());
        String userNameField = "username";
        String roleNameField = "roleName";
        this.createSearchByUserNameCriteria(criteria, userName);
        if (roleName != null && roleName.trim().length() > 0) {
            SimpleExpression roleNameCriterion = Restrictions.eq((String)roleNameField, (Object)roleName.trim());
            criteria.createCriteria("roles").add((Criterion)roleNameCriterion);
        }
        if (order) {
            criteria.addOrder(Order.asc((String)userNameField));
        }
        return criteria;
    }

    protected void createSearchByUserNameCriteria(DetachedCriteria criteria, String userName) {
        if (userName != null && userName.trim().length() > 0) {
            Criterion userNameCriterion = Restrictions.ilike((String)"username", (Object)("%" + userName.trim() + "%"));
            Criterion fullNameCriterion = Restrictions.ilike((String)"fullName", (Object)("%" + userName.trim() + "%"));
            criteria.add((Criterion)Restrictions.or((Criterion)userNameCriterion, (Criterion)fullNameCriterion));
        }
    }

    protected int getRowCountFromResult(List results) {
        Integer rowCount = new Integer(0);
        if (results != null && !results.isEmpty()) {
            rowCount = (Integer)results.get(0);
        }
        return rowCount;
    }

    private void addUserParamsToUpdateRoleAuditEvent(final String actionPrefix, final List users) {
        this.auditContext.doInAuditContext("updateRole", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                if (users != null && !users.isEmpty()) {
                    for (Object userObject : users) {
                        RepoUser user = (RepoUser)userObject;
                        UserAuthorityServiceImpl.this.auditContext.addPropertyToAuditEvent(actionPrefix + "UserId", (Object)user.getId(), auditEvent);
                    }
                }
            }
        });
    }

    public void assignUsers(ExecutionContext context, String roleName, Set userNames) {
        if (userNames != null && !userNames.isEmpty()) {
            List users = this.getUsersByUserNames(context, userNames);
            this.addUserParamsToUpdateRoleAuditEvent("added", users);
            RepoRole role = this.getRepoRole(context, roleName);
            for (RepoUser user : users) {
                user.addRole(role);
            }
        }
    }

    public void unassignUsers(ExecutionContext context, String roleName, Set userNames) {
        if (userNames != null && !userNames.isEmpty()) {
            List users = this.getUsersByUserNames(context, userNames);
            this.addUserParamsToUpdateRoleAuditEvent("removed", users);
            RepoRole role = this.getRepoRole(context, roleName);
            for (RepoUser user : users) {
                user.removeRole(role);
            }
        }
    }

    protected List getUsersByUserNames(ExecutionContext context, Set userNames) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentUserClass());
        if (userNames != null && !userNames.isEmpty()) {
            criteria.add(Restrictions.in((String)"username", (Collection)userNames));
        }
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public RepoUser getPersistentUser(String username) {
        return this.getRepoUser((ExecutionContext)null, username);
    }

    protected boolean isNullTenant(String tenantId) {
        return tenantId == null || tenantId.length() == 0 || "organizations".equals(tenantId);
    }

    @Override
    public RepoTenant getPersistentTenant(String tenantId, boolean required) {
        if (this.isNullTenant(tenantId)) {
            return this.getTenantPersistenceResolver().getPersistentTenant("organizations", true);
        }
        throw new IllegalArgumentException("This implementation does not support tenants");
    }

    @Override
    public RepoTenant getPersistentTenantByAlias(String tenantAlias, boolean required) {
        if (this.isNullTenant(tenantAlias)) {
            return this.getTenantPersistenceResolver().getPersistentTenant("organizations", true);
        }
        throw new IllegalArgumentException("This implementation does not support tenants");
    }

    public TenantPersistenceResolver getTenantPersistenceResolver() {
        return this.tenantPersistenceResolver;
    }

    public void setTenantPersistenceResolver(TenantPersistenceResolver tenantPersistenceResolver) {
        this.tenantPersistenceResolver = tenantPersistenceResolver;
    }
}

