/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateBeforeDeleteListener;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoRole;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoTenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.EventSource;

public class HibernateRoleDeleteListener
implements HibernateBeforeDeleteListener {
    public void beforeDelete(DeleteEvent event) {
        Object o = event.getObject();
        if (o instanceof RepoTenant) {
            this.deleteRolesByTenant((RepoTenant)o, event.getSession());
        }
    }

    private void deleteRoleFromUsers(RepoRole role) {
        Set userList = role.getUsers();
        for (RepoUser u : userList) {
            u.removeRole(role);
        }
    }

    protected void deleteRolesByTenant(RepoTenant tenant, EventSource session) {
        Criteria criteria = session.createCriteria(RepoRole.class);
        criteria.add((Criterion)Restrictions.eq((String)"tenant", (Object)tenant));
        List roles = criteria.list();
        if (roles != null && !roles.isEmpty()) {
            for (RepoRole role : roles) {
                this.deleteRoleFromUsers(role);
                session.delete((Object)role);
            }
        }
    }
}

